/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.jeed.jei;

import java.util.List;
import java.util.stream.Collectors;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IModIngredientRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.runtime.IIngredientVisibility;
import mezz.jei.api.runtime.IJeiRuntime;
import net.mehvahdjukaar.jeed.Jeed;
import net.mehvahdjukaar.jeed.jei.EffectInfoRecipe;
import net.mehvahdjukaar.jeed.jei.EffectRecipeCategory;
import net.mehvahdjukaar.jeed.jei.ingredient.EffectInstanceHelper;
import net.mehvahdjukaar.jeed.jei.ingredient.EffectInstanceRenderer;
import net.mehvahdjukaar.jeed.jei.plugins.VanillaPlugin;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraftforge.registries.ForgeRegistries;

@JeiPlugin
public class JEIPlugin
implements IModPlugin {
    private static final ResourceLocation ID = Jeed.res("jei_plugin");
    public static final IIngredientType<MobEffectInstance> EFFECT = () -> MobEffectInstance.class;
    public static IJeiRuntime JEI_RUNTIME;
    public static IJeiHelpers JEI_HELPERS;
    public static IIngredientVisibility JEI_INGREDIENT_VISIBILITY;

    public ResourceLocation getPluginUid() {
        return ID;
    }

    public void registerCategories(IRecipeCategoryRegistration registry) {
        registry.addRecipeCategories(new IRecipeCategory[]{new EffectRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
    }

    public void registerIngredients(IModIngredientRegistration registration) {
        registration.register(EFFECT, JEIPlugin.getEffectList(), (IIngredientHelper)new EffectInstanceHelper(), (IIngredientRenderer)EffectInstanceRenderer.INSTANCE);
    }

    public void onRuntimeAvailable(IJeiRuntime jeiRuntime) {
        JEI_RUNTIME = jeiRuntime;
    }

    public void registerRecipes(IRecipeRegistration registry) {
        JEI_INGREDIENT_VISIBILITY = registry.getIngredientVisibility();
        JEI_HELPERS = registry.getJeiHelpers();
        for (MobEffectInstance e : JEIPlugin.getEffectList()) {
            ResourceLocation name = e.m_19544_().getRegistryName();
            this.registerEffectInfo(registry, new MobEffectInstance(e), EFFECT, "effect." + name.m_135827_() + "." + name.m_135815_() + ".description");
        }
    }

    private static List<MobEffectInstance> getEffectList() {
        return ForgeRegistries.MOB_EFFECTS.getValues().stream().filter(e -> !((List)Jeed.HIDDEN_EFFECTS.get()).contains(e.getRegistryName().toString())).map(MobEffectInstance::new).filter(MobEffectInstance::m_19575_).filter(MobEffectInstance::m_19572_).collect(Collectors.toList());
    }

    public void registerEffectInfo(IRecipeRegistration registration, MobEffectInstance ingredient, IIngredientType<MobEffectInstance> ingredientType, String descriptionKey) {
        List<EffectInfoRecipe> recipes = EffectInfoRecipe.create(ingredient, ingredientType, descriptionKey);
        registration.addRecipes(recipes, EffectRecipeCategory.UID);
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        if (!Jeed.REI) {
            VanillaPlugin.registerGuiHandlers(registration);
        }
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        VanillaPlugin.registerRecipeCatalysts(registration);
    }
}

