/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.jeed.jei.ingredient;

import com.google.common.base.MoreObjects;
import java.util.Collection;
import java.util.Collections;
import javax.annotation.Nullable;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.subtypes.UidContext;
import net.mehvahdjukaar.jeed.jei.JEIPlugin;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.fluids.FluidStack;

public class EffectInstanceHelper
implements IIngredientHelper<MobEffectInstance> {
    @Nullable
    public MobEffectInstance getMatch(Iterable<MobEffectInstance> ingredients, MobEffectInstance toMatch) {
        for (MobEffectInstance effect : ingredients) {
            if (!toMatch.equals((Object)effect)) continue;
            return effect;
        }
        return null;
    }

    public IIngredientType<MobEffectInstance> getIngredientType() {
        return JEIPlugin.EFFECT;
    }

    public String getDisplayName(MobEffectInstance ingredient) {
        Component displayName = ingredient.m_19544_().m_19482_();
        return displayName.getString();
    }

    public String getUniqueId(MobEffectInstance ingredient, UidContext uidContext) {
        ResourceLocation registryName = ingredient.m_19544_().getRegistryName();
        return "effect:" + registryName;
    }

    public ResourceLocation getResourceLocation(MobEffectInstance ingredient) {
        ResourceLocation registryName = ingredient.m_19544_().getRegistryName();
        if (registryName == null) {
            String ingredientInfo = this.getErrorInfo(ingredient);
            throw new IllegalStateException("effect.getRegistryName() returned null for: " + ingredientInfo);
        }
        return registryName;
    }

    public String getModId(MobEffectInstance ingredient) {
        ResourceLocation registryName = ingredient.m_19544_().getRegistryName();
        if (registryName == null) {
            String ingredientInfo = this.getErrorInfo(ingredient);
            throw new IllegalStateException("effect.getRegistryName() returned null for: " + ingredientInfo);
        }
        return registryName.m_135827_();
    }

    public String getResourceId(MobEffectInstance ingredient) {
        ResourceLocation registryName = ingredient.m_19544_().getRegistryName();
        if (registryName == null) {
            String ingredientInfo = this.getErrorInfo(ingredient);
            throw new IllegalStateException("ingredient.getRegistryName() returned null for: " + ingredientInfo);
        }
        return registryName.m_135815_();
    }

    public Iterable<Integer> getColors(MobEffectInstance ingredient) {
        return Collections.singletonList(ingredient.m_19544_().m_19484_());
    }

    public ItemStack getCheatItemStack(MobEffectInstance ingredient) {
        return PotionUtils.m_43552_((ItemStack)new ItemStack((ItemLike)Items.f_42589_), Collections.singletonList(this.normalizeIngredient(ingredient)));
    }

    public Collection<ResourceLocation> getTags(MobEffectInstance ingredient) {
        return Collections.singletonList(new ResourceLocation("jeed", "effects"));
    }

    public MobEffectInstance copyIngredient(MobEffectInstance ingredient) {
        return new MobEffectInstance(ingredient.m_19544_(), ingredient.m_19557_(), ingredient.m_19564_(), ingredient.m_19571_(), ingredient.m_19572_(), ingredient.m_19575_());
    }

    public MobEffectInstance normalizeIngredient(MobEffectInstance ingredient) {
        return new MobEffectInstance(ingredient.m_19544_(), 600);
    }

    public String getErrorInfo(@Nullable MobEffectInstance ingredient) {
        if (ingredient == null) {
            return "null";
        }
        MoreObjects.ToStringHelper toStringHelper = MoreObjects.toStringHelper(FluidStack.class);
        MobEffect effect = ingredient.m_19544_();
        if (effect != null) {
            Component displayName = ingredient.m_19544_().m_19482_();
            toStringHelper.add("Effect", (Object)displayName.getString());
        } else {
            toStringHelper.add("Effect", (Object)"null");
        }
        toStringHelper.add("Duration", ingredient.m_19557_());
        toStringHelper.add("Amplifier", ingredient.m_19564_());
        return toStringHelper.toString();
    }
}

