/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.jeed.jei.plugins;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import mezz.jei.api.gui.handlers.IGuiContainerHandler;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.runtime.IRecipesGui;
import net.mehvahdjukaar.jeed.jei.JEIPlugin;
import net.mehvahdjukaar.jeed.mixins.DisplayEffectScreenAccessor;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.EffectRenderingInventoryScreen;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.client.ForgeHooksClient;
import org.jetbrains.annotations.Nullable;

public class InventoryScreenHandler<C extends AbstractContainerMenu, T extends EffectRenderingInventoryScreen<C>>
implements IGuiContainerHandler<T> {
    @Nullable
    public Object getIngredientUnderMouse(T screen, double x, double y) {
        return InventoryScreenHandler.getHoveredEffect(screen, x, y, false);
    }

    @Nullable
    public static MobEffectInstance getHoveredEffect(AbstractContainerScreen<?> screen, double mouseX, double mouseY, boolean ignoreIfSmall) {
        DisplayEffectScreenAccessor accessor;
        boolean cancelShift = screen instanceof DisplayEffectScreenAccessor && (accessor = (DisplayEffectScreenAccessor)screen).isCancelShift();
        int minX = cancelShift ? (screen.f_96543_ - screen.getXSize()) / 2 : screen.getGuiLeft() + screen.getXSize() + 2;
        int x = screen.f_96543_ - minX;
        Collection collection = Minecraft.m_91087_().f_91074_.m_21220_();
        if (!collection.isEmpty() && x >= 32) {
            int width;
            boolean full;
            boolean bl = full = x >= 120;
            if (!full && ignoreIfSmall) {
                return null;
            }
            int n = width = full ? 120 : 32;
            if (mouseX > (double)minX && mouseX < (double)(minX + width)) {
                int spacing = 33;
                if (collection.size() > 5) {
                    spacing = 132 / (collection.size() - 1);
                }
                List iterable = collection.stream().filter(ForgeHooksClient::shouldRenderEffect).sorted().collect(Collectors.toList());
                int minY = screen.getGuiTop();
                int maxHeight = iterable.size() * spacing;
                if (mouseY > (double)minY && mouseY < (double)(minY + maxHeight)) {
                    return (MobEffectInstance)iterable.get((int)((mouseY - (double)minY) / (double)spacing));
                }
            }
        }
        return null;
    }

    public static void onClickedEffect(MobEffectInstance effect, double x, double y, int button) {
        IFocus focus = JEIPlugin.JEI_HELPERS.getFocusFactory().createFocus(RecipeIngredientRole.INPUT, JEIPlugin.EFFECT, (Object)effect);
        IRecipesGui recipesGui = JEIPlugin.JEI_RUNTIME.getRecipesGui();
        recipesGui.show(focus);
    }
}

