/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.client.events;

import com.direwolf20.buildinggadgets.client.cache.RemoteInventoryCache;
import com.direwolf20.buildinggadgets.common.capability.CapabilityTemplate;
import com.direwolf20.buildinggadgets.common.items.GadgetCopyPaste;
import com.direwolf20.buildinggadgets.common.items.OurItems;
import com.direwolf20.buildinggadgets.common.tainted.building.view.BuildContext;
import com.direwolf20.buildinggadgets.common.tainted.inventory.IItemIndex;
import com.direwolf20.buildinggadgets.common.tainted.inventory.InventoryHelper;
import com.direwolf20.buildinggadgets.common.tainted.inventory.MatchResult;
import com.direwolf20.buildinggadgets.common.tainted.inventory.materials.MaterialList;
import com.direwolf20.buildinggadgets.common.tainted.inventory.materials.objects.IUniqueObject;
import com.direwolf20.buildinggadgets.common.tainted.inventory.materials.objects.UniqueItem;
import com.direwolf20.buildinggadgets.common.tainted.template.ITemplateKey;
import com.direwolf20.buildinggadgets.common.tainted.template.Template;
import com.direwolf20.buildinggadgets.common.tainted.template.TemplateHeader;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.Multiset;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Comparator;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="buildinggadgets", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class EventTooltip {
    private static final Comparator<Multiset.Entry<IUniqueObject<?>>> ENTRY_COMPARATOR = Comparator.comparing(Multiset.Entry::getCount).reversed().thenComparing(e -> ((IUniqueObject)e.getElement()).getObjectRegistryName());
    private static final int STACKS_PER_LINE = 16;
    private static RemoteInventoryCache cache = new RemoteInventoryCache(true);

    public static void setCache(Multiset<UniqueItem> cache) {
        EventTooltip.cache.setCache(cache);
    }

    private static int renderRequiredBlocks(PoseStack matrices, ItemRenderer itemRenderer, ItemStack itemStack, int x, int y, int count, int req) {
        Minecraft mc = Minecraft.m_91087_();
        String s1 = req == Integer.MAX_VALUE ? "\u221e" : Integer.toString(req);
        int w1 = mc.f_91062_.m_92895_(s1);
        boolean hasReq = req > 0;
        itemRenderer.m_115203_(itemStack, x, y);
        itemRenderer.m_115169_(mc.f_91062_, itemStack, x, y);
        MultiBufferSource.BufferSource irendertypebuffer$impl = Minecraft.m_91087_().m_91269_().m_110104_();
        matrices.m_85836_();
        matrices.m_85837_((double)((float)(x + 8) - (float)w1 / 4.0f), (double)(y + (hasReq ? 12 : 14)), (double)(itemRenderer.f_115093_ + 250.0f));
        matrices.m_85841_(0.5f, 0.5f, 0.0f);
        mc.f_91062_.m_92883_(matrices, s1, 0.0f, 0.0f, 0xFFFFFF);
        matrices.m_85849_();
        int missingCount = 0;
        if (hasReq && count < req) {
            String fs = Integer.toString(req - count);
            String s2 = "(" + fs + ")";
            int w2 = mc.f_91062_.m_92895_(s2);
            matrices.m_85836_();
            matrices.m_85837_((double)((float)(x + 8) - (float)w2 / 4.0f), (double)(y + 17), (double)(itemRenderer.f_115093_ + 250.0f));
            matrices.m_85841_(0.5f, 0.5f, 0.0f);
            mc.f_91062_.m_92811_(s2, 0.0f, 0.0f, 0xFF0000, true, matrices.m_85850_().m_85861_(), (MultiBufferSource)irendertypebuffer$impl, false, 0, 0xF000F0);
            matrices.m_85849_();
            missingCount = req - count;
        }
        irendertypebuffer$impl.m_109911_();
        return missingCount;
    }

    public static class CopyPasteTooltipComponent
    implements ClientTooltipComponent {
        Data tooltipData;

        public CopyPasteTooltipComponent(Data tooltipComponent) {
            this.tooltipData = tooltipComponent;
        }

        public int m_142103_() {
            return Screen.m_96638_() && this.tooltipData.data != null ? 20 + this.tooltipData.data.sortedEntries.size() / 16 * 20 : 0;
        }

        public int m_142069_(Font font) {
            return Screen.m_96638_() && this.tooltipData.data != null ? (this.tooltipData.data.sortedEntries.size() <= 16 ? this.tooltipData.data.sortedEntries.size() * 18 : 288) : 0;
        }

        public void m_183452_(Font font, int x, int y, PoseStack poseStack, ItemRenderer itemRenderer, int p_194053_) {
            if (this.tooltipData.stack == null || !(this.tooltipData.stack.m_41720_() instanceof GadgetCopyPaste)) {
                return;
            }
            Minecraft mc = Minecraft.m_91087_();
            if (mc.f_91073_ == null || mc.f_91074_ == null || !Screen.m_96638_() || this.tooltipData.data == null) {
                return;
            }
            int bx = x;
            int by = y;
            int j = 0;
            int totalMissing = 0;
            RenderSystem.m_69478_();
            RenderSystem.m_69405_((int)770, (int)771);
            for (Multiset.Entry<IUniqueObject<?>> entry : this.tooltipData.data.sortedEntries) {
                int xx = bx + j % 16 * 18;
                int yy = by + j / 16 * 20;
                totalMissing += EventTooltip.renderRequiredBlocks(poseStack, itemRenderer, ((IUniqueObject)entry.getElement()).createStack(), xx, yy, this.tooltipData.data.existing.count(entry.getElement()), entry.getCount());
                ++j;
            }
            if (!this.tooltipData.data.match.isSuccess()) {
                UniqueItem pasteItem = new UniqueItem((Item)OurItems.CONSTRUCTION_PASTE_ITEM.get());
                ImmutableMultiset pasteSet = ImmutableMultiset.builder().addCopies((Object)pasteItem, totalMissing).build();
                int hasAmt = this.tooltipData.data.index.tryMatch((Multiset<IUniqueObject<?>>)pasteSet).getFoundItems().count((Object)pasteItem);
                int xx = bx + j % 16 * 18;
                int yy = by + j / 16 * 20;
                int required = Integer.MAX_VALUE;
                try {
                    required = Math.toIntExact(totalMissing);
                }
                catch (ArithmeticException arithmeticException) {
                    // empty catch block
                }
                EventTooltip.renderRequiredBlocks(poseStack, itemRenderer, pasteItem.createStack(), xx, yy, hasAmt, required);
            }
        }

        public static class Data
        implements TooltipComponent {
            public ItemStack stack;
            public TemplateData data;

            public Data(ItemStack stack) {
                this.stack = stack;
                Minecraft mc = Minecraft.m_91087_();
                mc.f_91073_.getCapability(CapabilityTemplate.TEMPLATE_PROVIDER_CAPABILITY).ifPresent(provider -> stack.getCapability(CapabilityTemplate.TEMPLATE_KEY_CAPABILITY).ifPresent(templateKey -> {
                    Template template = provider.getTemplateForKey((ITemplateKey)templateKey);
                    IItemIndex index = InventoryHelper.index(stack, (Player)mc.f_91074_);
                    BuildContext buildContext = BuildContext.builder().stack(stack).player((Player)mc.f_91074_).build((LevelAccessor)mc.f_91073_);
                    TemplateHeader header = template.getHeaderAndForceMaterials(buildContext);
                    MaterialList list = header.getRequiredItems();
                    if (list == null) {
                        list = MaterialList.empty();
                    }
                    MatchResult match = index.tryMatch(list);
                    ImmutableMultiset<IUniqueObject<?>> existing = match.getFoundItems();
                    ImmutableList sortedEntries = ImmutableList.sortedCopyOf(ENTRY_COMPARATOR, (Iterable)match.getChosenOption().entrySet());
                    this.data = new TemplateData((Multiset<IUniqueObject<?>>)existing, (List<Multiset.Entry<IUniqueObject<?>>>)sortedEntries, index, match);
                }));
            }
        }

        public record TemplateData(Multiset<IUniqueObject<?>> existing, List<Multiset.Entry<IUniqueObject<?>>> sortedEntries, IItemIndex index, MatchResult match) {
        }
    }
}

