/*
 * Decompiled with CFR 0.152.
 */
package shadows.fastsuite;

import com.google.gson.JsonElement;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import shadows.fastsuite.FastSuite;

public class AuxRecipeManager
extends RecipeManager {
    public boolean active = false;
    private final Map<RecipeType<?>, LinkedRecipeList<?>> linkedRecipes = new HashMap();

    protected void m_5787_(Map<ResourceLocation, JsonElement> objectIn, ResourceManager resourceManagerIn, ProfilerFiller profilerIn) {
        this.active = false;
        super.m_5787_(objectIn, resourceManagerIn, profilerIn);
    }

    public void processInitialRecipes(Map<RecipeType<?>, Map<ResourceLocation, Recipe<?>>> recipes) {
        this.linkedRecipes.clear();
        long recipeCount = 0L;
        for (Map.Entry<RecipeType<?>, Map<ResourceLocation, Recipe<?>>> e : recipes.entrySet()) {
            LinkedRecipeList list = new LinkedRecipeList(e.getValue().values());
            this.linkedRecipes.put(e.getKey(), list);
            recipeCount += (long)e.getValue().size();
        }
        FastSuite.LOG.info("Successfully processed {} recipes into the AuxRecipeManager.", (Object)recipeCount);
        this.active = true;
    }

    public <C extends Container, T extends Recipe<C>> Optional<T> m_44015_(RecipeType<T> type, C inv, Level world) {
        if (!this.active) {
            return super.m_44015_(type, inv, world);
        }
        LinkedRecipeList<C> list = this.getRecipes(type);
        Recipe<C> recipe = list.findFirstMatch(inv, world);
        return Optional.ofNullable(recipe);
    }

    private <C extends Container, T extends Recipe<C>> LinkedRecipeList<C> getRecipes(RecipeType<T> type) {
        return this.linkedRecipes.getOrDefault(type, LinkedRecipeList.EMPTY);
    }

    public <C extends Container, T extends Recipe<C>> NonNullList<ItemStack> m_44069_(RecipeType<T> type, C inv, Level world) {
        if (!this.active) {
            return super.m_44069_(type, inv, world);
        }
        LinkedRecipeList<C> list = this.getRecipes(type);
        Recipe<C> recipe = list.findFirstMatch(inv, world);
        if (recipe != null) {
            return recipe.m_7457_(inv);
        }
        NonNullList nonnulllist = NonNullList.m_122780_((int)inv.m_6643_(), (Object)ItemStack.f_41583_);
        for (int i = 0; i < nonnulllist.size(); ++i) {
            nonnulllist.set(i, (Object)inv.m_8020_(i));
        }
        return nonnulllist;
    }

    public void m_44024_(Iterable<Recipe<?>> recipes) {
        super.m_44024_(recipes);
        this.processInitialRecipes(this.f_44007_);
    }

    public void dump() {
        for (Map.Entry<RecipeType<?>, LinkedRecipeList<?>> e : this.linkedRecipes.entrySet()) {
            FastSuite.LOG.info("Recipes for type {}:", (Object)e.getKey().toString());
            LinkedRecipeList<?> list = e.getValue();
            RecipeNode temp = list.head;
            while (temp != null) {
                FastSuite.LOG.info("{}", (Object)temp.r.m_6423_());
                temp = temp.next;
            }
        }
    }

    public static class LinkedRecipeList<I extends Container> {
        public static final LinkedRecipeList<Container> EMPTY = new LinkedRecipeList(Collections.emptyList());
        RecipeNode<I> head;
        RecipeNode<I> tail;

        public LinkedRecipeList(Collection<Recipe<I>> recipes) {
            for (Recipe<I> r : recipes) {
                if (r == null) continue;
                this.add(new RecipeNode<I>(r));
            }
        }

        void add(RecipeNode<I> node) {
            if (this.head == null) {
                this.head = node;
                this.tail = this.head;
            } else {
                this.tail.next = node;
                node.prev = this.tail;
                this.tail = node;
            }
        }

        void addToHead(RecipeNode<I> node) {
            if (this.head == null) {
                this.head = node;
                this.tail = this.head;
            } else {
                node.next = this.head;
                this.head.prev = node;
                this.head = node;
            }
        }

        void remove(RecipeNode<I> node) {
            if (node == this.head && node == this.tail) {
                this.tail = null;
                this.head = null;
            } else if (node == this.head) {
                this.head = this.head.next;
                if (this.head != null) {
                    this.head.prev = null;
                }
            } else if (node == this.tail) {
                this.tail = this.tail.prev;
                if (this.tail != null) {
                    this.tail.next = null;
                }
            } else {
                node.prev.next = node.next;
                node.next.prev = node.prev;
            }
            node.prev = null;
            node.next = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Recipe<I> findFirstMatch(I inv, Level world) {
            LinkedRecipeList linkedRecipeList = this;
            synchronized (linkedRecipeList) {
                RecipeNode<I> temp = this.head;
                int idx = 0;
                while (temp != null) {
                    if (temp.matches(inv, world)) {
                        if (idx > FastSuite.cacheSize) {
                            this.remove(temp);
                            this.addToHead(temp);
                        }
                        return temp.r;
                    }
                    temp = temp.next;
                    ++idx;
                }
                return null;
            }
        }
    }

    public static class RecipeNode<I extends Container> {
        final Recipe<I> r;
        RecipeNode<I> next;
        RecipeNode<I> prev;

        public RecipeNode(Recipe<I> r) {
            this.r = r;
        }

        public String toString() {
            return String.format("RecipeNode(%s)", this.r.m_6423_());
        }

        boolean matches(I inv, Level world) {
            return this.r.m_5818_(inv, world);
        }
    }
}

