/*
 * Decompiled with CFR 0.152.
 */
package com.mrh0.createaddition.blocks.heater;

import com.mrh0.createaddition.blocks.heater.HeaterBlock;
import com.mrh0.createaddition.config.Config;
import com.mrh0.createaddition.energy.BaseElectricTileEntity;
import com.mrh0.createaddition.item.Multimeter;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.contraptions.goggles.IHaveGoggleInformation;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.level.block.AbstractFurnaceBlock;
import net.minecraft.world.level.block.entity.AbstractFurnaceBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class HeaterTileEntity
extends BaseElectricTileEntity
implements IHaveGoggleInformation {
    public AbstractFurnaceBlockEntity cache;
    private boolean isFurnaceEngine = false;
    public static final int CONSUMPTION = (Integer)Config.HEATER_NORMAL_CONSUMPTION.get();
    public static final int CONSUMPTION_ENGINE = (Integer)Config.HEATER_FURNACE_ENGINE_CONSUMPTION.get();
    public static final boolean ALLOW_ENGINE = (Boolean)Config.HEATER_FURNACE_ENGINE_ENABLED.get();
    private boolean litState = false;
    private static final int MAX_IN = (Integer)Config.HEATER_MAX_INPUT.get();
    private static final int MAX_OUT = 0;
    private static final int CAPACITY = (Integer)Config.HEATER_CAPACITY.get();
    int timeout;

    public HeaterTileEntity(BlockEntityType<?> tileEntityTypeIn, BlockPos pos, BlockState state) {
        super(tileEntityTypeIn, pos, state, CAPACITY, MAX_IN, 0);
        this.setLazyTickRate(20);
    }

    @Override
    public boolean isEnergyInput(Direction side) {
        return side == ((Direction)this.m_58900_().m_61143_((Property)HeaterBlock.FACING)).m_122424_();
    }

    @Override
    public boolean isEnergyOutput(Direction side) {
        return false;
    }

    @Override
    public void tick() {
        super.tick();
        if (this.f_58857_.m_5776_()) {
            return;
        }
        if (this.cache == null) {
            return;
        }
        if (this.cache.m_58901_()) {
            this.cache = null;
        }
        if (this.cache == null) {
            return;
        }
        ContainerData data = this.cache.f_58311_;
        --this.timeout;
        if (this.timeout < 0) {
            this.timeout = 0;
        }
        if (this.hasEnoughEnergy()) {
            data.m_8050_(0, Math.min(200, data.m_6413_(0) + 2));
            if (!this.litState && this.timeout <= 0) {
                this.updateState(true);
            }
        } else if (this.litState && data.m_6413_(0) < 1 && this.timeout <= 0) {
            this.updateState(false);
        }
        if (this.hasEnoughEnergy()) {
            this.energy.internalConsumeEnergy(this.getConsumption());
        }
    }

    public void refreshCache() {
        Direction d = (Direction)this.m_58900_().m_61143_((Property)HeaterBlock.FACING);
        BlockEntity te = this.f_58857_.m_7702_(this.f_58858_.m_142300_(d));
        this.cache = te instanceof AbstractFurnaceBlockEntity ? (AbstractFurnaceBlockEntity)te : null;
        this.isFurnaceEngine = this.hasFurnaceEngine();
    }

    public boolean hasEnoughEnergy() {
        if (!ALLOW_ENGINE && this.isFurnaceEngine) {
            return false;
        }
        return this.energy.getEnergyStored() > this.getConsumption();
    }

    public boolean hasFurnaceEngine() {
        Direction dir = (Direction)this.m_58900_().m_61143_((Property)HeaterBlock.FACING);
        BlockPos origin = this.f_58858_.m_142300_(dir);
        for (Direction d : Direction.values()) {
            if (this.f_58857_.m_8055_(origin.m_142300_(d)).m_60734_() != AllBlocks.FURNACE_ENGINE.get()) continue;
            return true;
        }
        return false;
    }

    public int getConsumption() {
        return this.isFurnaceEngine ? CONSUMPTION_ENGINE : CONSUMPTION;
    }

    public void lazyTick() {
        super.lazyTick();
        this.isFurnaceEngine = this.hasFurnaceEngine();
    }

    public void updateState(boolean lit) {
        this.timeout = 10;
        Direction d = (Direction)this.m_58900_().m_61143_((Property)HeaterBlock.FACING);
        BlockState state = this.f_58857_.m_8055_(this.f_58858_.m_142300_(d));
        if (state.m_60734_() instanceof AbstractFurnaceBlock && (Boolean)state.m_61143_((Property)AbstractFurnaceBlock.f_48684_) != lit) {
            this.f_58857_.m_46597_(this.f_58858_.m_142300_(d), (BlockState)state.m_61124_((Property)AbstractFurnaceBlock.f_48684_, (Comparable)Boolean.valueOf(lit)));
        }
        this.causeBlockUpdate();
        this.litState = lit;
    }

    @Override
    public void firstTick() {
        super.firstTick();
        this.refreshCache();
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        tooltip.add((Component)new TextComponent("    ").m_7220_((Component)new TranslatableComponent("block.createaddition.heater.info").m_130940_(ChatFormatting.WHITE)));
        if (this.isFurnaceEngine && !ALLOW_ENGINE) {
            tooltip.add((Component)new TextComponent("    ").m_7220_((Component)new TranslatableComponent("block.createaddition.heater.engine_heating_disabled").m_130940_(ChatFormatting.RED)));
        }
        tooltip.add((Component)new TextComponent("    ").m_7220_((Component)new TranslatableComponent("createaddition.tooltip.energy.consumption").m_130940_(ChatFormatting.GRAY)));
        tooltip.add((Component)new TextComponent("    ").m_7220_((Component)new TextComponent(" " + Multimeter.format(this.hasEnoughEnergy() ? this.getConsumption() : 0) + "fe/t ")).m_130940_(ChatFormatting.AQUA));
        return true;
    }
}

