/*
 * Decompiled with CFR 0.152.
 */
package com.mrh0.createaddition.blocks.redstone_relay;

import com.mrh0.createaddition.blocks.redstone_relay.RedstoneRelay;
import com.mrh0.createaddition.config.Config;
import com.mrh0.createaddition.energy.IWireNode;
import com.mrh0.createaddition.energy.WireType;
import com.mrh0.createaddition.energy.network.EnergyNetwork;
import com.mrh0.createaddition.index.CABlocks;
import com.mrh0.createaddition.item.Multimeter;
import com.mrh0.createaddition.network.EnergyNetworkPacket;
import com.mrh0.createaddition.network.IObserveTileEntity;
import com.mrh0.createaddition.network.ObservePacket;
import com.simibubi.create.content.contraptions.goggles.IHaveGoggleInformation;
import com.simibubi.create.foundation.tileEntity.SmartTileEntity;
import com.simibubi.create.foundation.tileEntity.TileEntityBehaviour;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class RedstoneRelayTileEntity
extends SmartTileEntity
implements IWireNode,
IHaveGoggleInformation,
IObserveTileEntity {
    private BlockPos[] connectionPos = new BlockPos[this.getNodeCount()];
    private int[] connectionIndecies = new int[this.getNodeCount()];
    private WireType[] connectionTypes = new WireType[this.getNodeCount()];
    public IWireNode[] nodeCache = new IWireNode[this.getNodeCount()];
    public static Vec3 OFFSET_NORTH = new Vec3(0.0, -0.0625, -0.3125);
    public static Vec3 OFFSET_WEST = new Vec3(-0.3125, -0.0625, 0.0);
    public static Vec3 OFFSET_SOUTH = new Vec3(0.0, -0.0625, 0.3125);
    public static Vec3 OFFSET_EAST = new Vec3(0.3125, -0.0625, 0.0);
    public static Vec3 IN_VERTICAL_OFFSET_NORTH = new Vec3(0.3125, 0.0, -0.0625);
    public static Vec3 IN_VERTICAL_OFFSET_WEST = new Vec3(-0.0625, 0.0, -0.3125);
    public static Vec3 IN_VERTICAL_OFFSET_SOUTH = new Vec3(-0.3125, 0.0, 0.0625);
    public static Vec3 IN_VERTICAL_OFFSET_EAST = new Vec3(0.0625, 0.0, 0.3125);
    public static Vec3 OUT_VERTICAL_OFFSET_NORTH = new Vec3(-0.3125, 0.0, -0.0625);
    public static Vec3 OUT_VERTICAL_OFFSET_WEST = new Vec3(-0.0625, 0.0, 0.3125);
    public static Vec3 OUT_VERTICAL_OFFSET_SOUTH = new Vec3(0.3125, 0.0, 0.0625);
    public static Vec3 OUT_VERTICAL_OFFSET_EAST = new Vec3(0.0625, 0.0, -0.3125);
    public static final int CAPACITY = (Integer)Config.ACCUMULATOR_CAPACITY.get();
    public static final int MAX_IN = (Integer)Config.ACCUMULATOR_MAX_INPUT.get();
    public static final int MAX_OUT = (Integer)Config.ACCUMULATOR_MAX_OUTPUT.get();
    private int demand = 0;
    private EnergyNetwork networkIn;
    private EnergyNetwork networkOut;

    public RedstoneRelayTileEntity(BlockEntityType<?> tileEntityTypeIn, BlockPos pos, BlockState state) {
        super(tileEntityTypeIn, pos, state);
    }

    @Override
    public IWireNode getNode(int node) {
        if (this.getNodeType(node) == null) {
            this.nodeCache[node] = null;
            return null;
        }
        if (this.nodeCache[node] == null) {
            this.nodeCache[node] = IWireNode.getWireNode(this.f_58857_, this.getNodePos(node));
        }
        if (this.nodeCache[node] == null) {
            this.setNode(node, -1, null, null);
        }
        return this.nodeCache[node];
    }

    @Override
    public Vec3 getNodeOffset(int node) {
        boolean vertical = (Boolean)this.m_58900_().m_61143_((Property)RedstoneRelay.VERTICAL);
        Direction direction = (Direction)this.m_58900_().m_61143_((Property)RedstoneRelay.HORIZONTAL_FACING);
        if (node > 3) {
            switch (direction) {
                case NORTH: {
                    return vertical ? OUT_VERTICAL_OFFSET_NORTH : OFFSET_NORTH;
                }
                case WEST: {
                    return vertical ? OUT_VERTICAL_OFFSET_WEST : OFFSET_WEST;
                }
                case SOUTH: {
                    return vertical ? OUT_VERTICAL_OFFSET_SOUTH : OFFSET_SOUTH;
                }
                case EAST: {
                    return vertical ? OUT_VERTICAL_OFFSET_EAST : OFFSET_EAST;
                }
            }
        } else {
            switch (direction) {
                case NORTH: {
                    return vertical ? IN_VERTICAL_OFFSET_NORTH : OFFSET_SOUTH;
                }
                case WEST: {
                    return vertical ? IN_VERTICAL_OFFSET_WEST : OFFSET_EAST;
                }
                case SOUTH: {
                    return vertical ? IN_VERTICAL_OFFSET_SOUTH : OFFSET_NORTH;
                }
                case EAST: {
                    return vertical ? IN_VERTICAL_OFFSET_EAST : OFFSET_WEST;
                }
            }
        }
        return OFFSET_NORTH;
    }

    @Override
    public boolean isNodeInput(int node) {
        return node < 4;
    }

    @Override
    public boolean isNodeOutput(int node) {
        return !this.isNodeInput(node);
    }

    @Override
    public int getNodeFromPos(Vec3 vec) {
        Direction dir = (Direction)this.f_58857_.m_8055_(this.f_58858_).m_61143_((Property)RedstoneRelay.HORIZONTAL_FACING);
        boolean vertical = (Boolean)this.f_58857_.m_8055_(this.f_58858_).m_61143_((Property)RedstoneRelay.VERTICAL);
        boolean upper = true;
        vec = vec.m_82492_((double)this.f_58858_.m_123341_(), (double)this.f_58858_.m_123342_(), (double)this.f_58858_.m_123343_());
        if (vertical) {
            switch (dir) {
                case NORTH: {
                    upper = vec.m_7096_() < 0.5;
                    break;
                }
                case WEST: {
                    upper = vec.m_7094_() > 0.5;
                    break;
                }
                case SOUTH: {
                    upper = vec.m_7096_() > 0.5;
                    break;
                }
                case EAST: {
                    upper = vec.m_7094_() < 0.5;
                    break;
                }
            }
        } else {
            switch (dir) {
                case NORTH: {
                    upper = vec.m_7094_() < 0.5;
                    break;
                }
                case WEST: {
                    upper = vec.m_7096_() < 0.5;
                    break;
                }
                case SOUTH: {
                    upper = vec.m_7094_() > 0.5;
                    break;
                }
                case EAST: {
                    upper = vec.m_7096_() > 0.5;
                    break;
                }
            }
        }
        for (int i = upper ? 4 : 0; i < (upper ? 8 : 4); ++i) {
            if (this.hasConnection(i)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public BlockPos getNodePos(int node) {
        return this.connectionPos[node];
    }

    @Override
    public WireType getNodeType(int node) {
        return this.connectionTypes[node];
    }

    @Override
    public int getOtherNodeIndex(int node) {
        if (this.connectionPos[node] == null) {
            return -1;
        }
        return this.connectionIndecies[node];
    }

    @Override
    public void setNode(int node, int other, BlockPos pos, WireType type) {
        this.connectionPos[node] = pos;
        this.connectionIndecies[node] = other;
        this.connectionTypes[node] = type;
        if (this.networkIn != null) {
            this.networkIn.invalidate();
        }
        if (this.networkOut != null) {
            this.networkOut.invalidate();
        }
    }

    public void read(CompoundTag nbt, boolean clientPacket) {
        super.read(nbt, clientPacket);
        for (int i = 0; i < this.getNodeCount(); ++i) {
            if (!IWireNode.hasNode(nbt, i)) continue;
            this.readNode(nbt, i);
        }
    }

    public void write(CompoundTag nbt, boolean clientPacket) {
        super.write(nbt, clientPacket);
        for (int i = 0; i < this.getNodeCount(); ++i) {
            if (this.getNodeType(i) == null) {
                IWireNode.clearNode(nbt, i);
                continue;
            }
            this.writeNode(nbt, i);
        }
    }

    @Override
    public void removeNode(int other) {
        IWireNode.super.removeNode(other);
        this.invalidateNodeCache();
        this.m_6596_();
        if (this.networkIn != null) {
            this.networkIn.invalidate();
        }
        if (this.networkOut != null) {
            this.networkOut.invalidate();
        }
    }

    @Override
    public int getNodeCount() {
        return 8;
    }

    @Override
    public BlockPos getMyPos() {
        return this.f_58858_;
    }

    @Override
    public void invalidateNodeCache() {
        for (int i = 0; i < this.getNodeCount(); ++i) {
            this.nodeCache[i] = null;
        }
    }

    public void tick() {
        super.tick();
        if (this.f_58857_.m_5776_()) {
            return;
        }
        this.networkTick();
    }

    private void networkTick() {
        BlockState bs;
        if (this.awakeNetwork(this.f_58857_)) {
            this.causeBlockUpdate();
        }
        if (!(bs = this.m_58900_()).m_60713_((Block)CABlocks.REDSTONE_RELAY.get())) {
            return;
        }
        if (((Boolean)bs.m_61143_((Property)RedstoneRelay.POWERED)).booleanValue()) {
            this.networkOut.push(this.networkIn.pull(this.demand));
            this.demand = this.networkIn.demand(this.networkOut.getDemand());
        }
    }

    public void m_7651_() {
        for (int i = 0; i < this.getNodeCount(); ++i) {
            if (this.getNodeType(i) == null) continue;
            IWireNode node = this.getNode(i);
            if (node == null) break;
            node.removeNode(this.getOtherNodeIndex(i));
            node.invalidateNodeCache();
        }
        this.invalidateNodeCache();
        this.invalidateCaps();
        if (this.networkIn != null) {
            this.networkIn.invalidate();
        }
        if (this.networkOut != null) {
            this.networkOut.invalidate();
        }
        super.m_7651_();
    }

    @Override
    public EnergyNetwork getNetwork(int node) {
        return this.isNodeInput(node) ? this.networkIn : this.networkOut;
    }

    @Override
    public void setNetwork(int node, EnergyNetwork network) {
        if (this.isNodeInput(node)) {
            this.networkIn = network;
        }
        if (this.isNodeOutput(node)) {
            this.networkOut = network;
        }
    }

    @Override
    public boolean isNodeIndeciesConnected(int in, int other) {
        return this.isNodeInput(in) == this.isNodeInput(other);
    }

    public void addBehaviours(List<TileEntityBehaviour> behaviours) {
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        HitResult ray = Minecraft.m_91087_().f_91077_;
        if (ray == null) {
            return false;
        }
        int node = this.getNodeFromPos(ray.m_82450_());
        ObservePacket.send(this.f_58858_, node);
        tooltip.add((Component)new TextComponent("    ").m_7220_((Component)new TranslatableComponent("createaddition.tooltip.relay.info").m_130940_(ChatFormatting.WHITE)));
        tooltip.add((Component)new TextComponent("    ").m_7220_((Component)new TranslatableComponent("createaddition.tooltip.energy.selected").m_130940_(ChatFormatting.GRAY)));
        tooltip.add((Component)new TextComponent("    ").m_7220_((Component)new TextComponent(" ")).m_7220_((Component)new TranslatableComponent(this.isNodeInput(node) ? "createaddition.tooltip.energy.input" : "createaddition.tooltip.energy.output").m_130940_(ChatFormatting.AQUA)));
        tooltip.add((Component)new TextComponent("    ").m_7220_((Component)new TranslatableComponent("createaddition.tooltip.energy.usage").m_130940_(ChatFormatting.GRAY)));
        tooltip.add((Component)new TextComponent("    ").m_130946_(" ").m_130946_(Multimeter.format(EnergyNetworkPacket.clientBuff)).m_130946_("fe/t").m_130940_(ChatFormatting.AQUA));
        return true;
    }

    @Override
    public void onObserved(ServerPlayer player, ObservePacket pack) {
        if (this.isNetworkValid(0)) {
            EnergyNetworkPacket.send(this.f_58858_, this.getNetwork(pack.getNode()).getPulled(), this.getNetwork(pack.getNode()).getPushed(), player);
        }
    }
}

