/*
 * Decompiled with CFR 0.152.
 */
package com.mrh0.createaddition.item;

import com.mojang.authlib.GameProfile;
import com.mrh0.createaddition.energy.IWireNode;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class Multimeter
extends Item {
    public Multimeter(Item.Properties props) {
        super(props);
    }

    public InteractionResult m_6225_(UseOnContext c) {
        BlockEntity te = c.m_43725_().m_7702_(c.m_8083_());
        if (te != null && !c.m_43725_().m_5776_()) {
            LazyOptional cap = te.getCapability(CapabilityEnergy.ENERGY, c.m_43719_());
            if (te instanceof IWireNode) {
                IWireNode wn = (IWireNode)te;
                for (int i = 0; i < wn.getNodeCount(); ++i) {
                    System.out.println(wn.getNetwork(i));
                }
            }
            if (cap != null) {
                IEnergyStorage energy = (IEnergyStorage)cap.orElse(null);
                Object measur = new TranslatableComponent("item.createaddition.multimeter.measuring").m_130668_(Integer.MAX_VALUE);
                CompoundTag tag = c.m_43722_().m_41783_();
                if (tag == null) {
                    tag = new CompoundTag();
                }
                if (Multimeter.hasPos(tag)) {
                    if (Multimeter.posEquals(tag, c.m_8083_(), c.m_43719_())) {
                        int de = Multimeter.getDeltaEnergy(tag, energy != null ? energy.getEnergyStored() : 0);
                        long dt = Multimeter.getDeltaTime(tag, c.m_43725_().m_46467_());
                        measur = " [" + (dt > 0L ? (long)de / dt : 0L) + "fe/t (" + dt + new TranslatableComponent("item.createaddition.multimeter.ticks").m_130668_(Integer.MAX_VALUE) + ")]";
                        Multimeter.clearPos(tag);
                    } else {
                        Multimeter.setContent(tag, c.m_8083_(), c.m_43719_(), c.m_43725_().m_46467_(), energy != null ? energy.getEnergyStored() : 0);
                    }
                } else {
                    Multimeter.setContent(tag, c.m_8083_(), c.m_43719_(), c.m_43725_().m_46467_(), energy != null ? energy.getEnergyStored() : 0);
                }
                c.m_43722_().m_41751_(tag);
                c.m_43723_().m_6352_((Component)new TranslatableComponent("item.createaddition.multimeter.title").m_7220_((Component)new TextComponent(" ").m_7220_(Multimeter.getTextComponent(energy, new TranslatableComponent("item.createaddition.multimeter.no_capability").m_130668_(Integer.MAX_VALUE), "fe")).m_7220_((Component)new TextComponent(" " + (String)measur))), Player.m_36198_((GameProfile)c.m_43723_().m_36316_()));
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    public static Component getTextComponent(IEnergyStorage ies, String nan, String unit) {
        if (ies == null) {
            return new TextComponent(nan);
        }
        return new TextComponent(Multimeter.format(ies.getEnergyStored()) + unit).m_130940_(ChatFormatting.AQUA).m_7220_((Component)new TextComponent(" / ").m_130940_(ChatFormatting.GRAY)).m_7220_((Component)new TextComponent(Multimeter.format(ies.getMaxEnergyStored()) + unit));
    }

    public static Component getTextComponent(IEnergyStorage ies) {
        return Multimeter.getTextComponent(ies, "NaN", "fe");
    }

    public static String format(int n) {
        if (n > 1000000) {
            return (double)Math.round((double)n / 100000.0) / 10.0 + "M";
        }
        if (n > 1000) {
            return (double)Math.round((double)n / 100.0) / 10.0 + "K";
        }
        return "" + n;
    }

    public void m_7373_(ItemStack stack, Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        CompoundTag nbt = stack.m_41783_();
        super.m_7373_(stack, worldIn, tooltip, flagIn);
        if (Multimeter.hasPos(nbt)) {
            tooltip.add((Component)new TranslatableComponent("item.createaddition.multimeter.measuring"));
        }
    }

    public static boolean hasPos(CompoundTag nbt) {
        if (nbt == null) {
            return false;
        }
        return nbt.m_128441_("x") && nbt.m_128441_("y") && nbt.m_128441_("z") && nbt.m_128441_("side");
    }

    public static BlockPos getPos(CompoundTag nbt) {
        if (nbt == null) {
            return null;
        }
        return new BlockPos(nbt.m_128451_("x"), nbt.m_128451_("y"), nbt.m_128451_("z"));
    }

    public static int getDeltaEnergy(CompoundTag nbt, int now) {
        if (nbt == null) {
            return 0;
        }
        int r = now - nbt.m_128451_("start");
        return r;
    }

    public static long getDeltaTime(CompoundTag nbt, long now) {
        if (nbt == null) {
            return 0L;
        }
        long r = now - nbt.m_128454_("tick");
        return r > 0L ? r : 0L;
    }

    public static Direction getDirection(CompoundTag nbt) {
        if (nbt == null) {
            return null;
        }
        return Direction.m_122376_((int)nbt.m_128451_("side"));
    }

    public static boolean posEquals(CompoundTag nbt, BlockPos pos, Direction dir) {
        return nbt.m_128451_("x") == pos.m_123341_() && nbt.m_128451_("y") == pos.m_123342_() && nbt.m_128451_("z") == pos.m_123343_() && nbt.m_128451_("side") == dir.m_122411_();
    }

    public static void clearPos(CompoundTag nbt) {
        nbt.m_128473_("x");
        nbt.m_128473_("y");
        nbt.m_128473_("z");
        nbt.m_128473_("side");
        nbt.m_128473_("tick");
        nbt.m_128473_("start");
    }

    public static CompoundTag setContent(CompoundTag nbt, BlockPos pos, Direction dir, long tick, int energy) {
        if (nbt == null) {
            return new CompoundTag();
        }
        nbt.m_128405_("x", pos.m_123341_());
        nbt.m_128405_("y", pos.m_123342_());
        nbt.m_128405_("z", pos.m_123343_());
        nbt.m_128405_("side", dir.m_122411_());
        nbt.m_128356_("tick", tick);
        nbt.m_128405_("start", energy);
        return nbt;
    }
}

