/*
 * Decompiled with CFR 0.152.
 */
package net.gigabit101.shrink.events;

import net.gigabit101.shrink.api.ShrinkAPI;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class RenderEvents {
    @SubscribeEvent
    public void onRenderPlayerPre(RenderPlayerEvent.Pre event) {
        try {
            Player player = event.getPlayer();
            player.getCapability(ShrinkAPI.SHRINK_CAPABILITY).ifPresent(iShrinkProvider -> {
                if (iShrinkProvider.isShrunk()) {
                    event.getPoseStack().m_85836_();
                    float scale = iShrinkProvider.scale();
                    event.getPoseStack().m_85841_(scale, scale, scale);
                    if (event.getEntity().m_6047_() && scale < 0.2f) {
                        event.getPoseStack().m_85837_(0.0, 1.0, 0.0);
                    }
                } else if (!iShrinkProvider.isShrunk()) {
                    // empty if block
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @SubscribeEvent
    public void onRenderPlayerPost(RenderPlayerEvent.Post event) {
        try {
            Player player = event.getPlayer();
            player.getCapability(ShrinkAPI.SHRINK_CAPABILITY).ifPresent(iShrinkProvider -> {
                if (iShrinkProvider.isShrunk()) {
                    event.getPoseStack().m_85849_();
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @SubscribeEvent
    public void onLivingRenderPre(RenderLivingEvent.Pre event) {
        try {
            LivingEntity livingEntity = event.getEntity();
            if (livingEntity != null && livingEntity instanceof Mob) {
                livingEntity.getCapability(ShrinkAPI.SHRINK_CAPABILITY).ifPresent(iShrinkProvider -> {
                    if (iShrinkProvider.isShrunk()) {
                        event.getPoseStack().m_85836_();
                        event.getPoseStack().m_85841_(iShrinkProvider.scale(), iShrinkProvider.scale(), iShrinkProvider.scale());
                    }
                });
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @SubscribeEvent
    public void onLivingRenderPost(RenderLivingEvent.Post event) {
        try {
            LivingEntity livingEntity = event.getEntity();
            if (livingEntity != null && livingEntity instanceof Mob && livingEntity.getCapability(ShrinkAPI.SHRINK_CAPABILITY).isPresent()) {
                livingEntity.getCapability(ShrinkAPI.SHRINK_CAPABILITY).ifPresent(iShrinkProvider -> {
                    if (iShrinkProvider.isShrunk()) {
                        event.getPoseStack().m_85849_();
                    }
                });
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

