/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.compat;

import java.util.UUID;
import journeymap.client.api.ClientPlugin;
import journeymap.client.api.IClientAPI;
import journeymap.client.api.IClientPlugin;
import journeymap.client.api.display.Displayable;
import journeymap.client.api.display.Waypoint;
import journeymap.client.api.display.WaypointGroup;
import journeymap.client.api.event.ClientEvent;
import net.blay09.mods.waystones.api.IWaystone;
import net.blay09.mods.waystones.api.KnownWaystonesEvent;
import net.blay09.mods.waystones.config.WaystonesConfig;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@ClientPlugin
public class JourneyMapAddon
implements IClientPlugin {
    private static final UUID WAYSTONE_GROUP_ID = UUID.fromString("005bdf11-2dbb-4a27-8aa4-0184e86fa33c");
    private IClientAPI api;

    public void initialize(IClientAPI iClientAPI) {
        this.api = iClientAPI;
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public String getModId() {
        return "waystones";
    }

    public void onEvent(ClientEvent clientEvent) {
    }

    @SubscribeEvent
    public void onKnownWaystones(KnownWaystonesEvent event) {
        if (!WaystonesConfig.getActive().compatibility.displayWaystonesOnJourneyMap) {
            return;
        }
        this.api.removeAll("waystones");
        for (IWaystone waystone : event.getWaystones()) {
            try {
                Waypoint waypoint = new Waypoint("waystones", waystone.getName(), waystone.getDimension(), waystone.getPos());
                waypoint.setEditable(false);
                waypoint.setPersistent(false);
                waypoint.setGroup(new WaypointGroup("waystones", WAYSTONE_GROUP_ID.toString(), "Waystones"));
                this.api.show((Displayable)waypoint);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

