/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.p3pp3rf1y.sophisticatedbackpacks.api.CapabilityBackpackWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.BackpackItem;
import net.p3pp3rf1y.sophisticatedbackpacks.client.ClientEventHandler;
import net.p3pp3rf1y.sophisticatedbackpacks.client.render.BackpackModel;
import net.p3pp3rf1y.sophisticatedbackpacks.util.PlayerInventoryProvider;
import net.p3pp3rf1y.sophisticatedcore.api.IUpgradeRenderer;
import net.p3pp3rf1y.sophisticatedcore.client.render.UpgradeRenderRegistry;
import net.p3pp3rf1y.sophisticatedcore.renderdata.IUpgradeRenderData;
import net.p3pp3rf1y.sophisticatedcore.renderdata.RenderInfo;
import net.p3pp3rf1y.sophisticatedcore.renderdata.UpgradeRenderDataType;

public class BackpackLayerRenderer<T extends LivingEntity, M extends HumanoidModel<T>>
extends RenderLayer<T, M> {
    private static final float CHILD_Y_OFFSET = 0.3f;
    private static final float CHILD_Z_OFFSET = 0.1f;
    private static final float CHILD_SCALE = 0.55f;
    private static final Map<EntityType<?>, Vec3> entityTranslations = new HashMap();
    private static BackpackModel model;

    public BackpackLayerRenderer(RenderLayerParent<T, M> entityRendererIn) {
        super(entityRendererIn);
        if (model == null) {
            EntityModelSet entityModels = Minecraft.m_91087_().m_167973_();
            model = new BackpackModel(entityModels.m_171103_(ClientEventHandler.BACKPACK_LAYER));
        }
    }

    public void render(PoseStack matrixStack, MultiBufferSource buffer, int packedLight, T entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        if (entity instanceof AbstractClientPlayer) {
            AbstractClientPlayer player = (AbstractClientPlayer)entity;
            PlayerInventoryProvider.get().getBackpackFromRendered((Player)player).ifPresent(backpackRenderInfo -> {
                matrixStack.m_85836_();
                boolean wearsArmor = !backpackRenderInfo.isArmorSlot() && !((ItemStack)player.m_150109_().f_35975_.get(EquipmentSlot.CHEST.m_20749_())).m_41619_();
                ItemStack backpack = backpackRenderInfo.getBackpack();
                BackpackLayerRenderer.renderBackpack((LivingEntity)player, matrixStack, buffer, packedLight, backpack, wearsArmor, model);
                matrixStack.m_85849_();
            });
        } else {
            ItemStack chestStack = entity.m_6844_(EquipmentSlot.CHEST);
            if (chestStack.m_41720_() instanceof BackpackItem) {
                BackpackLayerRenderer.renderBackpack(entity, matrixStack, buffer, packedLight, chestStack, false, model);
            }
        }
    }

    public static void renderBackpack(LivingEntity livingEntity, PoseStack matrixStack, MultiBufferSource buffer, int packedLight, ItemStack backpack, boolean wearsArmor, BackpackModel model) {
        if (livingEntity.m_6047_()) {
            matrixStack.m_85837_(0.0, 0.2, 0.0);
            matrixStack.m_85845_(Vector3f.f_122223_.m_122240_(28.647888f));
        }
        matrixStack.m_85845_(Vector3f.f_122225_.m_122240_(180.0f));
        float zOffset = wearsArmor ? -0.35f : -0.3f;
        float yOffset = -0.75f;
        if (livingEntity.m_6162_()) {
            zOffset += 0.1f;
            yOffset = 0.3f;
        }
        matrixStack.m_85837_(0.0, (double)yOffset, (double)zOffset);
        if (livingEntity.m_6162_()) {
            matrixStack.m_85841_(0.55f, 0.55f, 0.55f);
        }
        if (entityTranslations.containsKey(livingEntity.m_6095_())) {
            Vec3 translVector = entityTranslations.get(livingEntity.m_6095_());
            matrixStack.m_85837_(translVector.m_7096_(), translVector.m_7098_(), translVector.m_7094_());
        }
        backpack.getCapability(CapabilityBackpackWrapper.getCapabilityInstance()).ifPresent(wrapper -> {
            int clothColor = wrapper.getClothColor();
            int borderColor = wrapper.getBorderColor();
            model.render(matrixStack, buffer, packedLight, clothColor, borderColor, backpack.m_41720_(), wrapper.getRenderInfo());
            BackpackLayerRenderer.renderUpgrades(livingEntity, wrapper.getRenderInfo());
            BackpackLayerRenderer.renderItemShown(matrixStack, buffer, packedLight, wrapper.getRenderInfo());
        });
    }

    private static void renderItemShown(PoseStack matrixStack, MultiBufferSource buffer, int packedLight, RenderInfo renderInfo) {
        RenderInfo.ItemDisplayRenderInfo itemDisplayRenderInfo = renderInfo.getItemDisplayRenderInfo();
        if (!itemDisplayRenderInfo.getItem().m_41619_()) {
            matrixStack.m_85836_();
            matrixStack.m_85837_(0.0, 0.9, -0.25);
            matrixStack.m_85841_(0.5f, 0.5f, 0.5f);
            matrixStack.m_85845_(Vector3f.f_122227_.m_122240_(180.0f + (float)itemDisplayRenderInfo.getRotation()));
            Minecraft.m_91087_().m_91291_().m_174269_(itemDisplayRenderInfo.getItem(), ItemTransforms.TransformType.FIXED, packedLight, OverlayTexture.f_118083_, matrixStack, buffer, 0);
            matrixStack.m_85849_();
        }
    }

    private static void renderUpgrades(LivingEntity livingEntity, RenderInfo renderInfo) {
        if (Minecraft.m_91087_().m_91104_() || livingEntity.f_19853_.f_46441_.nextInt(32) != 0) {
            return;
        }
        renderInfo.getUpgradeRenderData().forEach((type, data) -> UpgradeRenderRegistry.getUpgradeRenderer(type).ifPresent(renderer -> BackpackLayerRenderer.renderUpgrade(renderer, livingEntity, type, data)));
    }

    private static Vector3f getBackpackMiddleFacePoint(LivingEntity livingEntity, Vector3f vector) {
        Vector3f point = vector.m_122281_();
        point.m_122251_(Vector3f.f_122223_.m_122240_(livingEntity.m_6047_() ? 25.0f : 0.0f));
        point.m_122272_(0.0f, 0.8f, livingEntity.m_6047_() ? 0.9f : 0.7f);
        point.m_122251_(Vector3f.f_122224_.m_122240_(livingEntity.f_20883_ - 180.0f));
        point.m_122253_(new Vector3f(livingEntity.m_20182_()));
        return point;
    }

    private static <T extends IUpgradeRenderData> void renderUpgrade(IUpgradeRenderer<T> renderer, LivingEntity livingEntity, UpgradeRenderDataType<?> type, IUpgradeRenderData data) {
        type.cast(data).ifPresent(renderData -> renderer.render(livingEntity.f_19853_, livingEntity.f_19853_.f_46441_, vector3d -> BackpackLayerRenderer.getBackpackMiddleFacePoint(livingEntity, vector3d), renderData));
    }

    static {
        entityTranslations.put(EntityType.f_20566_, new Vec3(0.0, -0.8, 0.0));
    }
}

