/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.crafting;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.Tag;
import net.minecraft.util.Tuple;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SimpleRecipeSerializer;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.Tags;
import net.p3pp3rf1y.sophisticatedbackpacks.api.CapabilityBackpackWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.BackpackItem;

public class BackpackDyeRecipe
extends CustomRecipe {
    public static final SimpleRecipeSerializer<BackpackDyeRecipe> SERIALIZER = new SimpleRecipeSerializer(BackpackDyeRecipe::new);

    public BackpackDyeRecipe(ResourceLocation registryName) {
        super(registryName);
    }

    public boolean matches(CraftingContainer inv, Level worldIn) {
        boolean backpackPresent = false;
        boolean dyePresent = false;
        for (int slot = 0; slot < inv.m_6643_(); ++slot) {
            ItemStack slotStack = inv.m_8020_(slot);
            if (slotStack.m_41619_()) continue;
            Item item = slotStack.m_41720_();
            if (item instanceof BackpackItem) {
                if (backpackPresent) {
                    return false;
                }
                backpackPresent = true;
                continue;
            }
            if (item instanceof DyeItem) {
                dyePresent = true;
                continue;
            }
            return false;
        }
        return backpackPresent && dyePresent;
    }

    public ItemStack assemble(CraftingContainer inv) {
        HashMap<Integer, List<DyeColor>> columnDyes = new HashMap<Integer, List<DyeColor>>();
        Tuple columnBackpack = null;
        for (int slot = 0; slot < inv.m_6643_(); ++slot) {
            ItemStack slotStack = inv.m_8020_(slot);
            if (slotStack.m_41619_()) continue;
            Item item = slotStack.m_41720_();
            int column = slot % inv.m_39347_();
            if (item instanceof BackpackItem) {
                if (columnBackpack != null) {
                    return ItemStack.f_41583_;
                }
                columnBackpack = new Tuple((Object)column, (Object)slotStack);
                continue;
            }
            if (slotStack.m_150922_((Tag)Tags.Items.DYES)) {
                DyeColor dyeColor = DyeColor.getColor((ItemStack)slotStack);
                if (dyeColor == null) {
                    return ItemStack.f_41583_;
                }
                columnDyes.computeIfAbsent(column, c -> new ArrayList()).add(dyeColor);
                continue;
            }
            return ItemStack.f_41583_;
        }
        if (columnBackpack == null) {
            return ItemStack.f_41583_;
        }
        ItemStack coloredBackpack = ((ItemStack)columnBackpack.m_14419_()).m_41777_();
        int backpackColumn = (Integer)columnBackpack.m_14418_();
        this.applyBackpackColors(columnDyes, coloredBackpack, backpackColumn);
        return coloredBackpack;
    }

    private void applyBackpackColors(Map<Integer, List<DyeColor>> columnDyes, ItemStack coloredBackpack, int backpackColumn) {
        ArrayList clothDyes = new ArrayList();
        ArrayList trimDyes = new ArrayList();
        for (Map.Entry<Integer, List<DyeColor>> entry : columnDyes.entrySet()) {
            if (entry.getKey() <= backpackColumn) {
                clothDyes.addAll(entry.getValue());
            }
            if (entry.getKey() < backpackColumn) continue;
            trimDyes.addAll(entry.getValue());
        }
        coloredBackpack.getCapability(CapabilityBackpackWrapper.getCapabilityInstance()).ifPresent(coloredWrapper -> coloredWrapper.setColors(BackpackDyeRecipe.calculateColor(coloredWrapper.getClothColor(), 13394234, clothDyes), BackpackDyeRecipe.calculateColor(coloredWrapper.getBorderColor(), 6434330, trimDyes)));
    }

    public static int calculateColor(int baseColor, int defaultColor, List<DyeColor> dyes) {
        if (dyes.isEmpty()) {
            return baseColor;
        }
        int[] rgb = new int[3];
        int sumMaxComponent = 0;
        int numberOfColors = 0;
        if (baseColor != defaultColor) {
            float baseRed = baseColor >> 16 & 0xFF;
            float baseGreen = baseColor >> 8 & 0xFF;
            float baseBlue = baseColor & 0xFF;
            sumMaxComponent = (int)((float)sumMaxComponent + Math.max(baseRed, Math.max(baseGreen, baseBlue)));
            rgb[0] = (int)((float)rgb[0] + baseRed);
            rgb[1] = (int)((float)rgb[1] + baseGreen);
            rgb[2] = (int)((float)rgb[2] + baseBlue);
            ++numberOfColors;
        }
        for (DyeColor dye : dyes) {
            float[] dyeRgb = dye.m_41068_();
            int dyeRed = (int)(dyeRgb[0] * 255.0f);
            int dyeGreen = (int)(dyeRgb[1] * 255.0f);
            int dyeBlue = (int)(dyeRgb[2] * 255.0f);
            sumMaxComponent += Math.max(dyeRed, Math.max(dyeGreen, dyeBlue));
            rgb[0] = rgb[0] + dyeRed;
            rgb[1] = rgb[1] + dyeGreen;
            rgb[2] = rgb[2] + dyeBlue;
            ++numberOfColors;
        }
        int avgRed = rgb[0] / numberOfColors;
        int avgGreen = rgb[1] / numberOfColors;
        int avgBlue = rgb[2] / numberOfColors;
        float avgMaxComponent = (float)sumMaxComponent / (float)numberOfColors;
        float maxAvgComponent = Math.max(avgRed, Math.max(avgGreen, avgBlue));
        avgRed = (int)((float)avgRed * avgMaxComponent / maxAvgComponent);
        avgGreen = (int)((float)avgGreen * avgMaxComponent / maxAvgComponent);
        avgBlue = (int)((float)avgBlue * avgMaxComponent / maxAvgComponent);
        int finalColor = (avgRed << 8) + avgGreen;
        finalColor = (finalColor << 8) + avgBlue;
        return finalColor;
    }

    public boolean m_8004_(int width, int height) {
        return width >= 2 && height >= 1;
    }

    public RecipeSerializer<?> m_7707_() {
        return SERIALIZER;
    }
}

