/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.settings;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.p3pp3rf1y.sophisticatedcore.inventory.InventoryHandler;
import net.p3pp3rf1y.sophisticatedcore.renderdata.RenderInfo;
import net.p3pp3rf1y.sophisticatedcore.settings.ISettingsCategory;
import net.p3pp3rf1y.sophisticatedcore.settings.globaloverridable.GlobalOverridableSettingsCategory;
import net.p3pp3rf1y.sophisticatedcore.settings.itemdisplay.ItemDisplaySettingsCategory;
import net.p3pp3rf1y.sophisticatedcore.settings.memory.MemorySettingsCategory;
import net.p3pp3rf1y.sophisticatedcore.settings.nosort.NoSortSettingsCategory;

public class SettingsHandler {
    public static final String SETTINGS_TAG = "settings";
    protected final CompoundTag contentsNbt;
    protected final Runnable markContentsDirty;
    protected final Map<String, ISettingsCategory> settingsCategories = new LinkedHashMap<String, ISettingsCategory>();
    private final Map<Class<?>, List<?>> interfaceCategories = new HashMap();
    private final Map<Class<? extends ISettingsCategory>, ISettingsCategory> typeCategories = new HashMap<Class<? extends ISettingsCategory>, ISettingsCategory>();

    public SettingsHandler(CompoundTag contentsNbt, Runnable markContentsDirty, String playerSettingsTagName, Supplier<InventoryHandler> inventoryHandlerSupplier, Supplier<RenderInfo> renderInfoSupplier) {
        this.contentsNbt = contentsNbt;
        this.markContentsDirty = markContentsDirty;
        this.addSettingsCategories(inventoryHandlerSupplier, renderInfoSupplier, contentsNbt.m_128469_(SETTINGS_TAG), playerSettingsTagName);
    }

    private void addSettingsCategories(Supplier<InventoryHandler> inventoryHandlerSupplier, Supplier<RenderInfo> renderInfoSupplier, CompoundTag settingsNbt, String playerSettingsTagName) {
        this.addSettingsCategory(settingsNbt, "global", this.markContentsDirty, (categoryNbt, saveNbt) -> new GlobalOverridableSettingsCategory((CompoundTag)categoryNbt, (Consumer<CompoundTag>)saveNbt, playerSettingsTagName));
        this.addSettingsCategory(settingsNbt, "no_sort", this.markContentsDirty, NoSortSettingsCategory::new);
        this.addSettingsCategory(settingsNbt, "memory", this.markContentsDirty, (categoryNbt, saveNbt) -> new MemorySettingsCategory(inventoryHandlerSupplier, (CompoundTag)categoryNbt, (Consumer<CompoundTag>)saveNbt));
        this.addSettingsCategory(settingsNbt, "item_display", this.markContentsDirty, (categoryNbt, saveNbt) -> new ItemDisplaySettingsCategory(inventoryHandlerSupplier, renderInfoSupplier, (CompoundTag)categoryNbt, (Consumer<CompoundTag>)saveNbt));
    }

    private void addSettingsCategory(CompoundTag settingsNbt, String categoryName, Runnable markContentsDirty, BiFunction<CompoundTag, Consumer<CompoundTag>, ISettingsCategory> instantiateCategory) {
        ISettingsCategory category = instantiateCategory.apply(settingsNbt.m_128469_(categoryName), tag -> {
            settingsNbt.m_128365_(categoryName, (Tag)tag);
            this.contentsNbt.m_128365_(SETTINGS_TAG, (Tag)settingsNbt);
            markContentsDirty.run();
        });
        this.settingsCategories.put(categoryName, category);
        this.typeCategories.put(category.getClass(), category);
    }

    public Map<String, ISettingsCategory> getSettingsCategories() {
        return this.settingsCategories;
    }

    public <T> List<T> getCategoriesThatImplement(Class<T> categoryClass) {
        return this.interfaceCategories.computeIfAbsent(categoryClass, this::getListOfWrappersThatImplement);
    }

    public <T extends ISettingsCategory> T getTypeCategory(Class<T> categoryClazz) {
        return (T)this.typeCategories.get(categoryClazz);
    }

    private <T> List<T> getListOfWrappersThatImplement(Class<T> uc) {
        ArrayList<ISettingsCategory> ret = new ArrayList<ISettingsCategory>();
        for (ISettingsCategory category : this.settingsCategories.values()) {
            if (!uc.isInstance(category)) continue;
            ret.add(category);
        }
        return ret;
    }

    public CompoundTag getNbt() {
        return this.contentsNbt.m_128469_(SETTINGS_TAG);
    }
}

