/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.settings.globaloverridable;

import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.nbt.CompoundTag;
import net.p3pp3rf1y.sophisticatedcore.settings.GlobalOverridableSetting;
import net.p3pp3rf1y.sophisticatedcore.settings.ISettingsCategory;

public class GlobalOverridableSettingsCategory
implements ISettingsCategory {
    public static final String NAME = "global";
    private CompoundTag categoryNbt;
    private final Consumer<CompoundTag> saveNbt;
    private final String playerSettingsTagName;

    public GlobalOverridableSettingsCategory(CompoundTag categoryNbt, Consumer<CompoundTag> saveNbt, String playerSettingsTagName) {
        this.categoryNbt = categoryNbt;
        this.saveNbt = saveNbt;
        this.playerSettingsTagName = playerSettingsTagName;
    }

    public String getPlayerSettingsTagName() {
        return this.playerSettingsTagName;
    }

    public <T> Optional<T> getSettingValue(GlobalOverridableSetting<T> setting) {
        return setting.getValue(this.categoryNbt);
    }

    public <T> void setSettingValue(GlobalOverridableSetting<T> setting, T value) {
        setting.setValue(this.categoryNbt, value);
        this.saveNbt.accept(this.categoryNbt);
    }

    public <T> void removeSetting(GlobalOverridableSetting<T> setting) {
        setting.removeFrom(this.categoryNbt);
        this.saveNbt.accept(this.categoryNbt);
    }

    @Override
    public void reloadFrom(CompoundTag categoryNbt) {
        this.categoryNbt = categoryNbt;
    }
}

