/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.mininggadgets.client.screens;

import com.direwolf20.mininggadgets.client.screens.ModScreens;
import com.direwolf20.mininggadgets.common.items.gadget.MiningProperties;
import com.direwolf20.mininggadgets.common.network.PacketHandler;
import com.direwolf20.mininggadgets.common.network.packets.PacketChangeBreakType;
import com.direwolf20.mininggadgets.common.network.packets.PacketChangeColor;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.gui.widget.Slider;

public class MiningVisualsScreen
extends Screen
implements Slider.ISlider {
    private ItemStack gadget;
    private Button blockBreakButton;
    private int red;
    private int green;
    private int blue;
    private int red_inner;
    private int green_inner;
    private int blue_inner;
    private Slider sliderRedInner;
    private Slider sliderGreenInner;
    private Slider sliderBlueInner;
    private Slider sliderRedOuter;
    private Slider sliderGreenOuter;
    private Slider sliderBlueOuter;

    public MiningVisualsScreen(ItemStack gadget) {
        super((Component)new TextComponent("title"));
        this.gadget = gadget;
        this.red = MiningProperties.getColor(gadget, "colorRed");
        this.green = MiningProperties.getColor(gadget, "colorGreen");
        this.blue = MiningProperties.getColor(gadget, "colorBlue");
        this.red_inner = MiningProperties.getColor(gadget, "colorRedInner");
        this.green_inner = MiningProperties.getColor(gadget, "colorGreenInner");
        this.blue_inner = MiningProperties.getColor(gadget, "colorBlueInner");
    }

    protected void m_7856_() {
        int baseX = this.f_96543_ / 2;
        int baseY = this.f_96544_ / 2;
        TranslatableComponent buttonText = MiningProperties.getBreakType(this.gadget) == MiningProperties.BreakTypes.SHRINK ? new TranslatableComponent("mininggadgets.tooltip.screen.shrink") : new TranslatableComponent("mininggadgets.tooltip.screen.fade");
        this.blockBreakButton = new Button(baseX - 150, baseY - 55, 150, 20, (Component)buttonText, button -> {
            if (this.blockBreakButton.m_6035_().getString().contains("Shrink")) {
                button.m_93666_((Component)new TranslatableComponent("mininggadgets.tooltip.screen.fade"));
            } else {
                button.m_93666_((Component)new TranslatableComponent("mininggadgets.tooltip.screen.shrink"));
            }
            PacketHandler.sendToServer(new PacketChangeBreakType());
        });
        this.m_142416_((GuiEventListener)this.blockBreakButton);
        this.sliderRedInner = new Slider(baseX - 150, baseY - 10, 150, 20, (Component)new TranslatableComponent("mininggadgets.tooltip.screen.red").m_130946_(": "), TextComponent.f_131282_, 0.0, 255.0, (double)this.red, false, true, s -> {}, (Slider.ISlider)this);
        this.sliderGreenInner = new Slider(baseX - 150, baseY + 15, 150, 20, (Component)new TranslatableComponent("mininggadgets.tooltip.screen.green").m_130946_(": "), TextComponent.f_131282_, 0.0, 255.0, (double)this.green, false, true, s -> {}, (Slider.ISlider)this);
        this.sliderBlueInner = new Slider(baseX - 150, baseY + 40, 150, 20, (Component)new TranslatableComponent("mininggadgets.tooltip.screen.blue").m_130946_(": "), TextComponent.f_131282_, 0.0, 255.0, (double)this.blue, false, true, s -> {}, (Slider.ISlider)this);
        this.sliderRedOuter = new Slider(baseX + 25, baseY - 10, 150, 20, (Component)new TranslatableComponent("mininggadgets.tooltip.screen.red").m_130946_(": "), TextComponent.f_131282_, 0.0, 255.0, (double)this.red_inner, false, true, s -> {}, (Slider.ISlider)this);
        this.sliderGreenOuter = new Slider(baseX + 25, baseY + 15, 150, 20, (Component)new TranslatableComponent("mininggadgets.tooltip.screen.green").m_130946_(": "), TextComponent.f_131282_, 0.0, 255.0, (double)this.green_inner, false, true, s -> {}, (Slider.ISlider)this);
        this.sliderBlueOuter = new Slider(baseX + 25, baseY + 40, 150, 20, (Component)new TranslatableComponent("mininggadgets.tooltip.screen.blue").m_130946_(": "), TextComponent.f_131282_, 0.0, 255.0, (double)this.blue_inner, false, true, s -> {}, (Slider.ISlider)this);
        this.m_142416_((GuiEventListener)this.sliderRedInner);
        this.m_142416_((GuiEventListener)this.sliderGreenInner);
        this.m_142416_((GuiEventListener)this.sliderBlueInner);
        this.m_142416_((GuiEventListener)this.sliderRedOuter);
        this.m_142416_((GuiEventListener)this.sliderGreenOuter);
        this.m_142416_((GuiEventListener)this.sliderBlueOuter);
    }

    public void m_6305_(PoseStack stack, int mouseX, int mouseY, float partialTicks) {
        this.m_7333_(stack);
        super.m_6305_(stack, mouseX, mouseY, partialTicks);
        MiningVisualsScreen.m_93215_((PoseStack)stack, (Font)this.f_96547_, (Component)new TranslatableComponent("mininggadgets.tooltip.screen.visual_settings"), (int)(this.f_96543_ / 2), (int)(this.f_96544_ / 2 - 95), (int)0xFFFFFF);
        MiningVisualsScreen.m_93243_((PoseStack)stack, (Font)this.f_96547_, (Component)new TranslatableComponent("mininggadgets.tooltip.screen.block_break_style"), (int)(this.f_96543_ / 2 - 150), (int)(this.f_96544_ / 2 - 70), (int)0xFFFFFF);
        MiningVisualsScreen.m_93243_((PoseStack)stack, (Font)this.f_96547_, (Component)new TranslatableComponent("mininggadgets.tooltip.screen.beam_preview"), (int)(this.f_96543_ / 2 + 25), (int)(this.f_96544_ / 2 - 70), (int)0xFFFFFF);
        MiningVisualsScreen.m_93243_((PoseStack)stack, (Font)this.f_96547_, (Component)new TranslatableComponent("mininggadgets.tooltip.screen.outer_color"), (int)(this.f_96543_ / 2 - 150), (int)(this.f_96544_ / 2 - 25), (int)0xFFFFFF);
        MiningVisualsScreen.m_93243_((PoseStack)stack, (Font)this.f_96547_, (Component)new TranslatableComponent("mininggadgets.tooltip.screen.inner_color"), (int)(this.f_96543_ / 2 + 25), (int)(this.f_96544_ / 2 - 25), (int)0xFFFFFF);
        stack.m_85836_();
        MiningVisualsScreen.m_93172_((PoseStack)stack, (int)(this.f_96543_ / 2 + 25), (int)(this.f_96544_ / 2 - 55), (int)(this.f_96543_ / 2 + 25 + 150), (int)(this.f_96544_ / 2 - 55 + 20), (int)this.rgbToInt(this.red, this.green, this.blue));
        MiningVisualsScreen.m_93172_((PoseStack)stack, (int)(this.f_96543_ / 2 + 25), (int)(this.f_96544_ / 2 - 50), (int)(this.f_96543_ / 2 + 25 + 150), (int)(this.f_96544_ / 2 - 50 + 10), (int)this.rgbToInt(this.red_inner, this.green_inner, this.blue_inner));
        stack.m_85849_();
    }

    private int rgbToInt(int r, int g, int b) {
        int red = r << 16 & 0xFF0000;
        int green = g << 8 & 0xFF00;
        int blue = b & 0xFF;
        return 0xFF000000 | red | green | blue;
    }

    public boolean m_7043_() {
        return false;
    }

    public void m_7861_() {
        super.m_7861_();
    }

    private void syncColors() {
        PacketHandler.sendToServer(new PacketChangeColor(this.red, this.green, this.blue, this.red_inner, this.green_inner, this.blue_inner));
    }

    public boolean m_7933_(int p_keyPressed_1_, int p_keyPressed_2_, int p_keyPressed_3_) {
        InputConstants.Key mouseKey = InputConstants.m_84827_((int)p_keyPressed_1_, (int)p_keyPressed_2_);
        if (p_keyPressed_1_ == 256) {
            this.syncColors();
            ModScreens.openGadgetSettingsScreen(this.gadget);
            return true;
        }
        if (this.getMinecraft().f_91066_.f_92092_.isActiveAndMatches(mouseKey)) {
            this.syncColors();
            this.m_7861_();
            return true;
        }
        return super.m_7933_(p_keyPressed_1_, p_keyPressed_2_, p_keyPressed_3_);
    }

    public void onChangeSliderValue(Slider slider) {
        if (slider.equals(this.sliderRedInner)) {
            this.red = slider.getValueInt();
        } else if (slider.equals(this.sliderGreenInner)) {
            this.green = slider.getValueInt();
        } else if (slider.equals(this.sliderBlueInner)) {
            this.blue = slider.getValueInt();
        } else if (slider.equals(this.sliderRedOuter)) {
            this.red_inner = slider.getValueInt();
        } else if (slider.equals(this.sliderGreenOuter)) {
            this.green_inner = slider.getValueInt();
        } else if (slider.equals(this.sliderBlueOuter)) {
            this.blue_inner = slider.getValueInt();
        }
    }

    public boolean m_6348_(double p_mouseReleased_1_, double p_mouseReleased_3_, int p_mouseReleased_5_) {
        this.sliderRedInner.dragging = false;
        this.sliderGreenInner.dragging = false;
        this.sliderBlueInner.dragging = false;
        this.sliderRedOuter.dragging = false;
        this.sliderGreenOuter.dragging = false;
        this.sliderBlueOuter.dragging = false;
        return false;
    }
}

