/*
 * Decompiled with CFR 0.152.
 */
package com.technicalitiesmc.scm.circuit.server;

import com.technicalitiesmc.lib.circuit.component.CircuitEvent;
import com.technicalitiesmc.lib.circuit.component.ComponentHarvestContext;
import com.technicalitiesmc.lib.circuit.component.ComponentSlot;
import com.technicalitiesmc.lib.circuit.component.ComponentState;
import com.technicalitiesmc.lib.circuit.component.ComponentType;
import com.technicalitiesmc.lib.math.VecDirection;
import com.technicalitiesmc.lib.math.VecDirectionFlags;
import com.technicalitiesmc.scm.circuit.CircuitHelper;
import com.technicalitiesmc.scm.circuit.server.Circuit;
import com.technicalitiesmc.scm.circuit.server.ComponentInstance;
import com.technicalitiesmc.scm.circuit.util.ComponentPos;
import com.technicalitiesmc.scm.circuit.util.ComponentSlotPos;
import com.technicalitiesmc.scm.circuit.util.TilePos;
import com.technicalitiesmc.scm.circuit.util.TileSection;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;

public class CircuitTile {
    private final ComponentInstance[] components = new ComponentInstance[CircuitHelper.TOTAL_POSITIONS];
    private final BitSet componentPositions = new BitSet(CircuitHelper.TOTAL_POSITIONS);
    private final BitSet occupiedPositions = new BitSet(CircuitHelper.TOTAL_POSITIONS);
    private final BitSet syncQueue = new BitSet(CircuitHelper.TOTAL_POSITIONS);
    private final Int2IntMap delegationMap = new Int2IntOpenHashMap();
    private boolean adjacentX;
    private boolean adjacentZ;
    private boolean adjacentCorner;
    private boolean mustCalcX;
    private boolean mustCalcZ;
    private boolean mustCalcCorner;
    private Circuit circuit;
    private TilePos pos;
    private static final BitSet[] OUTPUT_SETS = new BitSet[4];

    public CircuitTile(Circuit circuit, TilePos pos) {
        this.move(circuit, pos);
    }

    public Circuit getCircuit() {
        return this.circuit;
    }

    public TilePos getPosition() {
        return this.pos;
    }

    public void move(Circuit circuit, TilePos pos) {
        this.circuit = circuit;
        this.pos = pos;
        this.componentPositions.stream().forEach(i -> this.components[i].updatePosition());
    }

    public Stream<ComponentInstance> stream(TileSection section) {
        BitSet bits = new BitSet();
        bits.or(this.componentPositions);
        bits.and(section.getBits());
        return bits.stream().mapToObj(i -> this.components[i]);
    }

    public boolean isEmpty(TileSection section) {
        return switch (section) {
            default -> throw new IncompatibleClassChangeError();
            case TileSection.ALL -> this.componentPositions.isEmpty();
            case TileSection.X_EDGE -> {
                if (!this.adjacentX) {
                    yield true;
                }
                yield false;
            }
            case TileSection.Z_EDGE -> {
                if (!this.adjacentZ) {
                    yield true;
                }
                yield false;
            }
            case TileSection.CORNER -> !this.adjacentCorner;
        };
    }

    public boolean has(ComponentPos pos, ComponentSlot slot) {
        return this.occupiedPositions.get(CircuitHelper.getIndex(pos, slot));
    }

    @Nullable
    public ComponentInstance get(ComponentPos pos, ComponentSlot slot) {
        int index = CircuitHelper.getIndex(pos, slot);
        ComponentInstance instance = this.components[index];
        if (instance != null) {
            return instance;
        }
        return this.occupiedPositions.get(index) ? this.components[this.delegationMap.get(index)] : null;
    }

    public boolean canPut(ComponentPos pos, ComponentType type) {
        for (ComponentSlot slot : type.getAllSlots()) {
            if (!this.has(pos, slot)) continue;
            return false;
        }
        return true;
    }

    public ComponentInstance put(ComponentPos pos, ComponentType.Factory factory) {
        ComponentInstance info = new ComponentInstance(this, pos, factory);
        int index = CircuitHelper.getIndex(pos, info.getSlot());
        this.components[index] = info;
        this.componentPositions.set(index);
        for (ComponentSlot slot : info.getAllSlots()) {
            int slotIndex = CircuitHelper.getIndex(pos, slot);
            this.occupiedPositions.set(slotIndex);
            if (slotIndex == index) continue;
            this.delegationMap.put(slotIndex, index);
        }
        this.syncQueue.set(index);
        this.circuit.enqueueTileSync(this);
        this.adjacentX |= pos.isOnXEdge();
        this.adjacentZ |= pos.isOnZEdge();
        this.adjacentCorner |= pos.isOnXEdge() && pos.isOnZEdge();
        return info;
    }

    public boolean remove(ComponentPos pos, ComponentSlot slot) {
        ComponentInstance c = this.get(pos, slot);
        if (c == null) {
            return false;
        }
        int index = CircuitHelper.getIndex(pos, c.getSlot());
        c.beforeRemove();
        this.components[index] = null;
        this.componentPositions.clear(index);
        for (ComponentSlot s : c.getAllSlots()) {
            int slotIndex = CircuitHelper.getIndex(pos, s);
            this.occupiedPositions.clear(slotIndex);
            this.delegationMap.remove(slotIndex);
        }
        this.syncQueue.set(index);
        this.circuit.enqueueTileSync(this);
        this.mustCalcX |= pos.isOnXEdge();
        this.mustCalcZ |= pos.isOnZEdge();
        this.mustCalcCorner |= pos.isOnXEdge() && pos.isOnZEdge();
        return true;
    }

    public void clear(TileSection section, @Nullable ComponentHarvestContext context) {
        BitSet cleared = BitSet.valueOf(this.componentPositions.toLongArray());
        cleared.and(section.getBits());
        cleared.stream().forEach(i -> {
            ComponentInstance c = this.components[i];
            if (c != null) {
                if (context != null) {
                    c.spawnDrops(context);
                }
                c.beforeRemove();
            }
            this.components[i] = null;
        });
        this.componentPositions.andNot(section.getBits());
        this.occupiedPositions.andNot(section.getBits());
        section.getBits().stream().forEach(arg_0 -> ((Int2IntMap)this.delegationMap).remove(arg_0));
        this.syncQueue.or(cleared);
        this.circuit.enqueueTileSync(this);
        switch (section) {
            case ALL: {
                this.adjacentCorner = false;
                this.adjacentZ = false;
                this.adjacentX = false;
                this.mustCalcCorner = false;
                this.mustCalcZ = false;
                this.mustCalcX = false;
                break;
            }
            case X_EDGE: {
                this.adjacentX = false;
                this.mustCalcX = false;
                break;
            }
            case Z_EDGE: {
                this.adjacentZ = false;
                this.mustCalcZ = false;
                break;
            }
            case CORNER: {
                this.adjacentCorner = false;
                this.mustCalcCorner = false;
                this.mustCalcX |= this.adjacentX;
                this.mustCalcZ |= this.adjacentZ;
            }
        }
    }

    public boolean computeAdjacency() {
        boolean prev;
        boolean checkSplit = false;
        if (this.mustCalcX) {
            prev = this.adjacentX;
            this.adjacentX = this.componentPositions.intersects(TileSection.X_EDGE.getBits());
            checkSplit |= prev && !this.adjacentX;
            this.mustCalcX = false;
        }
        if (this.mustCalcZ) {
            prev = this.adjacentZ;
            this.adjacentZ = this.componentPositions.intersects(TileSection.Z_EDGE.getBits());
            checkSplit |= prev && !this.adjacentZ;
            this.mustCalcZ = false;
        }
        if (this.mustCalcCorner) {
            prev = this.adjacentCorner;
            this.adjacentCorner = this.componentPositions.intersects(TileSection.CORNER.getBits());
            checkSplit |= prev && !this.adjacentCorner;
            this.mustCalcCorner = false;
        }
        return checkSplit;
    }

    public void notifyRedstoneUpdate(VecDirectionFlags sides) {
        for (VecDirection side : sides) {
            BitSet componentsInArea = new BitSet(CircuitHelper.TOTAL_POSITIONS);
            componentsInArea.or(OUTPUT_SETS[side.getHorizontalIndex()]);
            componentsInArea.and(this.componentPositions);
            componentsInArea.stream().forEach(i -> {
                ComponentInstance ci = this.components[i];
                if (ci != null) {
                    this.circuit.enqueueEventAt(ci.getPosition(), ci.getSlot(), side, CircuitEvent.REDSTONE);
                }
            });
        }
    }

    public int calculateOutput(VecDirection side) {
        BitSet componentsInArea = new BitSet(CircuitHelper.TOTAL_POSITIONS);
        componentsInArea.or(OUTPUT_SETS[side.getHorizontalIndex()]);
        componentsInArea.and(this.componentPositions);
        return componentsInArea.stream().map(i -> {
            ComponentInstance ci = this.components[i];
            return ci != null ? ci.getStrongOutput(side) : 0;
        }).max().orElse(0);
    }

    public void markForUpdate(ComponentPos pos, ComponentSlot slot) {
        this.syncQueue.set(CircuitHelper.getIndex(pos, slot));
        this.circuit.enqueueTileSync(this);
    }

    public void clearSyncQueue() {
        this.syncQueue.clear();
    }

    public Map<ComponentSlotPos, ComponentState> getAndClearSyncQueue() {
        if (this.syncQueue.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<ComponentSlotPos, ComponentState> map = new HashMap<ComponentSlotPos, ComponentState>();
        this.syncQueue.stream().mapToObj(CircuitHelper::getPositionFromIndex).forEach(p -> {
            ComponentInstance info = this.get(p.pos(), p.slot());
            map.put((ComponentSlotPos)p, info != null ? info.getState() : null);
        });
        this.syncQueue.clear();
        return map;
    }

    public CompoundTag describe(CompoundTag tag) {
        int[] indices = this.componentPositions.stream().toArray();
        tag.m_128385_("indices", indices);
        ListTag components = new ListTag();
        for (int index : indices) {
            ComponentState state = this.components[index].getState();
            components.add((Object)state.serialize(new CompoundTag()));
        }
        tag.m_128365_("components", (Tag)components);
        return tag;
    }

    public CompoundTag save(CompoundTag tag) {
        int[] indices = this.componentPositions.stream().toArray();
        tag.m_128385_("indices", indices);
        ListTag components = new ListTag();
        for (int index : indices) {
            components.add((Object)this.components[index].save(new CompoundTag()));
        }
        tag.m_128365_("components", (Tag)components);
        return tag;
    }

    public static CircuitTile load(Circuit circuit, TilePos pos, CompoundTag tag) {
        CircuitTile tile = new CircuitTile(circuit, pos);
        int[] indices = tag.m_128465_("indices");
        ListTag components = tag.m_128437_("components", 10);
        for (int i = 0; i < components.size(); ++i) {
            int index = indices[i];
            ComponentSlotPos cPos = CircuitHelper.getPositionFromIndex(index);
            ComponentInstance component = ComponentInstance.load(tile, cPos.pos(), components.m_128728_(i));
            if (component == null) continue;
            tile.components[index] = component;
            tile.componentPositions.set(index);
            for (ComponentSlot slot : component.getAllSlots()) {
                int slotIndex = CircuitHelper.getIndex(cPos.pos(), slot);
                tile.occupiedPositions.set(slotIndex);
                if (slotIndex == index) continue;
                tile.delegationMap.put(slotIndex, index);
            }
        }
        tile.mustCalcCorner = true;
        tile.mustCalcZ = true;
        tile.mustCalcX = true;
        tile.computeAdjacency();
        return tile;
    }

    static {
        for (VecDirection side : VecDirectionFlags.horizontals()) {
            BitSet outputs = new BitSet(CircuitHelper.TOTAL_POSITIONS);
            for (int i = 0; i < 7; ++i) {
                ComponentPos pos = new ComponentPos(side.getAxis() != Direction.Axis.X ? i : (side.getAxisDirection() == Direction.AxisDirection.POSITIVE ? 6 : 0), 0, side.getAxis() != Direction.Axis.Z ? i : (side.getAxisDirection() == Direction.AxisDirection.POSITIVE ? 6 : 0));
                outputs.set(CircuitHelper.getIndex(pos, ComponentSlot.DEFAULT));
            }
            CircuitTile.OUTPUT_SETS[side.getHorizontalIndex()] = outputs;
        }
    }
}

