/*
 * Decompiled with CFR 0.152.
 */
package com.technicalitiesmc.scm.client;

import com.google.common.collect.ImmutableMap;
import com.technicalitiesmc.lib.circuit.component.ComponentState;
import com.technicalitiesmc.lib.circuit.component.ComponentType;
import com.technicalitiesmc.lib.client.circuit.ComponentRenderTypes;
import com.technicalitiesmc.scm.client.SCMKeyMappings;
import com.technicalitiesmc.scm.client.model.CircuitModel;
import com.technicalitiesmc.scm.client.screen.ConstantScreen;
import com.technicalitiesmc.scm.client.screen.TimingScreen;
import com.technicalitiesmc.scm.init.SCMBlocks;
import com.technicalitiesmc.scm.init.SCMComponents;
import com.technicalitiesmc.scm.init.SCMMenus;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockModelShaper;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.level.block.AirBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryManager;

@Mod.EventBusSubscriber(modid="supercircuitmaker", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class SCMClient {
    private static final Map<ComponentState, BlockState> MODEL_STATES = new IdentityHashMap<ComponentState, BlockState>();
    private static final Map<ComponentState, BakedModel> MODELS = new IdentityHashMap<ComponentState, BakedModel>();

    @SubscribeEvent
    public static void setup(FMLClientSetupEvent event) {
        event.enqueueWork(() -> {
            SCMClient.registerScreens();
            SCMKeyMappings.register();
        });
    }

    private static void registerScreens() {
        MenuScreens.m_96206_((MenuType)((MenuType)SCMMenus.DELAY.get()), TimingScreen::new);
        MenuScreens.m_96206_((MenuType)((MenuType)SCMMenus.PULSAR.get()), TimingScreen::new);
        MenuScreens.m_96206_((MenuType)((MenuType)SCMMenus.CONSTANT.get()), ConstantScreen::new);
    }

    @SubscribeEvent
    public static void onModelRegistryInit(ModelRegistryEvent event) {
        HashMap<ResourceLocation, StateDefinition> models = ModelBakery.f_119242_;
        boolean immutable = models instanceof ImmutableMap;
        if (immutable) {
            models = new HashMap<ResourceLocation, StateDefinition>(models);
        }
        IForgeRegistry componentTypes = RegistryManager.ACTIVE.getRegistry(ComponentType.class);
        for (final ComponentType componentType : componentTypes) {
            ResourceLocation name = componentType.getRegistryName();
            ResourceLocation modelName = new ResourceLocation(name.m_135827_(), "scmcomponent/" + name.m_135815_());
            AirBlock fakeBlock = new AirBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50016_)){

                protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
                    componentType.getStateDefinition().m_61092_().forEach(xva$0 -> builder.m_61104_(new Property[]{xva$0}));
                }
            };
            StateDefinition fakeDefinition = new StateDefinition.Builder((Object)fakeBlock).m_61104_((Property[])componentType.getStateDefinition().m_61092_().toArray(Property[]::new)).m_61101_(Block::m_49966_, BlockState::new);
            models.put(modelName, fakeDefinition);
            for (ComponentState state : componentType.getStateDefinition().m_61056_()) {
                BlockState blockState = state.m_61148_().entrySet().stream().reduce((BlockState)fakeDefinition.m_61090_(), SCMClient::setProperty, (a, b) -> b);
                MODEL_STATES.put(state, blockState);
            }
        }
        if (immutable) {
            ModelBakery.f_119242_ = ImmutableMap.copyOf(models);
        }
        Minecraft.m_91087_().m_91298_().m_92589_(($, $$, $$$, idx) -> idx, new Block[]{(Block)SCMBlocks.CIRCUIT.get()});
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)SCMBlocks.CIRCUIT.get()), ComponentRenderTypes.getRequestedTypes()::contains);
        ComponentRenderTypes.setRenderType((ComponentType)((ComponentType)SCMComponents.TORCH_BOTTOM.get()), (RenderType)RenderType.m_110463_());
    }

    private static <T extends Comparable<T>> BlockState setProperty(BlockState state, Map.Entry<Property<?>, Comparable<?>> entry) {
        return (BlockState)state.m_61124_(entry.getKey(), entry.getValue());
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onModelBake(ModelBakeEvent event) {
        for (BlockState state : ((Block)SCMBlocks.CIRCUIT.get()).m_49965_().m_61056_()) {
            ModelResourceLocation location = BlockModelShaper.m_110895_((BlockState)state);
            BakedModel model = (BakedModel)event.getModelRegistry().get(location);
            CircuitModel wrapped = new CircuitModel(model);
            event.getModelRegistry().put(location, wrapped);
        }
        BlockModelShaper shaper = event.getModelManager().m_119430_();
        shaper.m_110892_();
        MODELS.clear();
        MODEL_STATES.forEach((componentState, blockState) -> {
            ResourceLocation name = componentState.getComponentType().getRegistryName();
            String variant = BlockModelShaper.m_110887_((Map)componentState.m_61148_());
            BakedModel model = (BakedModel)event.getModelRegistry().get(new ModelResourceLocation(name.m_135827_(), "scmcomponent/" + name.m_135815_(), variant));
            if (model == null) {
                model = event.getModelManager().m_119409_();
            }
            MODELS.put((ComponentState)componentState, model);
        });
    }

    public static BlockState getBlockState(ComponentState state) {
        return MODEL_STATES.get(state);
    }

    public static BakedModel getModel(ComponentState state) {
        return MODELS.get(state);
    }
}

