/*
 * Decompiled with CFR 0.152.
 */
package com.technicalitiesmc.scm.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.technicalitiesmc.lib.util.Utils;
import com.technicalitiesmc.scm.block.CircuitBlock;
import com.technicalitiesmc.scm.client.SCMKeyMappings;
import com.technicalitiesmc.scm.client.screen.PaletteScreen;
import com.technicalitiesmc.scm.init.SCMItems;
import com.technicalitiesmc.scm.item.PaletteItem;
import com.technicalitiesmc.scm.placement.ComponentPlacementHandler;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.DrawSelectionEvent;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="supercircuitmaker", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class SCMClientEventHandler {
    private static int busyTimer = 0;
    private static boolean partial = false;
    private static KeyMapping partialMapping;
    private static InteractionHand partialHand;

    @SubscribeEvent
    public static void onClickInput(InputEvent.ClickInputEvent event) {
        InteractionResult result;
        if (busyTimer > 0) {
            event.setCanceled(true);
            return;
        }
        Minecraft minecraft = Minecraft.m_91087_();
        HitResult hitResult = minecraft.f_91077_;
        if (!(hitResult instanceof BlockHitResult)) {
            return;
        }
        BlockHitResult hit = (BlockHitResult)hitResult;
        BlockState state = Utils.resolveHit((LevelAccessor)minecraft.f_91073_, (BlockHitResult)hit);
        Block block = state.m_60734_();
        if (!(block instanceof CircuitBlock)) {
            return;
        }
        CircuitBlock block2 = (CircuitBlock)block;
        if (event.isUseItem()) {
            if (partial) {
                result = InteractionResult.CONSUME_PARTIAL;
            } else {
                InteractionResult interactionResult = result = minecraft.f_91074_.m_6047_() ? InteractionResult.PASS : block2.onClientUse(state, minecraft.f_91073_, hit.m_82425_(), (Player)minecraft.f_91074_, event.getHand(), hit);
            }
            if (result == InteractionResult.PASS) {
                result = ComponentPlacementHandler.onClientUse(state, minecraft.f_91073_, hit.m_82425_(), minecraft.f_91074_, event.getHand(), hit);
            }
            if (result == InteractionResult.CONSUME_PARTIAL) {
                partial = true;
                partialMapping = event.getKeyMapping();
                partialHand = event.getHand();
            }
        } else if (event.isAttack()) {
            result = block2.onClientClicked(state, minecraft.f_91073_, hit.m_82425_(), (Player)minecraft.f_91074_, event.getHand(), hit);
        } else {
            if (event.isPickBlock()) {
                CircuitBlock.picking = true;
                return;
            }
            return;
        }
        if (result == InteractionResult.PASS) {
            return;
        }
        event.setCanceled(result.m_19077_());
        event.setSwingHand(result.m_19080_());
        if (result.m_19077_() && result != InteractionResult.CONSUME_PARTIAL) {
            busyTimer = 5;
        }
    }

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        BlockHitResult hit;
        BlockState state;
        CircuitBlock.picking = false;
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        if (busyTimer > 0) {
            --busyTimer;
        }
        if (!partial) {
            return;
        }
        Minecraft minecraft = Minecraft.m_91087_();
        if (minecraft.f_91073_ == null || minecraft.f_91074_ == null) {
            return;
        }
        HitResult hitResult = minecraft.f_91077_;
        if (hitResult instanceof BlockHitResult && (state = Utils.resolveHit((LevelAccessor)minecraft.f_91073_, (BlockHitResult)(hit = (BlockHitResult)hitResult))).m_60734_() instanceof CircuitBlock && partialMapping.m_90857_()) {
            InteractionResult result = ComponentPlacementHandler.onClientUse(state, minecraft.f_91073_, hit.m_82425_(), minecraft.f_91074_, partialHand, hit);
            if (result != InteractionResult.CONSUME_PARTIAL) {
                partial = false;
                busyTimer = 5;
            }
            return;
        }
        if (ComponentPlacementHandler.onClientStopUsing(minecraft.f_91073_, minecraft.f_91074_) || busyTimer > 0) {
            partial = false;
            busyTimer = 2;
        }
    }

    @SubscribeEvent
    public static void onDrawBlockHighlight(DrawSelectionEvent.HighlightBlock event) {
        Minecraft minecraft = Minecraft.m_91087_();
        HitResult hitResult = minecraft.f_91077_;
        if (!(hitResult instanceof BlockHitResult)) {
            return;
        }
        BlockHitResult hit = (BlockHitResult)hitResult;
        BlockState state = Utils.resolveHit((LevelAccessor)minecraft.f_91073_, (BlockHitResult)hit);
        if (!(state.m_60734_() instanceof CircuitBlock)) {
            return;
        }
        if (ComponentPlacementHandler.onDrawBlockHighlight(minecraft.f_91073_, minecraft.f_91074_, event.getMultiBufferSource(), event.getPoseStack(), event.getPartialTicks())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onClientTickPalette(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ == null) {
            return;
        }
        if (SCMKeyMappings.OPEN_PALETTE.m_90857_() && mc.f_91080_ == null) {
            ItemStack stack = mc.f_91074_.m_21205_();
            if (!stack.m_41619_() && stack.m_150930_((Item)SCMItems.PALETTE.get())) {
                mc.m_91152_((Screen)new PaletteScreen(PaletteItem.getColor(stack)));
                return;
            }
            stack = mc.f_91074_.m_21206_();
            if (!stack.m_41619_() && stack.m_150930_((Item)SCMItems.PALETTE.get())) {
                mc.m_91152_((Screen)new PaletteScreen(PaletteItem.getColor(stack)));
            }
        }
    }

    @SubscribeEvent
    public static void onDrawPaletteOverlay(RenderGameOverlayEvent.Post event) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ == null || mc.f_91080_ != null || event.getType() != RenderGameOverlayEvent.ElementType.ALL) {
            return;
        }
        ItemStack stack = mc.f_91074_.m_21205_();
        if (!stack.m_41619_() && stack.m_150930_((Item)SCMItems.PALETTE.get())) {
            PoseStack poseStack = event.getMatrixStack();
            poseStack.m_85836_();
            poseStack.m_85837_((double)((float)mc.m_91268_().m_85445_() - 73.5f - 24.0f), (double)((float)mc.m_91268_().m_85446_() - 73.5f - 24.0f), 0.0);
            poseStack.m_85841_(0.75f, 0.75f, 1.0f);
            PaletteScreen.drawPalette(event.getMatrixStack(), PaletteItem.getColor(stack), 0);
            poseStack.m_85849_();
            return;
        }
        stack = mc.f_91074_.m_21206_();
        if (!stack.m_41619_() && stack.m_150930_((Item)SCMItems.PALETTE.get())) {
            PoseStack poseStack = event.getMatrixStack();
            poseStack.m_85836_();
            poseStack.m_85837_(24.0, (double)((float)mc.m_91268_().m_85446_() - 73.5f - 24.0f), 0.0);
            poseStack.m_85841_(0.75f, 0.75f, 1.0f);
            PaletteScreen.drawPalette(event.getMatrixStack(), PaletteItem.getColor(stack), 0);
            poseStack.m_85849_();
        }
    }
}

