/*
 * Decompiled with CFR 0.152.
 */
package com.technicalitiesmc.scm.client.model;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import com.mojang.math.Matrix4f;
import com.mojang.math.Transformation;
import com.technicalitiesmc.lib.circuit.component.ComponentState;
import com.technicalitiesmc.lib.circuit.component.ComponentType;
import com.technicalitiesmc.lib.client.circuit.ComponentRenderTypes;
import com.technicalitiesmc.scm.circuit.CircuitAdjacency;
import com.technicalitiesmc.scm.client.SCMClient;
import com.technicalitiesmc.scm.client.model.CircuitModelData;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.model.QuadTransformer;
import net.minecraftforge.client.model.data.IDynamicBakedModel;
import net.minecraftforge.client.model.data.IModelData;

public class CircuitModel
implements IDynamicBakedModel {
    private final BakedModel parent;

    public CircuitModel(BakedModel parent) {
        this.parent = parent;
    }

    private List<BakedQuad> getParentQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull Random rand, @Nonnull IModelData extraData) {
        RenderType renderType = MinecraftForgeClient.getRenderType();
        if (renderType != null && renderType != RenderType.m_110451_()) {
            return Collections.emptyList();
        }
        if (side != null) {
            return this.parent.m_6840_(state, side, rand);
        }
        CircuitModelData data = (CircuitModelData)extraData.getData(CircuitModelData.PROPERTY);
        CircuitAdjacency[] adjacency = data != null ? data.getAdjacency() : new CircuitAdjacency[]{CircuitAdjacency.NONE, CircuitAdjacency.NONE, CircuitAdjacency.NONE, CircuitAdjacency.NONE};
        ImmutableList.Builder quads = ImmutableList.builder();
        for (BakedQuad quad : this.parent.m_6840_(state, side, rand)) {
            int adj;
            if (!quad.m_111304_()) {
                quads.add((Object)quad);
                continue;
            }
            int corner = quad.m_111305_() % 4;
            if (adjacency[corner] != CircuitAdjacency.VALUES[adj = quad.m_111305_() / 4]) continue;
            quads.add((Object)new BakedQuad(quad.m_111303_(), -1, quad.m_111306_(), quad.m_173410_(), quad.m_111307_()));
        }
        return quads.build();
    }

    @Nonnull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull Random rand, @Nonnull IModelData extraData) {
        if (side != null) {
            return this.getParentQuads(state, side, rand, extraData);
        }
        CircuitModelData data = (CircuitModelData)extraData.getData(CircuitModelData.PROPERTY);
        if (data == null || data.getStates().isEmpty()) {
            return this.getParentQuads(state, side, rand, extraData);
        }
        ImmutableList.Builder quads = ImmutableList.builder();
        quads.addAll(this.getParentQuads(state, side, rand, extraData));
        RenderType renderType = MinecraftForgeClient.getRenderType();
        CircuitModel.processComponentGeometry(data.getStates(), renderType, rand, arg_0 -> ((ImmutableList.Builder)quads).add(arg_0));
        return quads.build();
    }

    public static void processComponentGeometry(Multimap<Vec3i, ComponentState> states, RenderType renderType, Random rand, Consumer<BakedQuad> consumer) {
        states.forEach((pos, componentState) -> {
            if (!ComponentRenderTypes.shouldRender((ComponentType)componentState.getComponentType(), (RenderType)renderType)) {
                return;
            }
            Matrix4f matrix = Matrix4f.m_27632_((float)0.125f, (float)0.125f, (float)0.125f);
            matrix.m_27644_(Matrix4f.m_27653_((float)((float)pos.m_123341_() + 0.5f), (float)(pos.m_123342_() + 1), (float)((float)pos.m_123343_() + 0.5f)));
            QuadTransformer transformer = new QuadTransformer(new Transformation(matrix));
            ComponentState rawState = componentState.getRawState();
            BlockState blockState = SCMClient.getBlockState(rawState);
            BakedModel model = SCMClient.getModel(rawState);
            List transformed = transformer.processMany(model.m_6840_(blockState, null, rand));
            for (BakedQuad quad : transformed) {
                if (!quad.m_111304_()) {
                    consumer.accept(quad);
                    continue;
                }
                int tint = componentState.getTint(quad.m_111305_());
                consumer.accept(new BakedQuad(quad.m_111303_(), tint, quad.m_111306_(), quad.m_173410_(), quad.m_111307_()));
            }
        });
    }

    public boolean m_7541_() {
        return true;
    }

    public boolean m_7539_() {
        return this.parent.m_7539_();
    }

    public boolean m_7547_() {
        return true;
    }

    public boolean m_7521_() {
        return false;
    }

    public TextureAtlasSprite m_6160_() {
        return this.parent.m_6160_();
    }

    public ItemOverrides m_7343_() {
        return this.parent.m_7343_();
    }
}

