/*
 * Decompiled with CFR 0.152.
 */
package com.technicalitiesmc.scm.component;

import com.technicalitiesmc.lib.circuit.component.CircuitComponent;
import com.technicalitiesmc.lib.circuit.component.CircuitEvent;
import com.technicalitiesmc.lib.circuit.component.ComponentContext;
import com.technicalitiesmc.lib.circuit.component.ComponentEventMap;
import com.technicalitiesmc.lib.circuit.component.ComponentSlot;
import com.technicalitiesmc.lib.circuit.component.ComponentType;
import com.technicalitiesmc.lib.circuit.interfaces.BundledSource;
import com.technicalitiesmc.lib.circuit.interfaces.RedstoneSource;
import com.technicalitiesmc.lib.math.VecDirection;
import com.technicalitiesmc.scm.component.InterfaceLookup;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraftforge.registries.RegistryObject;

public abstract class CircuitComponentBase<T extends CircuitComponentBase<T>>
extends CircuitComponent {
    private final InterfaceLookup<T> interfaceLookup;

    protected CircuitComponentBase(RegistryObject<ComponentType> type, ComponentContext context, InterfaceLookup<T> interfaceLookup) {
        super((ComponentType)type.get(), context);
        this.interfaceLookup = interfaceLookup;
    }

    @Nullable
    public <V> V getInterface(VecDirection side, Class<V> type) {
        return this.interfaceLookup.get(this, side, type);
    }

    protected boolean ensureSupported(ComponentEventMap events) {
        if (events.hasAny(VecDirection.NEG_Y, new CircuitEvent[]{CircuitEvent.NEIGHBOR_CHANGED}) && !this.isTopSolid(VecDirection.NEG_Y.getOffset())) {
            this.scheduleRemoval();
            return false;
        }
        return true;
    }

    @Nullable
    protected final CircuitComponent findNeighbor(VecDirection direction) {
        if (direction.getAxis() != Direction.Axis.Y) {
            return this.getNeighbor(direction, ComponentSlot.DEFAULT);
        }
        ComponentSlot slot = this.getType().getSlot();
        Direction.AxisDirection dir = direction.getAxisDirection();
        return this.getComponentAt(slot.getOffsetTowards(dir), slot.next(dir));
    }

    @Nullable
    protected final <V> V findNeighborInterface(VecDirection direction, Class<V> type) {
        CircuitComponent neighbor = this.findNeighbor(direction);
        return (V)(neighbor != null ? neighbor.getInterface(direction.getOpposite(), type) : null);
    }

    protected final int getStrongInput(VecDirection direction) {
        RedstoneSource redstoneSource = this.findNeighborInterface(direction, RedstoneSource.class);
        return redstoneSource != null ? redstoneSource.getStrongOutput() : 0;
    }

    protected final int getWeakInput(VecDirection direction) {
        RedstoneSource redstoneSource = this.findNeighborInterface(direction, RedstoneSource.class);
        return redstoneSource != null ? redstoneSource.getWeakOutput() : 0;
    }

    @Nullable
    protected final BundledSource getBundledInput(VecDirection direction) {
        return this.findNeighborInterface(direction, BundledSource.class);
    }
}

