/*
 * Decompiled with CFR 0.152.
 */
package com.technicalitiesmc.scm.component.analog;

import com.mojang.math.Vector3f;
import com.technicalitiesmc.lib.circuit.component.CircuitComponent;
import com.technicalitiesmc.lib.circuit.component.CircuitEvent;
import com.technicalitiesmc.lib.circuit.component.ClientComponent;
import com.technicalitiesmc.lib.circuit.component.ComponentContext;
import com.technicalitiesmc.lib.circuit.component.ComponentEventMap;
import com.technicalitiesmc.lib.circuit.component.ComponentState;
import com.technicalitiesmc.lib.circuit.component.ComponentType;
import com.technicalitiesmc.lib.circuit.interfaces.RedstoneSink;
import com.technicalitiesmc.lib.circuit.interfaces.RedstoneSource;
import com.technicalitiesmc.lib.math.VecDirection;
import com.technicalitiesmc.lib.math.VecDirectionFlags;
import com.technicalitiesmc.lib.util.value.Reference;
import com.technicalitiesmc.scm.component.CircuitComponentBase;
import com.technicalitiesmc.scm.component.InterfaceLookup;
import com.technicalitiesmc.scm.init.SCMComponents;
import com.technicalitiesmc.scm.init.SCMItems;
import com.technicalitiesmc.scm.menu.DelayMenu;
import java.util.Arrays;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;

public class DelayComponent
extends CircuitComponentBase<DelayComponent> {
    public static final VecDirectionFlags INPUT_SIDES = (VecDirectionFlags)VecDirectionFlags.horizontals().and((Enum)VecDirection.NEG_Y);
    private static final VecDirectionFlags OUTPUT_SIDES = VecDirectionFlags.horizontals();
    private static final AABB BOUNDS = new AABB(0.0, 0.0, 0.0, 1.0, 0.375, 1.0);
    private static final TranslatableComponent MENU_TITLE = new TranslatableComponent("container.supercircuitmaker.delay");
    private static final int DEFAULT_DELAY = 20;
    private static final Property<Boolean> PROP_ON = BooleanProperty.m_61465_((String)"on");
    private static final InterfaceLookup<DelayComponent> INTERFACES = InterfaceLookup.builder().with(RedstoneSource.class, OUTPUT_SIDES, DelayComponent::getRedstoneSource).with(RedstoneSink.class, INPUT_SIDES, RedstoneSink::instance).build();
    private int[] values = new int[21];
    private int next = 0;
    private int delay = 20;
    private int counter = 0;

    public DelayComponent(ComponentContext context) {
        super(SCMComponents.DELAY, context, INTERFACES);
    }

    private DelayComponent(ComponentContext context, int[] values, int delay, int counter) {
        this(context);
        this.values = Arrays.copyOf(values, values.length);
        this.delay = delay;
        this.counter = counter;
    }

    private int getNextIndex() {
        return (this.counter + 1) % (this.delay + 1);
    }

    private void setDelay(int ticks) {
        int current = this.values[this.getNextIndex()];
        this.updateExternalState(false, () -> {
            this.delay = ticks;
            this.values = new int[ticks + 1];
            this.values[1] = current;
            this.counter = 0;
        });
    }

    public CircuitComponent copyRotated(ComponentContext context, Rotation rotation) {
        return new DelayComponent(context, this.values, this.delay, this.counter);
    }

    public ComponentState getState() {
        return (ComponentState)super.getState().m_61124_(PROP_ON, (Comparable)Boolean.valueOf(this.values[this.getNextIndex()] != 0));
    }

    public AABB getBoundingBox() {
        return BOUNDS;
    }

    public ItemStack getPickedItem() {
        return new ItemStack((ItemLike)SCMItems.DELAY.get());
    }

    public void onAdded() {
        super.onAdded();
        this.scheduleTick(1);
    }

    public void update(ComponentEventMap events, boolean tick) {
        if (tick) {
            this.values[this.counter] = this.getInput();
            int nextIndex = this.getNextIndex();
            this.updateExternalState(true, () -> {
                this.counter = nextIndex;
            });
            this.sendEvent(CircuitEvent.REDSTONE, OUTPUT_SIDES);
            this.scheduleTick(1);
        }
    }

    private int getInput() {
        return INPUT_SIDES.stream(VecDirection.class).mapToInt(x$0 -> this.getWeakInput((VecDirection)x$0)).max().orElse(0);
    }

    public InteractionResult use(Player player, InteractionHand hand, VecDirection sideHit, Vector3f hit) {
        player.m_5893_((MenuProvider)new SimpleMenuProvider((id, playerInv, $) -> new DelayMenu(id, playerInv, p -> true, (Reference<Integer>)Reference.of(() -> this.delay, this::setDelay)), (Component)MENU_TITLE));
        return InteractionResult.m_19078_((boolean)false);
    }

    public CompoundTag save(CompoundTag tag) {
        tag = super.save(tag);
        tag.m_128385_("values", Arrays.copyOf(this.values, this.values.length));
        tag.m_128405_("next", this.next);
        tag.m_128405_("delay", this.delay);
        tag.m_128405_("counter", this.counter);
        return tag;
    }

    public void load(CompoundTag tag) {
        super.load(tag);
        this.values = tag.m_128465_("values");
        this.next = tag.m_128451_("next");
        this.delay = tag.m_128451_("delay");
        this.counter = tag.m_128451_("counter");
    }

    private RedstoneSource getRedstoneSource() {
        return RedstoneSource.of((int)0, (int)this.values[this.getNextIndex()]);
    }

    public static void createState(StateDefinition.Builder<ComponentType, ComponentState> builder) {
        builder.m_61104_(new Property[]{PROP_ON});
    }

    public static class Client
    extends ClientComponent {
        public AABB getBoundingBox(ComponentState state) {
            return BOUNDS;
        }

        public ItemStack getPickedItem(ComponentState state) {
            return new ItemStack((ItemLike)SCMItems.DELAY.get());
        }

        public InteractionResult use(ComponentState state, Player player, InteractionHand hand, VecDirection sideHit, Vector3f hit) {
            return InteractionResult.m_19078_((boolean)true);
        }
    }
}

