/*
 * Decompiled with CFR 0.152.
 */
package com.technicalitiesmc.scm.component.digital;

import com.mojang.math.Vector3f;
import com.technicalitiesmc.lib.circuit.component.ClientComponent;
import com.technicalitiesmc.lib.circuit.component.ComponentContext;
import com.technicalitiesmc.lib.circuit.component.ComponentEventMap;
import com.technicalitiesmc.lib.circuit.component.ComponentState;
import com.technicalitiesmc.lib.circuit.component.ComponentStateBuilder;
import com.technicalitiesmc.lib.circuit.interfaces.RedstoneSink;
import com.technicalitiesmc.lib.math.VecDirection;
import com.technicalitiesmc.scm.component.InterfaceLookup;
import com.technicalitiesmc.scm.component.digital.DigitalComponentBase;
import com.technicalitiesmc.scm.init.SCMComponents;
import com.technicalitiesmc.scm.init.SCMItemTags;
import com.technicalitiesmc.scm.init.SCMItems;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;

public class NoteComponent
extends DigitalComponentBase<NoteComponent> {
    private static final AABB BOUNDS = new AABB(0.0, 0.0, 0.0, 1.0, 0.375, 1.0);
    private static final Property<Instrument> PROP_INSTRUMENT = EnumProperty.m_61587_((String)"instrument", Instrument.class);
    private static final InterfaceLookup<NoteComponent> INTERFACES = InterfaceLookup.builder().with(RedstoneSink.class, DigitalComponentBase.DEFAULT_INPUT_SIDES, RedstoneSink::instance).build();
    private boolean previousInput = false;
    private boolean state = false;
    private Instrument instrument = Instrument.HARP;
    private int note = 0;

    public NoteComponent(ComponentContext context) {
        super(SCMComponents.NOTE, context, INTERFACES);
    }

    public ComponentState getState() {
        return (ComponentState)super.getState().m_61124_(PROP_INSTRUMENT, (Comparable)((Object)this.instrument));
    }

    public AABB getBoundingBox() {
        return BOUNDS;
    }

    public ItemStack getPickedItem() {
        return new ItemStack((ItemLike)SCMItems.NOTE.get());
    }

    @Override
    protected boolean beforeCheckInputs(ComponentEventMap events, boolean tick) {
        if (tick) {
            boolean input;
            boolean bl = input = this.getInputs() != 0;
            if (input && !this.previousInput) {
                this.playNote();
            }
            this.previousInput = input;
        }
        return true;
    }

    @Override
    protected void onNewInputs(boolean tick, byte newInputs) {
        if (this.getInputs() == 0 != (newInputs == 0)) {
            this.scheduleTick(1);
        }
    }

    public InteractionResult use(Player player, InteractionHand hand, VecDirection sideHit, Vector3f hit) {
        Item newNote2;
        ItemStack stack = player.m_21120_(hand);
        if (!stack.m_41619_() && stack.m_150922_(SCMItemTags.ROTATES_COMPONENTS)) {
            int newNote2 = (this.note + 1) % 24;
            this.updateExternalState(false, () -> {
                this.note = newNote2;
                this.playNote();
            });
        } else if (!stack.m_41619_() && (newNote2 = stack.m_41720_()) instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)newNote2;
            Instrument newInstrument = Instrument.byState(blockItem.m_40614_().m_49966_());
            if (newInstrument != this.instrument) {
                this.updateExternalState(true, () -> {
                    this.instrument = newInstrument;
                    this.playNote();
                });
            }
        } else {
            this.playNote();
        }
        return InteractionResult.m_19078_((boolean)false);
    }

    @Override
    public CompoundTag save(CompoundTag tag) {
        tag = super.save(tag);
        tag.m_128379_("previous_input", this.previousInput);
        tag.m_128379_("state", this.state);
        tag.m_128405_("instrument", this.instrument.ordinal());
        tag.m_128405_("note", this.note);
        return tag;
    }

    @Override
    public void load(CompoundTag tag) {
        super.load(tag);
        this.previousInput = tag.m_128471_("previous_input");
        this.state = tag.m_128471_("state");
        this.instrument = Instrument.VALUES[tag.m_128451_("instrument")];
        this.note = tag.m_128451_("note");
    }

    private void playNote() {
        float pitch = (float)Math.pow(2.0, (double)(this.note - 12) / 12.0);
        this.playSound(this.instrument.getInstrument().m_61668_(), SoundSource.RECORDS, 1.0f, pitch);
    }

    public static void createState(ComponentStateBuilder builder) {
        builder.add(new Property[]{PROP_INSTRUMENT});
    }

    public static enum Instrument implements StringRepresentable
    {
        HARP(NoteBlockInstrument.HARP, Blocks.f_50016_.m_49966_()),
        BASSDRUM(NoteBlockInstrument.BASEDRUM, Blocks.f_50069_.m_49966_()),
        SNARE(NoteBlockInstrument.SNARE, Blocks.f_49992_.m_49966_()),
        HAT(NoteBlockInstrument.HAT, Blocks.f_50058_.m_49966_()),
        BASS(NoteBlockInstrument.BASS, Blocks.f_50011_.m_49966_()),
        FLUTE(NoteBlockInstrument.FLUTE, Blocks.f_50129_.m_49966_()),
        BELL(NoteBlockInstrument.BELL, Blocks.f_50074_.m_49966_()),
        GUITAR(NoteBlockInstrument.GUITAR, Blocks.f_50041_.m_49966_()),
        CHIME(NoteBlockInstrument.CHIME, Blocks.f_50354_.m_49966_()),
        XYLOPHONE(NoteBlockInstrument.XYLOPHONE, Blocks.f_50453_.m_49966_()),
        IRON_XYLOPHONE(NoteBlockInstrument.IRON_XYLOPHONE, Blocks.f_50075_.m_49966_()),
        COWBELL(NoteBlockInstrument.COW_BELL, Blocks.f_50135_.m_49966_()),
        DIDGERIDOO(NoteBlockInstrument.DIDGERIDOO, Blocks.f_50133_.m_49966_()),
        BIT(NoteBlockInstrument.BIT, Blocks.f_50268_.m_49966_()),
        BANJO(NoteBlockInstrument.BANJO, Blocks.f_50335_.m_49966_()),
        PLING(NoteBlockInstrument.PLING, Blocks.f_50141_.m_49966_());

        private static final Instrument[] VALUES;
        private static final Map<NoteBlockInstrument, Instrument> INSTRUMENT_MAP;
        private final NoteBlockInstrument instrument;
        private final BlockState blockState;

        private Instrument(NoteBlockInstrument instrument, BlockState blockState) {
            this.instrument = instrument;
            this.blockState = blockState;
        }

        public NoteBlockInstrument getInstrument() {
            return this.instrument;
        }

        public BlockState getBlockState() {
            return this.blockState;
        }

        public String m_7912_() {
            return this.instrument.m_7912_();
        }

        public static Instrument byState(BlockState state) {
            return INSTRUMENT_MAP.get(NoteBlockInstrument.m_61666_((BlockState)state));
        }

        static {
            VALUES = Instrument.values();
            INSTRUMENT_MAP = Arrays.stream(VALUES).collect(Collectors.toMap(i -> i.instrument, i -> i));
        }
    }

    public static class Client
    extends ClientComponent {
        public AABB getBoundingBox(ComponentState state) {
            return BOUNDS;
        }

        public ItemStack getPickedItem(ComponentState state) {
            return new ItemStack((ItemLike)SCMItems.NOTE.get());
        }

        public InteractionResult use(ComponentState state, Player player, InteractionHand hand, VecDirection sideHit, Vector3f hit) {
            return InteractionResult.m_19078_((boolean)true);
        }
    }
}

