/*
 * Decompiled with CFR 0.152.
 */
package com.technicalitiesmc.scm.component.wire;

import com.mojang.math.Vector3f;
import com.technicalitiesmc.lib.circuit.component.CircuitComponent;
import com.technicalitiesmc.lib.circuit.component.ComponentContext;
import com.technicalitiesmc.lib.circuit.component.ComponentEventMap;
import com.technicalitiesmc.lib.circuit.component.ComponentType;
import com.technicalitiesmc.lib.circuit.interfaces.wire.WireConnectionState;
import com.technicalitiesmc.lib.math.VecDirection;
import com.technicalitiesmc.lib.math.VecDirectionFlags;
import com.technicalitiesmc.lib.util.Utils;
import com.technicalitiesmc.scm.component.InterfaceLookup;
import com.technicalitiesmc.scm.component.wire.WireComponentBase;
import com.technicalitiesmc.scm.init.SCMItemTags;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.Nullable;

public abstract class HorizontalWireComponentBase<T extends HorizontalWireComponentBase<T>>
extends WireComponentBase<T> {
    protected HorizontalWireComponentBase(RegistryObject<ComponentType> type, ComponentContext context, InterfaceLookup<T> interfaceLookup) {
        super(type, context, interfaceLookup);
    }

    @Override
    protected VecDirectionFlags getConnectableSides() {
        return VecDirectionFlags.all();
    }

    @Override
    @Nullable
    protected CircuitComponent findConnectionTarget(VecDirection side) {
        return this.findNeighbor(side);
    }

    @Override
    public void update(ComponentEventMap events, boolean tick) {
        if (!this.ensureSupported(events)) {
            return;
        }
        super.update(events, tick);
    }

    public InteractionResult use(Player player, InteractionHand hand, VecDirection sideHit, Vector3f hit) {
        ItemStack stack = player.m_21120_(hand);
        if (!stack.m_41619_() && stack.m_150922_(SCMItemTags.ROTATES_COMPONENTS)) {
            VecDirection side = sideHit.getAxis() != Direction.Axis.Y ? sideHit : Utils.calculatePlanarDirection((float)(hit.m_122239_() - 0.5f), (float)(hit.m_122269_() - 0.5f));
            WireConnectionState newState = this.computeNewState(side, true);
            if (newState != this.getState(side)) {
                this.setStateInternal(side, newState);
                this.updateSignals(VecDirectionFlags.of((VecDirection[])new VecDirection[]{side}));
                return InteractionResult.m_19078_((boolean)player.f_19853_.m_5776_());
            }
            return InteractionResult.PASS;
        }
        return super.use(player, hand, sideHit, hit);
    }
}

