/*
 * Decompiled with CFR 0.152.
 */
package com.technicalitiesmc.scm.component.wire;

import com.technicalitiesmc.lib.circuit.component.CircuitComponent;
import com.technicalitiesmc.lib.circuit.component.CircuitEvent;
import com.technicalitiesmc.lib.circuit.component.ClientComponent;
import com.technicalitiesmc.lib.circuit.component.ComponentContext;
import com.technicalitiesmc.lib.circuit.component.ComponentState;
import com.technicalitiesmc.lib.circuit.component.ComponentStateBuilder;
import com.technicalitiesmc.lib.circuit.interfaces.RedstoneSink;
import com.technicalitiesmc.lib.circuit.interfaces.RedstoneSource;
import com.technicalitiesmc.lib.circuit.interfaces.wire.RedstoneConductor;
import com.technicalitiesmc.lib.circuit.interfaces.wire.RedstoneWire;
import com.technicalitiesmc.lib.circuit.interfaces.wire.Wire;
import com.technicalitiesmc.lib.circuit.interfaces.wire.WireConnectionState;
import com.technicalitiesmc.lib.math.VecDirection;
import com.technicalitiesmc.lib.math.VecDirectionFlags;
import com.technicalitiesmc.scm.component.InterfaceLookup;
import com.technicalitiesmc.scm.component.wire.VerticalWireComponentBase;
import com.technicalitiesmc.scm.component.wire.WireUtils;
import com.technicalitiesmc.scm.init.SCMComponents;
import com.technicalitiesmc.scm.init.SCMItems;
import java.util.Arrays;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;

public class VerticalWireComponent
extends VerticalWireComponentBase<VerticalWireComponent>
implements RedstoneWire {
    private static final AABB BOUNDS = new AABB(0.375, 0.0, 0.375, 0.625, 1.0, 0.625);
    private static final Property<Integer> PROP_EXT_POWER = IntegerProperty.m_61631_((String)"power", (int)0, (int)255);
    private static final InterfaceLookup<VerticalWireComponent> INTERFACES = InterfaceLookup.builder().with(RedstoneSource.class, VecDirectionFlags.verticals(), VerticalWireComponent::getRedstoneSource).with(RedstoneSink.class, VecDirectionFlags.verticals(), VerticalWireComponent::getRedstoneSink).with(Wire.class, VecDirectionFlags.verticals(), c -> c).with(RedstoneWire.class, VecDirectionFlags.verticals(), c -> c).build();
    private final int[] sideInputs = new int[2];
    private final Conductor conductor = new Conductor();
    private int power;

    public VerticalWireComponent(ComponentContext context) {
        super(SCMComponents.VERTICAL_WIRE, context, INTERFACES);
    }

    public ComponentState getState() {
        return super.getState().setExtended(PROP_EXT_POWER, (Comparable)Integer.valueOf(this.power));
    }

    public AABB getBoundingBox() {
        return BOUNDS;
    }

    public ItemStack getPickedItem() {
        return new ItemStack((ItemLike)SCMItems.REDSTONE_STICK.get());
    }

    @Override
    protected WireConnectionState getNextState(VecDirection side, WireConnectionState state, CircuitComponent neighbor, boolean forced) {
        return WireUtils.getNextState(side, state, neighbor, RedstoneSource.class, RedstoneSink.class);
    }

    @Override
    protected boolean isValidState(VecDirection side, WireConnectionState state, CircuitComponent neighbor) {
        return WireUtils.isValidState(side, state, neighbor, RedstoneSource.class, RedstoneSink.class);
    }

    @Override
    protected void onStateTransition(VecDirection side, WireConnectionState prevState, WireConnectionState newState) {
        Wire wire;
        CircuitComponent neighbor;
        this.sendEvent(CircuitEvent.NEIGHBOR_CHANGED, new VecDirection[]{side});
        if (prevState == WireConnectionState.OUTPUT || newState == WireConnectionState.OUTPUT) {
            this.sendEvent(CircuitEvent.REDSTONE, new VecDirection[]{side});
        }
        if (prevState == WireConnectionState.WIRE || newState == WireConnectionState.WIRE) {
            this.conductor.invalidateNetwork();
        }
        if ((neighbor = this.findConnectionTarget(side)) != null && (wire = (Wire)neighbor.getInterface(side.getOpposite(), Wire.class)) != null) {
            wire.setState(side.getOpposite(), newState.getOpposite());
        }
    }

    @Override
    protected void updateSignals(VecDirectionFlags sides) {
        for (VecDirection side : sides) {
            boolean isInput = this.getStateInternal(side) == WireConnectionState.INPUT;
            this.sideInputs[side.getAxisDirection().ordinal()] = isInput ? this.getInput(side) : 0;
        }
        int newInput = Arrays.stream(this.sideInputs).max().orElse(0);
        this.conductor.setInput(newInput);
    }

    private int getInput(VecDirection side) {
        CircuitComponent neighbor = this.findConnectionTarget(side);
        if (neighbor == null) {
            return 0;
        }
        RedstoneSource redstoneSource = (RedstoneSource)neighbor.getInterface(side.getOpposite(), RedstoneSource.class);
        return redstoneSource != null ? redstoneSource.getWeakOutput() : 0;
    }

    public void updateSequential() {
        super.updateSequential();
        this.conductor.doSequentialUpdate();
    }

    @Nullable
    public DyeColor getColor() {
        return null;
    }

    public RedstoneConductor getConductor() {
        return this.conductor;
    }

    @Override
    public CompoundTag save(CompoundTag tag) {
        tag = super.save(tag);
        tag.m_128385_("side_inputs", Arrays.copyOf(this.sideInputs, this.sideInputs.length));
        tag.m_128405_("power", this.power);
        return tag;
    }

    @Override
    public void load(CompoundTag tag) {
        super.load(tag);
        if (!tag.m_128441_("side_inputs")) {
            return;
        }
        int[] inputs = tag.m_128465_("side_inputs");
        System.arraycopy(inputs, 0, this.sideInputs, 0, inputs.length);
        this.conductor.setInputOnLoad(Arrays.stream(this.sideInputs).max().orElse(0));
        this.power = tag.m_128451_("power");
    }

    private RedstoneSource getRedstoneSource(VecDirection side) {
        if (this.getState(side) != WireConnectionState.OUTPUT) {
            return null;
        }
        return RedstoneSource.of((int)this.power, (int)this.power);
    }

    private RedstoneSink getRedstoneSink(VecDirection side) {
        if (this.getState(side) != WireConnectionState.INPUT) {
            return null;
        }
        return RedstoneSink.instance();
    }

    public static void createState(ComponentStateBuilder builder) {
        builder.addExtended(new Property[]{PROP_EXT_POWER});
    }

    public final class Conductor
    extends RedstoneConductor {
        public int getPower() {
            return VerticalWireComponent.this.power;
        }

        public void visit(RedstoneConductor.Visitor visitor) {
            for (VecDirection side : VecDirection.VALUES) {
                RedstoneWire rsWire;
                CircuitComponent neighbor;
                if (VerticalWireComponent.this.getStateInternal(side) != WireConnectionState.WIRE || (neighbor = VerticalWireComponent.this.findConnectionTarget(side)) == null || (rsWire = (RedstoneWire)neighbor.getInterface(side.getOpposite(), RedstoneWire.class)) == null) continue;
                visitor.accept(rsWire.getConductor());
            }
        }

        public void onPropagated(int newPower) {
            VerticalWireComponent.this.updateExternalState(true, () -> {
                VerticalWireComponent.this.power = newPower;
            });
            VecDirectionFlags sides = VecDirectionFlags.none();
            for (VecDirection side : VecDirection.VALUES) {
                if (VerticalWireComponent.this.getStateInternal(side) != WireConnectionState.OUTPUT) continue;
                sides = (VecDirectionFlags)sides.and((Enum)side);
            }
            VerticalWireComponent.this.sendEvent(CircuitEvent.REDSTONE, sides);
        }

        public void scheduleSequentialUpdate() {
            VerticalWireComponent.this.scheduleSequential();
        }
    }

    public static class Client
    extends ClientComponent {
        public AABB getBoundingBox(ComponentState state) {
            return BOUNDS;
        }

        public ItemStack getPickedItem(ComponentState state) {
            return new ItemStack((ItemLike)SCMItems.REDSTONE_STICK.get());
        }

        public int getTint(ComponentState state, int tintIndex) {
            if (tintIndex == 0) {
                Integer power = (Integer)state.getExtended(PROP_EXT_POWER);
                int minBrightness = 128;
                int pow = (int)((float)power.intValue() / 255.0f * (float)(255 - minBrightness) + (float)minBrightness);
                return pow << 16 | pow << 8 | pow;
            }
            return super.getTint(state, tintIndex);
        }
    }
}

