/*
 * Decompiled with CFR 0.152.
 */
package com.technicalitiesmc.scm.init;

import com.technicalitiesmc.lib.circuit.placement.ComponentPlacement;
import com.technicalitiesmc.scm.block.CircuitBlock;
import com.technicalitiesmc.scm.circuit.server.CircuitCache;
import com.technicalitiesmc.scm.placement.PlayerPlacementData;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;

public class SCMCapabilities {
    private static final ResourceLocation PLAYER_PLACEMENT_DATA_NAME = new ResourceLocation("supercircuitmaker", "player_placement_data");
    private static final ResourceLocation COMPONENT_PLACEMENT_NAME = new ResourceLocation("supercircuitmaker", "component_placement");
    private static final ResourceLocation CIRCUIT_CACHE_NAME = new ResourceLocation("supercircuitmaker", "circuit_cache");
    private static final Capability<PlayerPlacementData> PLAYER_PLACEMENT_DATA_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<PlayerPlacementData>(){});
    private static final Capability<ComponentPlacement> COMPONENT_PLACEMENT_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<ComponentPlacement>(){});
    private static final Capability<CircuitCache> CIRCUIT_CACHE_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<CircuitCache>(){});
    private static final Map<Item, ComponentPlacement> PLACEMENT_MAP = new HashMap<Item, ComponentPlacement>();

    public static void onCapabilityRegistration(RegisterCapabilitiesEvent event) {
        event.register(PlayerPlacementData.class);
        event.register(CircuitCache.class);
        event.register(CircuitBlock.Data.class);
    }

    public static void onAttachEntityCapabilities(AttachCapabilitiesEvent<Entity> event) {
        if (!(event.getObject() instanceof Player)) {
            return;
        }
        final LazyOptional placementData = LazyOptional.of(PlayerPlacementData::new);
        event.addCapability(PLAYER_PLACEMENT_DATA_NAME, new ICapabilityProvider(){

            @Nonnull
            public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
                if (cap == PLAYER_PLACEMENT_DATA_CAPABILITY) {
                    return placementData.cast();
                }
                return LazyOptional.empty();
            }
        });
        event.addListener(() -> ((LazyOptional)placementData).invalidate());
    }

    public static void onAttachItemStackCapabilities(AttachCapabilitiesEvent<ItemStack> event) {
        ComponentPlacement p = PLACEMENT_MAP.get(((ItemStack)event.getObject()).m_41720_());
        if (p == null) {
            return;
        }
        final LazyOptional placement = LazyOptional.of(() -> p);
        event.addCapability(COMPONENT_PLACEMENT_NAME, new ICapabilityProvider(){

            @Nonnull
            public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
                if (cap == COMPONENT_PLACEMENT_CAPABILITY) {
                    return placement.cast();
                }
                return LazyOptional.empty();
            }
        });
        event.addListener(() -> ((LazyOptional)placement).invalidate());
    }

    public static void onAttachLevelCapabilities(AttachCapabilitiesEvent<Level> event) {
        Object object = event.getObject();
        if (!(object instanceof ServerLevel)) {
            return;
        }
        ServerLevel sl = (ServerLevel)object;
        final LazyOptional cache = LazyOptional.of(() -> new CircuitCache(sl));
        event.addCapability(PLAYER_PLACEMENT_DATA_NAME, new ICapabilityProvider(){

            @Nonnull
            public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
                if (cap == CIRCUIT_CACHE_CAPABILITY) {
                    return cache.cast();
                }
                return LazyOptional.empty();
            }
        });
        event.addListener(() -> ((LazyOptional)cache).invalidate());
    }

    public static void addPlacementCapability(Item item, ComponentPlacement placement) {
        PLACEMENT_MAP.put(item, placement);
    }
}

