/*
 * Decompiled with CFR 0.152.
 */
package com.technicalitiesmc.scm.init;

import com.technicalitiesmc.lib.circuit.component.ClientComponent;
import com.technicalitiesmc.lib.circuit.component.ComponentSlot;
import com.technicalitiesmc.lib.circuit.component.ComponentType;
import com.technicalitiesmc.scm.component.analog.AdderComponent;
import com.technicalitiesmc.scm.component.analog.ConstantComponent;
import com.technicalitiesmc.scm.component.analog.DelayComponent;
import com.technicalitiesmc.scm.component.analog.DividerComponent;
import com.technicalitiesmc.scm.component.analog.MultiplierComponent;
import com.technicalitiesmc.scm.component.analog.OperatorComponentBase;
import com.technicalitiesmc.scm.component.analog.SubtractorComponent;
import com.technicalitiesmc.scm.component.digital.ButtonComponent;
import com.technicalitiesmc.scm.component.digital.LampComponent;
import com.technicalitiesmc.scm.component.digital.LeverComponent;
import com.technicalitiesmc.scm.component.digital.NoteComponent;
import com.technicalitiesmc.scm.component.digital.PulsarComponent;
import com.technicalitiesmc.scm.component.digital.RandomizerComponent;
import com.technicalitiesmc.scm.component.digital.TorchBottomComponent;
import com.technicalitiesmc.scm.component.digital.TorchTopComponent;
import com.technicalitiesmc.scm.component.misc.LevelIOComponent;
import com.technicalitiesmc.scm.component.misc.PlatformComponent;
import com.technicalitiesmc.scm.component.wire.BundledWireComponent;
import com.technicalitiesmc.scm.component.wire.ColoredWireComponent;
import com.technicalitiesmc.scm.component.wire.VerticalBundledWireComponent;
import com.technicalitiesmc.scm.component.wire.VerticalWireComponent;
import com.technicalitiesmc.scm.init.SCMItems;
import javax.annotation.Nonnull;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;

public final class SCMComponents {
    public static final DeferredRegister<ComponentType> REGISTRY = DeferredRegister.create(ComponentType.class, (String)"supercircuitmaker");
    public static final RegistryObject<ComponentType> TORCH_BOTTOM = SCMComponents.register("torch_bottom", TorchBottomComponent::new, TorchBottomComponent::createState, new TorchBottomComponent.Client(), ComponentSlot.DEFAULT, ComponentSlot.OVERLAY, ComponentSlot.SUPPORT);
    public static final RegistryObject<ComponentType> TORCH_TOP = SCMComponents.register("torch_top", TorchTopComponent::new, new TorchTopComponent.Client(), ComponentSlot.DEFAULT, ComponentSlot.OVERLAY);
    public static final RegistryObject<ComponentType> RANDOMIZER = SCMComponents.register("randomizer", RandomizerComponent::new, RandomizerComponent::createState, new RandomizerComponent.Client(), ComponentSlot.DEFAULT, ComponentSlot.OVERLAY);
    public static final RegistryObject<ComponentType> DELAY = SCMComponents.register("delay", DelayComponent::new, DelayComponent::createState, new DelayComponent.Client(), ComponentSlot.DEFAULT, ComponentSlot.OVERLAY);
    public static final RegistryObject<ComponentType> PULSAR = SCMComponents.register("pulsar", PulsarComponent::new, PulsarComponent::createState, new PulsarComponent.Client(), ComponentSlot.DEFAULT, ComponentSlot.OVERLAY);
    public static final RegistryObject<ComponentType> NOTE = SCMComponents.register("note", NoteComponent::new, NoteComponent::createState, new NoteComponent.Client(), ComponentSlot.DEFAULT, ComponentSlot.OVERLAY);
    public static final RegistryObject<ComponentType> LAMP = SCMComponents.register("lamp", LampComponent::new, LampComponent::createState, new LampComponent.Client(), ComponentSlot.DEFAULT, ComponentSlot.OVERLAY);
    public static final RegistryObject<ComponentType> LEVER = SCMComponents.register("lever", LeverComponent::new, LeverComponent::createState, new LeverComponent.Client(), ComponentSlot.DEFAULT, ComponentSlot.OVERLAY);
    public static final RegistryObject<ComponentType> BUTTON = SCMComponents.register("button", ButtonComponent::new, ButtonComponent::createState, new ButtonComponent.Client(), ComponentSlot.DEFAULT, ComponentSlot.OVERLAY);
    public static final RegistryObject<ComponentType> PLATFORM = SCMComponents.register("platform", PlatformComponent::new, PlatformComponent::createState, new PlatformComponent.Client(), ComponentSlot.SUPPORT, new ComponentSlot[0]);
    public static final RegistryObject<ComponentType> ADDER = SCMComponents.register("adder", AdderComponent::new, OperatorComponentBase::createState, new OperatorComponentBase.Client(SCMItems.ADDER), ComponentSlot.DEFAULT, ComponentSlot.OVERLAY);
    public static final RegistryObject<ComponentType> SUBTRACTOR = SCMComponents.register("subtractor", SubtractorComponent::new, OperatorComponentBase::createState, new OperatorComponentBase.Client(SCMItems.SUBTRACTOR), ComponentSlot.DEFAULT, ComponentSlot.OVERLAY);
    public static final RegistryObject<ComponentType> MULTIPLIER = SCMComponents.register("multiplier", MultiplierComponent::new, OperatorComponentBase::createState, new OperatorComponentBase.Client(SCMItems.MULTIPLIER), ComponentSlot.DEFAULT, ComponentSlot.OVERLAY);
    public static final RegistryObject<ComponentType> DIVIDER = SCMComponents.register("divider", DividerComponent::new, OperatorComponentBase::createState, new OperatorComponentBase.Client(SCMItems.DIVIDER), ComponentSlot.DEFAULT, ComponentSlot.OVERLAY);
    public static final RegistryObject<ComponentType> CONSTANT = SCMComponents.register("constant", ConstantComponent::new, new OperatorComponentBase.Client(SCMItems.CONSTANT), ComponentSlot.DEFAULT, ComponentSlot.OVERLAY);
    public static final RegistryObject<ComponentType> REDSTONE_WIRE = SCMComponents.register("redstone_wire", ColoredWireComponent::new, ColoredWireComponent::createState, new ColoredWireComponent.Client(), ComponentSlot.DEFAULT, new ComponentSlot[0]);
    public static final RegistryObject<ComponentType> VERTICAL_WIRE = SCMComponents.register("vertical_wire", VerticalWireComponent::new, VerticalWireComponent::createState, new VerticalWireComponent.Client(), ComponentSlot.OVERLAY, new ComponentSlot[0]);
    public static final RegistryObject<ComponentType> BUNDLED_WIRE = SCMComponents.register("bundled_wire", BundledWireComponent::new, BundledWireComponent::createState, new BundledWireComponent.Client(), ComponentSlot.DEFAULT, new ComponentSlot[0]);
    public static final RegistryObject<ComponentType> VERTICAL_BUNDLED_WIRE = SCMComponents.register("vertical_bundled_wire", VerticalBundledWireComponent::new, new VerticalBundledWireComponent.Client(), ComponentSlot.OVERLAY, new ComponentSlot[0]);
    public static final RegistryObject<ComponentType> LEVEL_IO = SCMComponents.register("level_io", LevelIOComponent::new, ClientComponent.base(() -> ItemStack.f_41583_), ComponentSlot.DEFAULT, new ComponentSlot[0]);

    @Nonnull
    private static RegistryObject<ComponentType> register(String name, ComponentType.Factory factory, ClientComponent dummy, ComponentSlot slot, ComponentSlot ... additionalSlots) {
        return SCMComponents.register(name, factory, b -> {}, dummy, slot, additionalSlots);
    }

    @Nonnull
    private static RegistryObject<ComponentType> register(String name, ComponentType.Factory factory, ComponentType.StateBuilder stateBuilder, ClientComponent dummy, ComponentSlot slot, ComponentSlot ... additionalSlots) {
        return REGISTRY.register(name, () -> new ComponentType(factory, stateBuilder, dummy, slot, additionalSlots));
    }
}

