/*
 * Decompiled with CFR 0.152.
 */
package com.technicalitiesmc.scm.network;

import com.technicalitiesmc.lib.circuit.component.ComponentSlot;
import com.technicalitiesmc.lib.circuit.component.ComponentState;
import com.technicalitiesmc.lib.network.Packet;
import com.technicalitiesmc.scm.block.CircuitBlock;
import com.technicalitiesmc.scm.circuit.CircuitAdjacency;
import com.technicalitiesmc.scm.circuit.TileAccessor;
import com.technicalitiesmc.scm.circuit.client.ClientTile;
import com.technicalitiesmc.scm.circuit.util.ComponentPos;
import com.technicalitiesmc.scm.circuit.util.ComponentSlotPos;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.network.NetworkEvent;

public class ComponentSyncPacket
implements Packet {
    private static final Capability<CircuitBlock.Data> DATA_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<CircuitBlock.Data>(){});
    private final BlockPos pos;
    private final Map<ComponentSlotPos, ComponentState> states;
    private final CircuitAdjacency[] adjacency;

    public ComponentSyncPacket(BlockPos pos, Map<ComponentSlotPos, ComponentState> states, CircuitAdjacency[] adjacency) {
        this.pos = pos;
        this.states = states;
        this.adjacency = adjacency;
    }

    public ComponentSyncPacket(FriendlyByteBuf buf) {
        this.pos = buf.m_130135_();
        this.states = new HashMap<ComponentSlotPos, ComponentState>();
        this.adjacency = new CircuitAdjacency[4];
        for (int i = 0; i < this.adjacency.length; ++i) {
            this.adjacency[i] = (CircuitAdjacency)buf.m_130066_(CircuitAdjacency.class);
        }
        int entries = buf.readShort();
        for (int i = 0; i < entries; ++i) {
            ComponentPos pos = new ComponentPos(buf.readInt(), buf.readInt(), buf.readInt());
            ComponentSlot slot = (ComponentSlot)buf.m_130066_(ComponentSlot.class);
            ComponentState state = buf.readBoolean() ? ComponentState.deserialize((FriendlyByteBuf)buf) : null;
            this.states.put(new ComponentSlotPos(pos, slot), state);
        }
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130064_(this.pos);
        for (CircuitAdjacency adj : this.adjacency) {
            buf.m_130068_((Enum)adj);
        }
        buf.writeShort(this.states.size());
        this.states.forEach((pos, state) -> {
            buf.writeInt(pos.pos().x()).writeInt(pos.pos().y()).writeInt(pos.pos().z());
            buf.m_130068_((Enum)pos.slot());
            buf.writeBoolean(state != null);
            if (state != null) {
                state.serialize(buf);
            }
        });
    }

    public boolean handle(NetworkEvent.Context context) {
        context.enqueueWork(() -> {
            ClientLevel level = Minecraft.m_91087_().f_91073_;
            BlockEntity entity = level.m_7702_(this.pos);
            if (entity == null) {
                return;
            }
            CircuitBlock.Data data = (CircuitBlock.Data)entity.getCapability(DATA_CAPABILITY).orElse(null);
            if (data == null) {
                return;
            }
            TileAccessor accessor = data.getOrCreateAccessor();
            if (accessor instanceof ClientTile) {
                ClientTile ct = (ClientTile)accessor;
                this.states.forEach((pos, state) -> ct.setState(pos.toAbsolute().pos(), pos.slot(), (ComponentState)state));
                ct.setAdjacency(this.adjacency);
            }
        });
        return true;
    }
}

