/*
 * Decompiled with CFR 0.152.
 */
package com.technicalitiesmc.scm.placement;

import com.google.common.collect.Multimap;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.technicalitiesmc.lib.circuit.component.ComponentSlot;
import com.technicalitiesmc.lib.circuit.component.ComponentState;
import com.technicalitiesmc.lib.circuit.component.ComponentType;
import com.technicalitiesmc.lib.circuit.placement.ComponentPlacement;
import com.technicalitiesmc.lib.circuit.placement.PlacementContext;
import com.technicalitiesmc.lib.math.VecDirection;
import com.technicalitiesmc.scm.block.CircuitBlock;
import com.technicalitiesmc.scm.circuit.TileAccessor;
import com.technicalitiesmc.scm.circuit.client.ClientTile;
import com.technicalitiesmc.scm.circuit.util.ComponentSlotPos;
import com.technicalitiesmc.scm.client.SCMKeyMappings;
import com.technicalitiesmc.scm.client.model.CircuitModel;
import com.technicalitiesmc.scm.network.ComponentPlacePacket;
import com.technicalitiesmc.scm.network.SCMNetworkHandler;
import com.technicalitiesmc.scm.placement.PlayerPlacementData;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;

public class ComponentPlacementHandler {
    private static final Capability<CircuitBlock.Data> DATA_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<CircuitBlock.Data>(){});
    private static final Capability<ComponentPlacement> COMPONENT_PLACEMENT_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<ComponentPlacement>(){});
    private static final Capability<PlayerPlacementData> PLAYER_PLACEMENT_DATA_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<PlayerPlacementData>(){});

    public static InteractionResult onClientUse(BlockState state, ClientLevel level, BlockPos pos, LocalPlayer player, InteractionHand hand, BlockHitResult hit) {
        PlayerPlacementData data = (PlayerPlacementData)player.getCapability(PLAYER_PLACEMENT_DATA_CAPABILITY).orElse(null);
        ComponentSlotPos hitPos = CircuitBlock.resolveHit(hit);
        if (hitPos == null) {
            data.reset();
            return InteractionResult.PASS;
        }
        ComponentPlacement.Instance placement = data.getPlacement();
        PlacementContext.Client context = data.getContext();
        if (placement == null) {
            ComponentPlacement p = (ComponentPlacement)player.m_21120_(hand).getCapability(COMPONENT_PLACEMENT_CAPABILITY).orElse(null);
            ComponentPlacement.Instance instance = placement = p != null ? p.begin() : null;
            if (placement == null) {
                return InteractionResult.PASS;
            }
            BlockEntity entity = level.m_7702_(pos);
            if (entity == null) {
                return InteractionResult.PASS;
            }
            CircuitBlock.Data cbd = (CircuitBlock.Data)entity.getCapability(DATA_CAPABILITY).orElse(null);
            if (cbd == null) {
                return InteractionResult.PASS;
            }
            TileAccessor accessor = cbd.getOrCreateAccessor();
            if (!(accessor instanceof ClientTile)) {
                return InteractionResult.PASS;
            }
            ClientTile ct = (ClientTile)accessor;
            context = new SimpleClientContext((Player)player, hand, ct);
            data.set(placement, context, pos, hand);
        }
        if (placement.tick(context, hitPos.toAbsolute().pos().m_141952_((Vec3i)pos.m_141950_((Vec3i)data.getPos()).m_142393_(8)), VecDirection.fromDirection((Direction)hit.m_82434_()))) {
            return InteractionResult.CONSUME_PARTIAL;
        }
        data.reset();
        if (!placement.isValid(context)) {
            return InteractionResult.PASS;
        }
        SCMNetworkHandler.sendToServer(new ComponentPlacePacket(pos, hand, placement));
        return InteractionResult.SUCCESS;
    }

    public static boolean onClientStopUsing(ClientLevel level, LocalPlayer player) {
        PlayerPlacementData data = (PlayerPlacementData)player.getCapability(PLAYER_PLACEMENT_DATA_CAPABILITY).orElse(null);
        if (!data.isPlacing()) {
            return false;
        }
        ComponentPlacement.Instance placement = data.getPlacement();
        PlacementContext.Client context = data.getContext();
        BlockPos pos = data.getPos();
        InteractionHand hand = data.getHand();
        placement.stopPlacing(context);
        data.reset();
        if (!placement.isValid(context)) {
            return false;
        }
        SCMNetworkHandler.sendToServer(new ComponentPlacePacket(pos, hand, placement));
        return true;
    }

    public static boolean onDrawBlockHighlight(ClientLevel level, LocalPlayer player, MultiBufferSource buffers, PoseStack poseStack, float partialTicks) {
        PlayerPlacementData data = (PlayerPlacementData)player.getCapability(PLAYER_PLACEMENT_DATA_CAPABILITY).orElse(null);
        if (!data.isPlacing()) {
            return false;
        }
        ComponentPlacement.Instance placement = data.getPlacement();
        Multimap previewStates = placement.getPreviewStates((Player)player);
        if (previewStates.isEmpty()) {
            return false;
        }
        Minecraft mc = Minecraft.m_91087_();
        Vec3 cameraPos = mc.f_91063_.m_109153_().m_90583_();
        Vec3 offset = Vec3.m_82528_((Vec3i)data.getPos()).m_82546_(cameraPos);
        poseStack.m_85836_();
        poseStack.m_85837_(offset.m_7096_(), offset.m_7098_(), offset.m_7094_());
        VertexConsumer buffer = buffers.m_6299_(RenderType.m_110451_());
        CircuitModel.processComponentGeometry((Multimap<Vec3i, ComponentState>)previewStates, RenderType.m_110451_(), new Random(), quad -> buffer.putBulkData(poseStack.m_85850_(), quad, 1.0f, 1.0f, 1.0f, 1.0f, 917728, 0));
        poseStack.m_85849_();
        return false;
    }

    private static class SimpleClientContext
    implements PlacementContext.Client {
        private final Player player;
        private final InteractionHand hand;
        private final ClientTile tile;

        private SimpleClientContext(Player player, InteractionHand hand, ClientTile tile) {
            this.player = player;
            this.hand = hand;
            this.tile = tile;
        }

        public Player getPlayer() {
            return this.player;
        }

        public InteractionHand getHand() {
            return this.hand;
        }

        public VecDirection getFacing() {
            return this.getHorizontalFacing();
        }

        public VecDirection getHorizontalFacing() {
            return VecDirection.fromDirection((Direction)this.player.m_6350_());
        }

        @Nullable
        public ComponentState get(Vec3i pos, ComponentSlot slot) {
            if (pos.m_123342_() < 0 || pos.m_123342_() >= 4) {
                return null;
            }
            return this.tile.getState(pos, slot);
        }

        public boolean canPlace(Vec3i pos, ComponentType type) {
            if (pos.m_123342_() < 0 || pos.m_123342_() >= 4) {
                return false;
            }
            return this.tile.canFit(pos, type);
        }

        public boolean isTopSolid(Vec3i pos) {
            if (pos.m_123342_() == -1) {
                return true;
            }
            ComponentState state = this.get(pos, ComponentSlot.SUPPORT);
            return state != null && state.isTopSolid();
        }

        public boolean isWithinBounds(Vec3i pos) {
            return pos.m_123342_() >= 0 && pos.m_123342_() < 4;
        }

        public boolean isModifierPressed() {
            return SCMKeyMappings.COMPONENT_PLACEMENT_MODIFIER.m_90857_();
        }
    }
}

