/*
 * Decompiled with CFR 0.152.
 */
package com.technicalitiesmc.scm.placement;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.technicalitiesmc.lib.circuit.component.CircuitComponent;
import com.technicalitiesmc.lib.circuit.component.ComponentContext;
import com.technicalitiesmc.lib.circuit.component.ComponentState;
import com.technicalitiesmc.lib.circuit.component.ComponentType;
import com.technicalitiesmc.lib.circuit.placement.ComponentPlacement;
import com.technicalitiesmc.lib.circuit.placement.PlacementContext;
import com.technicalitiesmc.lib.math.VecDirection;
import com.technicalitiesmc.lib.math.VecDirectionFlags;
import com.technicalitiesmc.lib.util.AbstractFlags8;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.registries.RegistryObject;

public class WirePlacement
implements ComponentPlacement {
    private final RegistryObject<ComponentType> component;
    private final Factory factory;
    private final StateFactory stateFactory;

    public WirePlacement(RegistryObject<ComponentType> component, Factory factory, StateFactory stateFactory) {
        this.component = component;
        this.factory = factory;
        this.stateFactory = stateFactory;
    }

    public Instance begin() {
        return new Instance();
    }

    public Instance deserialize(FriendlyByteBuf buf) {
        int count = buf.readInt();
        Instance instance = new Instance();
        for (int i = 0; i < count; ++i) {
            BlockPos pos = buf.m_130135_();
            VecDirectionFlags sides = VecDirectionFlags.deserialize((byte)buf.readByte());
            instance.connectionMap.put((Vec3i)pos, sides);
        }
        instance.disconnectOthers = buf.readBoolean();
        return instance;
    }

    @FunctionalInterface
    public static interface Factory {
        public CircuitComponent create(ComponentContext var1, VecDirectionFlags var2, boolean var3, Player var4);
    }

    @FunctionalInterface
    public static interface StateFactory {
        public ComponentState create(VecDirectionFlags var1, Player var2);
    }

    private class Instance
    implements ComponentPlacement.Instance {
        private final Set<Vec3i> uniquePositions = new HashSet<Vec3i>();
        private final List<Vec3i> positions = new ArrayList<Vec3i>();
        private final List<VecDirectionFlags> connections = new ArrayList<VecDirectionFlags>();
        private final Map<Vec3i, VecDirectionFlags> connectionMap = new HashMap<Vec3i, VecDirectionFlags>();
        private boolean disconnectOthers;

        private Instance() {
        }

        public boolean tick(PlacementContext.Client context, Vec3i clickedPos, VecDirection clickedFace) {
            this.disconnectOthers = context.isModifierPressed();
            Vec3i pos = clickedPos.m_141952_(clickedFace.getOffset());
            if (!context.isTopSolid(pos.m_7495_()) || !context.canPlace(pos, (ComponentType)WirePlacement.this.component.get())) {
                return !this.positions.isEmpty();
            }
            int idx = this.positions.lastIndexOf(pos);
            if (idx != -1) {
                if (idx == this.positions.size() - 1) {
                    this.connections.set(idx, this.computeConnections(context, pos));
                    return true;
                }
                if (idx > this.positions.size() - 4) {
                    int start = Math.max(0, idx + 1);
                    this.positions.subList(start, this.positions.size()).clear();
                    this.connections.subList(start, this.connections.size()).clear();
                    this.uniquePositions.clear();
                    this.uniquePositions.addAll(this.positions);
                    return true;
                }
            }
            if (!context.getPlayer().m_7500_() && this.uniquePositions.size() >= context.getStack().m_41613_()) {
                return true;
            }
            this.uniquePositions.add(pos);
            this.positions.add(pos);
            this.connections.add(this.computeConnections(context, pos));
            return true;
        }

        private VecDirectionFlags computeConnections(PlacementContext.Client context, Vec3i pos) {
            Vec3i prevPos;
            Vec3i vec3i = prevPos = this.positions.size() >= 2 ? this.positions.get(this.positions.size() - 2) : null;
            if (prevPos == null) {
                return VecDirectionFlags.none();
            }
            if (prevPos.m_123333_(pos) != 1) {
                return VecDirectionFlags.none();
            }
            VecDirection sideFrom = VecDirection.getNearest((Vec3i)prevPos.m_141950_(pos));
            if (sideFrom.getAxis() == Direction.Axis.Y) {
                return VecDirectionFlags.none();
            }
            return VecDirectionFlags.of((VecDirection[])new VecDirection[]{sideFrom});
        }

        public void stopPlacing(PlacementContext.Client context) {
            this.disconnectOthers = context.isModifierPressed();
        }

        private void coalesce() {
            this.connectionMap.clear();
            for (int i = 0; i < this.positions.size(); ++i) {
                Vec3i pos2 = this.positions.get(i);
                VecDirectionFlags sides2 = this.connections.get(i);
                VecDirectionFlags current = this.connectionMap.getOrDefault(pos2, VecDirectionFlags.none());
                this.connectionMap.put(pos2, (VecDirectionFlags)current.and((AbstractFlags8)sides2));
            }
            this.connectionMap.forEach((pos, sides) -> {
                for (VecDirection side : sides) {
                    Vec3i neighborPos = pos.m_141952_(side.getOffset());
                    this.connectionMap.computeIfPresent(neighborPos, ($, s) -> (VecDirectionFlags)s.and((Enum)side.getOpposite()));
                }
            });
        }

        public boolean isValid(PlacementContext.Client context) {
            this.coalesce();
            return !this.connectionMap.isEmpty();
        }

        public void serialize(FriendlyByteBuf buf) {
            buf.writeInt(this.connectionMap.size());
            this.connectionMap.forEach((pos, sides) -> {
                buf.m_130064_(new BlockPos(pos));
                buf.writeByte((int)sides.serialize());
            });
            buf.writeBoolean(this.disconnectOthers);
        }

        public void place(PlacementContext.Server context) {
            if (context.tryPutAll(ctx -> {
                for (Map.Entry<Vec3i, VecDirectionFlags> entry : this.connectionMap.entrySet()) {
                    if (ctx.at(entry.getKey(), (ComponentType)WirePlacement.this.component.get(), c -> WirePlacement.this.factory.create(c, (VecDirectionFlags)entry.getValue(), this.disconnectOthers, context.getPlayer()))) continue;
                    return false;
                }
                return true;
            })) {
                context.consumeItems(this.connectionMap.size());
                context.playSound();
            }
        }

        public Multimap<Vec3i, ComponentState> getPreviewStates(Player player) {
            this.coalesce();
            ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
            this.connectionMap.forEach((pos, connections) -> builder.put(pos, (Object)WirePlacement.this.stateFactory.create((VecDirectionFlags)connections, player)));
            return builder.build();
        }
    }
}

