/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.biomeinjection;

import com.telepathicgrunt.repurposedstructures.biomeinjection.TemporaryBiomeInjection;
import com.telepathicgrunt.repurposedstructures.configs.RSMineshaftsConfig;
import com.telepathicgrunt.repurposedstructures.modinit.RSConfiguredStructures;
import com.telepathicgrunt.repurposedstructures.modinit.RSStructureTagMap;
import com.telepathicgrunt.repurposedstructures.modinit.RSStructures;
import com.telepathicgrunt.repurposedstructures.utils.BiomeSelection;
import java.util.function.Supplier;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.levelgen.feature.StructureFeature;

public final class Mineshafts {
    private Mineshafts() {
    }

    public static void addMineshafts(TemporaryBiomeInjection.BiomeInjectionHelper event) {
        if ((Double)RSMineshaftsConfig.birchMineshaftSpawnrate.get() != 0.0 && Mineshafts.genericMineshaftCheck(event, (StructureFeature)RSStructures.MINESHAFT_BIRCH.get(), () -> BiomeSelection.hasNameTemp(event, "birch"))) {
            event.addStructure(RSConfiguredStructures.MINESHAFT_BIRCH);
        }
        if ((Double)RSMineshaftsConfig.jungleMineshaftSpawnrate.get() != 0.0 && Mineshafts.genericMineshaftCheck(event, (StructureFeature)RSStructures.MINESHAFT_JUNGLE.get(), () -> BiomeSelection.haveCategoriesTemp(event, Biome.BiomeCategory.JUNGLE))) {
            event.addStructure(RSConfiguredStructures.MINESHAFT_JUNGLE);
        }
        if ((Double)RSMineshaftsConfig.desertMineshaftSpawnrate.get() != 0.0 && Mineshafts.genericMineshaftCheck(event, (StructureFeature)RSStructures.MINESHAFT_DESERT.get(), () -> BiomeSelection.haveCategoriesTemp(event, Biome.BiomeCategory.DESERT))) {
            event.addStructure(RSConfiguredStructures.MINESHAFT_DESERT);
        }
        if ((Double)RSMineshaftsConfig.savannaMineshaftSpawnrate.get() != 0.0 && Mineshafts.genericMineshaftCheck(event, (StructureFeature)RSStructures.MINESHAFT_SAVANNA.get(), () -> BiomeSelection.haveCategoriesTemp(event, Biome.BiomeCategory.SAVANNA))) {
            event.addStructure(RSConfiguredStructures.MINESHAFT_SAVANNA);
        }
        if ((Double)RSMineshaftsConfig.oceanMineshaftSpawnrate.get() != 0.0 && Mineshafts.genericMineshaftCheck(event, (StructureFeature)RSStructures.MINESHAFT_OCEAN.get(), () -> BiomeSelection.haveCategoriesTemp(event, Biome.BiomeCategory.OCEAN))) {
            event.addStructure(RSConfiguredStructures.MINESHAFT_OCEAN);
        }
        if ((Double)RSMineshaftsConfig.taigaMineshaftSpawnrate.get() != 0.0 && Mineshafts.genericMineshaftCheck(event, (StructureFeature)RSStructures.MINESHAFT_TAIGA.get(), () -> BiomeSelection.haveCategoriesTemp(event, Biome.BiomeCategory.TAIGA))) {
            event.addStructure(RSConfiguredStructures.MINESHAFT_TAIGA);
        }
        if ((Double)RSMineshaftsConfig.icyMineshaftSpawnrate.get() != 0.0 && Mineshafts.genericMineshaftCheck(event, (StructureFeature)RSStructures.MINESHAFT_ICY.get(), () -> BiomeSelection.haveCategoriesTemp(event, Biome.BiomeCategory.ICY) || BiomeSelection.hasNameTemp(event, "snowy") || BiomeSelection.isBiomeTemp(event, Biomes.f_186757_))) {
            event.addStructure(RSConfiguredStructures.MINESHAFT_ICY);
        }
        if ((Double)RSMineshaftsConfig.stoneMineshaftSpawnrate.get() != 0.0 && Mineshafts.genericMineshaftCheck(event, (StructureFeature)RSStructures.MINESHAFT_STONE.get(), () -> BiomeSelection.haveCategoriesTemp(event, Biome.BiomeCategory.MOUNTAIN) && !BiomeSelection.isBiomeTemp(event, Biomes.f_186754_, Biomes.f_186757_, Biomes.f_186756_) || BiomeSelection.haveCategoriesTemp(event, Biome.BiomeCategory.EXTREME_HILLS) || BiomeSelection.isBiomeTemp(event, Biomes.f_186759_, Biomes.f_186758_))) {
            event.addStructure(RSConfiguredStructures.MINESHAFT_STONE);
        }
        if ((Double)RSMineshaftsConfig.darkForestMineshaftSpawnrate.get() != 0.0 && Mineshafts.genericMineshaftCheck(event, (StructureFeature)RSStructures.MINESHAFT_DARK_FOREST.get(), () -> BiomeSelection.haveCategoriesTemp(event, Biome.BiomeCategory.FOREST) && BiomeSelection.hasNameTemp(event, "dark", "spooky", "dead", "haunted", "evil", "witch", "ominous", "ebony"))) {
            event.addStructure(RSConfiguredStructures.MINESHAFT_DARK_FOREST);
        }
        if ((Double)RSMineshaftsConfig.swampMineshaftSpawnrate.get() != 0.0 && Mineshafts.genericMineshaftCheck(event, (StructureFeature)RSStructures.MINESHAFT_SWAMP.get(), () -> BiomeSelection.haveCategoriesTemp(event, Biome.BiomeCategory.SWAMP))) {
            event.addStructure(RSConfiguredStructures.MINESHAFT_SWAMP);
        }
        if ((Double)RSMineshaftsConfig.netherMineshaftSpawnrate.get() != 0.0 && BiomeSelection.isBiomeAllowedTemp(event, (StructureFeature)RSStructures.MINESHAFT_CRIMSON.get(), () -> BiomeSelection.haveCategoriesTemp(event, Biome.BiomeCategory.NETHER) && BiomeSelection.hasNameTemp(event, "crimson", "_red"))) {
            event.addStructure(RSConfiguredStructures.MINESHAFT_CRIMSON);
        }
        if ((Double)RSMineshaftsConfig.netherMineshaftSpawnrate.get() != 0.0 && BiomeSelection.isBiomeAllowedTemp(event, (StructureFeature)RSStructures.MINESHAFT_WARPED.get(), () -> BiomeSelection.haveCategoriesTemp(event, Biome.BiomeCategory.NETHER) && BiomeSelection.hasNameTemp(event, "warped", "blue"))) {
            event.addStructure(RSConfiguredStructures.MINESHAFT_WARPED);
        }
        if ((Double)RSMineshaftsConfig.netherMineshaftSpawnrate.get() != 0.0 && BiomeSelection.isBiomeAllowedTemp(event, (StructureFeature)RSStructures.MINESHAFT_NETHER.get(), () -> BiomeSelection.haveCategoriesTemp(event, Biome.BiomeCategory.NETHER) && !BiomeSelection.hasNameTemp(event, "crimson", "_red", "warped", "blue"))) {
            event.addStructure(RSConfiguredStructures.MINESHAFT_NETHER);
        }
        if ((Double)RSMineshaftsConfig.endMineshaftSpawnrate.get() != 0.0 && BiomeSelection.isBiomeAllowedTemp(event, (StructureFeature)RSStructures.MINESHAFT_END.get(), () -> BiomeSelection.haveCategoriesTemp(event, Biome.BiomeCategory.THEEND) && !BiomeSelection.isBiomeTemp(event, Biomes.f_48210_) && ((Integer)RSMineshaftsConfig.endMineshaftMinIslandThickness.get() == 0 || !BiomeSelection.isBiomeTemp(event, Biomes.f_48165_, Biomes.f_48162_)))) {
            event.addStructure(RSConfiguredStructures.MINESHAFT_END);
        }
    }

    private static boolean genericMineshaftCheck(TemporaryBiomeInjection.BiomeInjectionHelper context, StructureFeature<?> structureFeature, Supplier<Boolean> condition) {
        return BiomeSelection.isBiomeAllowedTemp(context, structureFeature, () -> BiomeSelection.doesNotHaveStructureTypeTemp(context, RSStructureTagMap.STRUCTURE_TAGS.MINESHAFT) && (Boolean)condition.get() != false);
    }
}

