/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.misc;

import com.telepathicgrunt.repurposedstructures.RepurposedStructures;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.saveddata.maps.MapDecoration;
import net.minecraftforge.event.village.VillagerTradesEvent;
import net.minecraftforge.event.village.WandererTradesEvent;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.EnumUtils;

public final class MobMapTrades {
    public static final Map<VillagerProfession, List<MapTradeFinalized>> VILLAGER_MAP_TRADES = new HashMap<VillagerProfession, List<MapTradeFinalized>>();
    public static final Map<WandingTraderTradeEntry.TRADE_TYPE, List<MapTradeFinalized>> WANDERING_TRADER_MAP_TRADES = new HashMap<WandingTraderTradeEntry.TRADE_TYPE, List<MapTradeFinalized>>();

    private MobMapTrades() {
    }

    public static void setupMapTrades() {
        MobMapTrades.setupVillagerMap(RepurposedStructures.omegaMapTradeConfig.villagerMapTrades);
        MobMapTrades.setupWanderingTraderMap(RepurposedStructures.omegaMapTradeConfig.wanderingTraderMapTrades);
    }

    private static void setupVillagerMap(Map<String, List<VillagerTradeEntry>> configMap) {
        for (Map.Entry<String, List<VillagerTradeEntry>> configMapEntry : configMap.entrySet()) {
            VillagerProfession villagerProfession = (VillagerProfession)ForgeRegistries.PROFESSIONS.getValue(new ResourceLocation(configMapEntry.getKey()));
            if (villagerProfession == null) {
                RepurposedStructures.LOGGER.warn("Repurposed Structures: Unknown key {} was found in the {} config. Skipping that entry...", (Object)configMapEntry.getKey(), (Object)"villager map trades");
                continue;
            }
            for (VillagerTradeEntry villagerTradeEntry : configMapEntry.getValue()) {
                StructureFeature structureFeature = (StructureFeature)ForgeRegistries.STRUCTURE_FEATURES.getValue(new ResourceLocation(villagerTradeEntry.structure));
                if (structureFeature == null) {
                    RepurposedStructures.LOGGER.warn("Repurposed Structures (second): Unknown Structure {} was found in the {} config. Skipping that entry...", (Object)villagerTradeEntry.structure, (Object)"villager map trades");
                    continue;
                }
                MapDecoration.Type mapIcon = (MapDecoration.Type)EnumUtils.getEnum(MapDecoration.Type.class, (String)villagerTradeEntry.mapIcon.toUpperCase(Locale.ROOT));
                if (mapIcon == null) {
                    mapIcon = MapDecoration.Type.MANSION;
                }
                MapTradeFinalized finalizedTrade = new MapTradeFinalized(structureFeature, mapIcon, villagerTradeEntry.tradeLevel, villagerTradeEntry.emeraldsRequired, villagerTradeEntry.tradesAllowed, villagerTradeEntry.xpReward);
                if (!VILLAGER_MAP_TRADES.containsKey(villagerProfession)) {
                    VILLAGER_MAP_TRADES.put(villagerProfession, new ArrayList());
                }
                VILLAGER_MAP_TRADES.get(villagerProfession).add(finalizedTrade);
            }
        }
    }

    private static void setupWanderingTraderMap(Map<String, List<WandingTraderTradeEntry>> configMap) {
        for (Map.Entry<String, List<WandingTraderTradeEntry>> configMapEntry : configMap.entrySet()) {
            WandingTraderTradeEntry.TRADE_TYPE tradeType = (WandingTraderTradeEntry.TRADE_TYPE)EnumUtils.getEnum(WandingTraderTradeEntry.TRADE_TYPE.class, (String)configMapEntry.getKey());
            if (tradeType == null) {
                RepurposedStructures.LOGGER.warn("Repurposed Structures: Unknown key {} was found in the {} config. Skipping that entry...", (Object)configMapEntry.getKey(), (Object)"wandering trader map trades");
                continue;
            }
            for (WandingTraderTradeEntry wandingTraderTradeEntry : configMapEntry.getValue()) {
                StructureFeature structureFeature = (StructureFeature)ForgeRegistries.STRUCTURE_FEATURES.getValue(new ResourceLocation(wandingTraderTradeEntry.structure));
                if (structureFeature == null) {
                    RepurposedStructures.LOGGER.warn("Repurposed Structures (second): Unknown Structure {} was found in the {} config. Skipping that entry...", (Object)wandingTraderTradeEntry.structure, (Object)"wandering trader map trades");
                    continue;
                }
                MapDecoration.Type mapIcon = (MapDecoration.Type)EnumUtils.getEnum(MapDecoration.Type.class, (String)wandingTraderTradeEntry.mapIcon.toUpperCase(Locale.ROOT));
                if (mapIcon == null) {
                    mapIcon = MapDecoration.Type.MANSION;
                }
                MapTradeFinalized finalizedTrade = new MapTradeFinalized(structureFeature, mapIcon, 0, wandingTraderTradeEntry.emeraldsRequired, wandingTraderTradeEntry.tradesAllowed, wandingTraderTradeEntry.xpReward);
                if (!WANDERING_TRADER_MAP_TRADES.containsKey((Object)tradeType)) {
                    WANDERING_TRADER_MAP_TRADES.put(tradeType, new ArrayList());
                }
                WANDERING_TRADER_MAP_TRADES.get((Object)tradeType).add(finalizedTrade);
            }
        }
    }

    public static void onVillagerTradesEvent(VillagerTradesEvent event) {
        if (VILLAGER_MAP_TRADES.containsKey(event.getType())) {
            for (MapTradeFinalized mapTrade : VILLAGER_MAP_TRADES.get(event.getType())) {
                ((List)event.getTrades().get(mapTrade.tradeLevel())).add(new VillagerTrades.TreasureMapForEmeralds(mapTrade.emeraldsRequired(), mapTrade.structureFeature(), mapTrade.mapIcon(), mapTrade.tradesAllowed(), mapTrade.xpReward()));
            }
        }
    }

    public static void onWandererTradesEvent(WandererTradesEvent event) {
        for (Map.Entry<WandingTraderTradeEntry.TRADE_TYPE, List<MapTradeFinalized>> tradeEntry : WANDERING_TRADER_MAP_TRADES.entrySet()) {
            for (MapTradeFinalized mapTrade : tradeEntry.getValue()) {
                if (tradeEntry.getKey() == WandingTraderTradeEntry.TRADE_TYPE.RARE) {
                    event.getRareTrades().add(new VillagerTrades.TreasureMapForEmeralds(mapTrade.emeraldsRequired(), mapTrade.structureFeature(), mapTrade.mapIcon(), mapTrade.tradesAllowed(), mapTrade.xpReward()));
                    continue;
                }
                if (tradeEntry.getKey() != WandingTraderTradeEntry.TRADE_TYPE.COMMON) continue;
                event.getGenericTrades().add(new VillagerTrades.TreasureMapForEmeralds(mapTrade.emeraldsRequired(), mapTrade.structureFeature(), mapTrade.mapIcon(), mapTrade.tradesAllowed(), mapTrade.xpReward()));
            }
        }
    }

    public static class VillagerTradeEntry {
        public final String structure;
        public final String mapIcon;
        public final int tradeLevel;
        public final int emeraldsRequired;
        public final int tradesAllowed;
        public final int xpReward;

        public VillagerTradeEntry(String structure, String mapIcon, int tradeLevel, int emeraldsRequired, int tradesAllowed, int xpReward) {
            this.structure = structure;
            this.mapIcon = mapIcon;
            this.tradeLevel = tradeLevel;
            this.emeraldsRequired = emeraldsRequired;
            this.tradesAllowed = tradesAllowed;
            this.xpReward = xpReward;
        }
    }

    public record MapTradeFinalized(StructureFeature<?> structureFeature, MapDecoration.Type mapIcon, int tradeLevel, int emeraldsRequired, int tradesAllowed, int xpReward) {
    }

    public static class WandingTraderTradeEntry {
        public final String structure;
        public final String mapIcon;
        public final int emeraldsRequired;
        public final int tradesAllowed;
        public final int xpReward;

        public WandingTraderTradeEntry(String structure, String mapIcon, int emeraldsRequired, int tradesAllowed, int xpReward) {
            this.structure = structure;
            this.mapIcon = mapIcon;
            this.emeraldsRequired = emeraldsRequired;
            this.tradesAllowed = tradesAllowed;
            this.xpReward = xpReward;
        }

        public static enum TRADE_TYPE {
            RARE,
            COMMON;

        }
    }
}

