/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.misc;

import com.telepathicgrunt.repurposedstructures.RepurposedStructures;
import com.telepathicgrunt.repurposedstructures.modinit.RSStructures;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.random.WeightedRandomList;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.StructureFeatureManager;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.feature.StructureFeature;

public final class MobSpawningOverTime {
    public static final Map<MobCategory, Map<StructureFeature<?>, List<MobSpawnSettings.SpawnerData>>> REPLACE_MOB_SPAWNING = new HashMap();
    public static final Map<MobCategory, Map<StructureFeature<?>, List<MobSpawnSettings.SpawnerData>>> APPEND_MOB_SPAWNING = new HashMap();

    private MobSpawningOverTime() {
    }

    public static void setupMobSpawningMaps() {
        Arrays.stream(MobCategory.values()).forEach(group -> REPLACE_MOB_SPAWNING.put((MobCategory)group, new HashMap()));
        Arrays.stream(MobCategory.values()).forEach(group -> APPEND_MOB_SPAWNING.put((MobCategory)group, new HashMap()));
        MobSpawningOverTime.setupMap(REPLACE_MOB_SPAWNING, RepurposedStructures.omegaMobSpawnConfig.replaceMobSpawns, "replace mob spawning");
        MobSpawningOverTime.setupMap(APPEND_MOB_SPAWNING, RepurposedStructures.omegaMobSpawnConfig.appendMobSpawns, "append mob spawning");
    }

    private static void setupMap(Map<MobCategory, Map<StructureFeature<?>, List<MobSpawnSettings.SpawnerData>>> mapToFillWithMobSpawns, Map<String, List<PublicMobSpawnEntry>> configMap, String errorMsg) {
        for (Map.Entry<String, List<PublicMobSpawnEntry>> configMapEntry : configMap.entrySet()) {
            if (!configMapEntry.getKey().equals("all") && !configMapEntry.getKey().contains("repurposed_structures")) {
                RepurposedStructures.LOGGER.warn("Repurposed Structures: Found key that is not a repurposed structure's structure in {} config: {} Skipping that entry...", (Object)errorMsg, (Object)configMapEntry.getKey());
                continue;
            }
            if (configMapEntry.getKey().equals("all")) {
                RSStructures.RS_STRUCTURES.forEach((key, value) -> {
                    for (PublicMobSpawnEntry spawnEntry : (List)configMapEntry.getValue()) {
                        Optional entityType = Registry.f_122826_.m_6612_(new ResourceLocation(spawnEntry.type));
                        if (entityType.isEmpty()) {
                            if (!spawnEntry.logErrorIfNotFound) continue;
                            RepurposedStructures.LOGGER.warn("Repurposed Structures (first): Unknown EntityType {} was found in the {} config. Skipping that entry...", (Object)spawnEntry.type, (Object)errorMsg);
                            continue;
                        }
                        MobSpawnSettings.SpawnerData entryToAdd = new MobSpawnSettings.SpawnerData((EntityType)entityType.get(), spawnEntry.weight, spawnEntry.minGroupSize, spawnEntry.maxGroupSize);
                        Map structureMobMap = (Map)mapToFillWithMobSpawns.get(entryToAdd.f_48404_.m_20674_());
                        if (structureMobMap.containsKey(key)) {
                            ((List)structureMobMap.get(key)).add(entryToAdd);
                            continue;
                        }
                        structureMobMap.put(key, new ArrayList());
                        ((List)structureMobMap.get(key)).add(entryToAdd);
                    }
                });
                continue;
            }
            StructureFeature structureFeature = (StructureFeature)Registry.f_122841_.m_7745_(new ResourceLocation(configMapEntry.getKey()));
            if (structureFeature == null) {
                RepurposedStructures.LOGGER.warn("Repurposed Structures: Unknown key {} was found in the {} config. Skipping that entry...", (Object)configMapEntry.getKey(), (Object)errorMsg);
                continue;
            }
            for (PublicMobSpawnEntry spawnEntry : configMapEntry.getValue()) {
                Optional entityType = Registry.f_122826_.m_6612_(new ResourceLocation(spawnEntry.type));
                if (entityType.isEmpty()) {
                    if (!spawnEntry.logErrorIfNotFound) continue;
                    RepurposedStructures.LOGGER.warn("Repurposed Structures (second): Unknown EntityType {} was found in the {} config. Skipping that entry...", (Object)spawnEntry.type, (Object)errorMsg);
                    continue;
                }
                MobSpawnSettings.SpawnerData entryToAdd = new MobSpawnSettings.SpawnerData((EntityType)entityType.get(), spawnEntry.weight, spawnEntry.minGroupSize, spawnEntry.maxGroupSize);
                Map<StructureFeature<?>, List<MobSpawnSettings.SpawnerData>> structureMobMap = mapToFillWithMobSpawns.get(entryToAdd.f_48404_.m_20674_());
                if (structureMobMap.containsKey(structureFeature)) {
                    structureMobMap.get(structureFeature).add(entryToAdd);
                    continue;
                }
                structureMobMap.put(structureFeature, new ArrayList());
                structureMobMap.get(structureFeature).add(entryToAdd);
            }
        }
    }

    public static WeightedRandomList<MobSpawnSettings.SpawnerData> getStructureSpawns(Biome biome, StructureFeatureManager accessor, MobCategory spawnGroup, BlockPos pos) {
        for (Map.Entry<StructureFeature<?>, List<MobSpawnSettings.SpawnerData>> structureEntry : REPLACE_MOB_SPAWNING.get(spawnGroup).entrySet()) {
            if (structureEntry.getValue().isEmpty() || !accessor.m_186607_(pos, structureEntry.getKey()).m_73603_()) continue;
            return WeightedRandomList.m_146328_(structureEntry.getValue());
        }
        ArrayList appendedSpawn = null;
        for (Map.Entry<StructureFeature<?>, List<MobSpawnSettings.SpawnerData>> structureEntry : APPEND_MOB_SPAWNING.get(spawnGroup).entrySet()) {
            if (structureEntry.getValue().isEmpty() || !accessor.m_186607_(pos, structureEntry.getKey()).m_73603_()) continue;
            if (appendedSpawn == null) {
                appendedSpawn = new ArrayList(biome.m_47518_().m_151798_(spawnGroup).m_146338_());
            }
            appendedSpawn.addAll(structureEntry.getValue());
        }
        return appendedSpawn == null ? null : WeightedRandomList.m_146328_(appendedSpawn);
    }

    public static class PublicMobSpawnEntry {
        public final String type;
        public final int weight;
        public final int minGroupSize;
        public final int maxGroupSize;
        public final boolean logErrorIfNotFound;

        public PublicMobSpawnEntry(String type, int weight, int minGroupSize, int maxGroupSize, boolean logErrorIfNotFound) {
            this.type = type;
            this.weight = weight;
            this.minGroupSize = minGroupSize;
            this.maxGroupSize = maxGroupSize;
            this.logErrorIfNotFound = logErrorIfNotFound;
        }

        public PublicMobSpawnEntry(String type, int weight, int minGroupSize, int maxGroupSize) {
            this(type, weight, minGroupSize, maxGroupSize, true);
        }
    }
}

