/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.utils;

import com.google.common.collect.Multimap;
import com.telepathicgrunt.repurposedstructures.RepurposedStructures;
import com.telepathicgrunt.repurposedstructures.biomeinjection.TemporaryBiomeInjection;
import com.telepathicgrunt.repurposedstructures.misc.BiomeDimensionAllowDisallow;
import com.telepathicgrunt.repurposedstructures.modinit.RSStructureTagMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.data.BuiltinRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.feature.ConfiguredStructureFeature;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraftforge.event.world.BiomeLoadingEvent;

public final class BiomeSelection {
    private BiomeSelection() {
    }

    public static boolean hasName(BiomeLoadingEvent context, String ... names) {
        return Arrays.stream(names).anyMatch(name -> context.getName().m_135815_().contains((CharSequence)name));
    }

    public static boolean hasNamespace(BiomeLoadingEvent context, String ... namespace) {
        return Arrays.stream(namespace).anyMatch(name -> context.getName().m_135827_().contains((CharSequence)name));
    }

    @SafeVarargs
    public static boolean isBiome(BiomeLoadingEvent context, ResourceKey<Biome> ... keys) {
        return Arrays.stream(keys).anyMatch(key -> context.getName().equals((Object)key.m_135782_()));
    }

    public static boolean haveCategories(BiomeLoadingEvent context, Biome.BiomeCategory ... categories) {
        HashSet<Biome.BiomeCategory> categorySet = new HashSet<Biome.BiomeCategory>(Arrays.asList(categories));
        return categorySet.contains(context.getCategory());
    }

    public static boolean isBiomeAllowed(BiomeLoadingEvent context, PlacedFeature placedFeature, Supplier<Boolean> defaultCondition) {
        return BiomeSelection.isBiomeAllowed(context, placedFeature, BuiltinRegistries.f_194653_) || !BiomeSelection.isBiomeDisallowed(context, placedFeature, BuiltinRegistries.f_194653_) && defaultCondition.get() != false;
    }

    public static <T> boolean isBiomeAllowed(BiomeLoadingEvent context, T worldgenObject, Registry<T> registry) {
        ResourceLocation registryId = registry.m_7981_(worldgenObject);
        String biomeID = context.getName().toString();
        return ((List)BiomeDimensionAllowDisallow.BIOME_ALLOW.getOrDefault(registryId, new ArrayList())).stream().anyMatch(pattern -> {
            if (pattern.pattern().startsWith("#")) {
                String cleanedUpCategoryString = pattern.pattern().trim().toLowerCase(Locale.ROOT).replace("#", "");
                Biome.BiomeCategory category = Biome.BiomeCategory.m_47643_((String)cleanedUpCategoryString);
                if (category == null) {
                    RepurposedStructures.LOGGER.warn("Unknown biome category detected in one of the biome allow configs: {}", (Object)cleanedUpCategoryString);
                } else {
                    return context.getCategory().equals((Object)category);
                }
            }
            return pattern.matcher(biomeID).matches();
        });
    }

    public static <T> boolean isBiomeDisallowed(BiomeLoadingEvent context, T worldgenObject, Registry<T> registry) {
        ResourceLocation registryId = registry.m_7981_(worldgenObject);
        String biomeID = context.getName().toString();
        return ((List)BiomeDimensionAllowDisallow.BIOME_DISALLOW.getOrDefault(registryId, new ArrayList())).stream().anyMatch(pattern -> {
            if (pattern.pattern().startsWith("#")) {
                String cleanedUpCategoryString = pattern.pattern().trim().toLowerCase(Locale.ROOT).replace("#", "");
                Biome.BiomeCategory category = Biome.BiomeCategory.m_47643_((String)cleanedUpCategoryString);
                if (category == null) {
                    RepurposedStructures.LOGGER.warn("Unknown biome category detected in one of the biome disallow configs: {}", (Object)cleanedUpCategoryString);
                } else {
                    return context.getCategory().equals((Object)category);
                }
            }
            return pattern.matcher(biomeID).matches();
        });
    }

    @SafeVarargs
    public static boolean isBiomeTemp(TemporaryBiomeInjection.BiomeInjectionHelper context, ResourceKey<Biome> ... keys) {
        return Arrays.stream(keys).anyMatch(key -> context.getBiomeKey().equals(key));
    }

    public static boolean hasNameTemp(TemporaryBiomeInjection.BiomeInjectionHelper context, String ... names) {
        return Arrays.stream(names).anyMatch(name -> context.biomeKey.m_135782_().m_135815_().contains((CharSequence)name));
    }

    public static boolean hasNamespaceTemp(TemporaryBiomeInjection.BiomeInjectionHelper context, String ... namespace) {
        return Arrays.stream(namespace).anyMatch(name -> context.getBiomeKey().m_135782_().m_135827_().contains((CharSequence)name));
    }

    public static boolean haveCategoriesTemp(TemporaryBiomeInjection.BiomeInjectionHelper context, Biome.BiomeCategory ... categories) {
        HashSet<Biome.BiomeCategory> categorySet = new HashSet<Biome.BiomeCategory>(Arrays.asList(categories));
        return categorySet.contains(context.biome.m_47567_());
    }

    public static boolean doesNotHaveStructureTypeTemp(TemporaryBiomeInjection.BiomeInjectionHelper context, RSStructureTagMap.STRUCTURE_TAGS tag) {
        return RSStructureTagMap.REVERSED_TAGGED_STRUCTURES.get((Object)tag).stream().noneMatch(structure -> {
            Multimap<ConfiguredStructureFeature<?, ?>, ResourceKey<Biome>> structureFeatureResourceKeyMultimap = context.structureToMultiMap.get(structure);
            if (structureFeatureResourceKeyMultimap == null) {
                return false;
            }
            return structureFeatureResourceKeyMultimap.entries().stream().anyMatch(entry -> ((ResourceKey)entry.getValue()).equals(context.biomeKey));
        });
    }

    public static boolean isBiomeAllowedTemp(TemporaryBiomeInjection.BiomeInjectionHelper context, StructureFeature<?> structureFeature, Supplier<Boolean> defaultCondition) {
        return BiomeSelection.isBiomeAllowedTemp(context, structureFeature, Registry.f_122841_) || !BiomeSelection.isBiomeDisallowedTemp(context, structureFeature, Registry.f_122841_) && defaultCondition.get() != false;
    }

    public static <T> boolean isBiomeAllowedTemp(TemporaryBiomeInjection.BiomeInjectionHelper context, T worldgenObject, Registry<T> registry) {
        ResourceLocation registryId = registry.m_7981_(worldgenObject);
        String biomeID = context.biomeRegistry.m_7981_((Object)context.biome).toString();
        return ((List)BiomeDimensionAllowDisallow.BIOME_ALLOW.getOrDefault(registryId, new ArrayList())).stream().anyMatch(pattern -> {
            if (pattern.pattern().startsWith("#")) {
                String cleanedUpCategoryString = pattern.pattern().trim().toLowerCase(Locale.ROOT).replace("#", "");
                Biome.BiomeCategory category = Biome.BiomeCategory.m_47643_((String)cleanedUpCategoryString);
                if (category == null) {
                    RepurposedStructures.LOGGER.warn("Unknown biome category detected in one of the biome allow configs: {}", (Object)cleanedUpCategoryString);
                } else {
                    return context.biome.m_47567_().equals((Object)category);
                }
            }
            return pattern.matcher(biomeID).matches();
        });
    }

    public static <T> boolean isBiomeDisallowedTemp(TemporaryBiomeInjection.BiomeInjectionHelper context, T worldgenObject, Registry<T> registry) {
        ResourceLocation registryId = registry.m_7981_(worldgenObject);
        String biomeID = context.biomeRegistry.m_7981_((Object)context.biome).toString();
        return ((List)BiomeDimensionAllowDisallow.BIOME_DISALLOW.getOrDefault(registryId, new ArrayList())).stream().anyMatch(pattern -> {
            if (pattern.pattern().startsWith("#")) {
                String cleanedUpCategoryString = pattern.pattern().trim().toLowerCase(Locale.ROOT).replace("#", "");
                Biome.BiomeCategory category = Biome.BiomeCategory.m_47643_((String)cleanedUpCategoryString);
                if (category == null) {
                    RepurposedStructures.LOGGER.warn("Unknown biome category detected in one of the biome disallow configs: {}", (Object)cleanedUpCategoryString);
                } else {
                    return context.biome.m_47567_().equals((Object)category);
                }
            }
            return pattern.matcher(biomeID).matches();
        });
    }
}

