/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.utils;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Lifecycle;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.WritableRegistry;
import net.minecraft.resources.RegistryReadOps;
import net.minecraft.resources.RegistryResourceAccess;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;

public class SafeDecodingRegistryOps<T>
extends RegistryReadOps<T> {
    private final RegistryAccess dynamicRegistryManager;
    private final Map<ResourceKey<? extends Registry<?>>, ValueHolder<?>> valueHolders;

    public SafeDecodingRegistryOps(DynamicOps<T> delegate, ResourceManager resourceManager, RegistryAccess dynamicRegistryManager) {
        super(delegate, RegistryResourceAccess.m_195881_((ResourceManager)resourceManager), dynamicRegistryManager, Maps.newIdentityHashMap());
        this.dynamicRegistryManager = dynamicRegistryManager;
        this.valueHolders = Maps.newIdentityHashMap();
    }

    protected <E> DataResult<Pair<java.util.function.Supplier<E>, T>> m_135677_(T object, ResourceKey<? extends Registry<E>> registryKey, Codec<E> codec, boolean allowInlineDefinitions) {
        Optional optional = this.dynamicRegistryManager.m_142664_(registryKey);
        if (optional.isEmpty()) {
            return DataResult.error((String)("(Repurposed Structures SafeDecodingRegistryOps) Unknown registry: " + registryKey));
        }
        DataResult dataResult = ResourceLocation.f_135803_.decode(this.f_135465_, object);
        if (dataResult.result().isEmpty()) {
            return !allowInlineDefinitions ? DataResult.error((String)"(Repurposed Structures SafeDecodingRegistryOps) Inline definitions not allowed here") : codec.decode((DynamicOps)this, object).map(pair -> pair.mapFirst(object2 -> () -> object2));
        }
        WritableRegistry mutableRegistry = (WritableRegistry)optional.get();
        Pair pair2 = (Pair)dataResult.result().get();
        ResourceLocation identifier = (ResourceLocation)pair2.getFirst();
        try {
            return this.readAndRegisterElement(registryKey, mutableRegistry, codec, identifier).map(supplier -> Pair.of((Object)supplier, (Object)pair2.getSecond()));
        }
        catch (Exception e) {
            return DataResult.error((String)"\nRepurposed Structures: Entry failed to be parsed.\nThis is usually due to using a mod compat datapack without the other mod being on.\nEntry failed to be resolved: %s\nRegistry being used: %s".formatted(registryKey, object).indent(1));
        }
    }

    private <E> DataResult<java.util.function.Supplier<E>> readAndRegisterElement(ResourceKey<? extends Registry<E>> registryRegistryKey, WritableRegistry<E> mutableRegistry, Codec<E> codec, ResourceLocation elementId) {
        ResourceKey elementRegistryKey = ResourceKey.m_135785_(registryRegistryKey, (ResourceLocation)elementId);
        ValueHolder<E> valueHolder = this.getValueHolder(registryRegistryKey);
        DataResult dataResult = valueHolder.values.get(elementRegistryKey);
        if (dataResult != null) {
            return dataResult;
        }
        Supplier supplier = Suppliers.memoize(() -> {
            Object object = mutableRegistry.m_6246_(elementRegistryKey);
            if (object == null) {
                throw new RuntimeException("(Repurposed Structures SafeDecodingRegistryOps) Error during recursive registry parsing, element resolved too early: " + elementRegistryKey);
            }
            return object;
        });
        valueHolder.values.put(elementRegistryKey, DataResult.success((Object)supplier));
        DataResult dataResult4 = null;
        if (mutableRegistry.m_6246_(elementRegistryKey) != null) {
            dataResult4 = DataResult.success(() -> mutableRegistry.m_6246_(elementRegistryKey), (Lifecycle)Lifecycle.stable());
        }
        valueHolder.values.put(elementRegistryKey, dataResult4);
        return dataResult4;
    }

    private <E> ValueHolder<E> getValueHolder(ResourceKey<? extends Registry<E>> registryRef) {
        return this.valueHolders.computeIfAbsent(registryRef, registryKey -> new ValueHolder());
    }

    static final class ValueHolder<E> {
        private final Map<ResourceKey<E>, DataResult<java.util.function.Supplier<E>>> values = Maps.newIdentityHashMap();

        private ValueHolder() {
        }
    }
}

