/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.world.features.configs;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.function.Function;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;

public class NbtDungeonConfig
implements FeatureConfiguration {
    public static final Codec<NbtDungeonConfig> CODEC = RecordCodecBuilder.create(configInstance -> configInstance.group((App)ResourceLocation.f_135803_.fieldOf("configured_feature_name").forGetter(nbtFeatureConfig -> nbtFeatureConfig.cfID), (App)Codec.BOOL.fieldOf("replace_air").orElse((Object)false).forGetter(nbtDungeonConfig -> nbtDungeonConfig.replaceAir), (App)Codec.intRange((int)0, (int)Integer.MAX_VALUE).fieldOf("min_air_space").forGetter(nbtFeatureConfig -> nbtFeatureConfig.minAirSpace), (App)Codec.intRange((int)0, (int)Integer.MAX_VALUE).fieldOf("max_air_space").forGetter(nbtFeatureConfig -> nbtFeatureConfig.maxAirSpace), (App)Codec.intRange((int)0, (int)100).fieldOf("max_num_of_chests").forGetter(nbtFeatureConfig -> nbtFeatureConfig.maxNumOfChests), (App)Codec.BOOL.fieldOf("air_requirement_is_now_water").orElse((Object)false).forGetter(nbtDungeonConfig -> nbtDungeonConfig.airRequirementIsNowWater), (App)Codec.INT.fieldOf("structure_y_offset").orElse((Object)0).forGetter(nbtFeatureConfig -> nbtFeatureConfig.structureYOffset), (App)BlockState.f_61039_.fieldOf("loot_block").orElse((Object)Blocks.f_50087_.m_49966_()).forGetter(nbtDungeonConfig -> nbtDungeonConfig.lootBlock), (App)ResourceLocation.f_135803_.fieldOf("chest_loottable_resourcelocation").forGetter(nbtDungeonConfig -> nbtDungeonConfig.chestResourcelocation), (App)ResourceLocation.f_135803_.fieldOf("rs_spawner_resourcelocation").forGetter(nbtDungeonConfig -> nbtDungeonConfig.rsSpawnerResourcelocation), (App)ResourceLocation.f_135803_.fieldOf("processors").forGetter(nbtDungeonConfig -> nbtDungeonConfig.processor), (App)ResourceLocation.f_135803_.fieldOf("post_processors").orElse((Object)new ResourceLocation("minecraft:empty")).forGetter(nbtDungeonConfig -> nbtDungeonConfig.postProcessor), (App)Codec.mapPair((MapCodec)ResourceLocation.f_135803_.fieldOf("resourcelocation"), (MapCodec)Codec.intRange((int)1, (int)Integer.MAX_VALUE).fieldOf("weight")).codec().listOf().fieldOf("dungeon_nbt_entries").forGetter(nbtFeatureConfig -> nbtFeatureConfig.nbtResourcelocationsAndWeights)).apply((Applicative)configInstance, NbtDungeonConfig::new)).comapFlatMap(nbtDungeonConfig -> nbtDungeonConfig.maxAirSpace <= nbtDungeonConfig.minAirSpace ? DataResult.error((String)"min_air_space has to be smaller than max_air_space") : DataResult.success((Object)nbtDungeonConfig), Function.identity());
    public final ResourceLocation cfID;
    public final boolean replaceAir;
    public final int minAirSpace;
    public final int maxAirSpace;
    public final int maxNumOfChests;
    public final ResourceLocation chestResourcelocation;
    public final List<Pair<ResourceLocation, Integer>> nbtResourcelocationsAndWeights;
    public final ResourceLocation rsSpawnerResourcelocation;
    public final ResourceLocation processor;
    public final ResourceLocation postProcessor;
    public final boolean airRequirementIsNowWater;
    public final int structureYOffset;
    public final BlockState lootBlock;

    public NbtDungeonConfig(ResourceLocation cfID, boolean replaceAir, int minAirSpace, int maxAirSpace, int maxNumOfChests, boolean airRequirementIsNowWater, int structureYOffset, BlockState lootBlock, ResourceLocation chestIdentifier, ResourceLocation rsSpawnerIdentifier, ResourceLocation processor, ResourceLocation postProcessor, List<Pair<ResourceLocation, Integer>> nbtIdentifiersAndWeights) {
        this.cfID = cfID;
        this.replaceAir = replaceAir;
        this.minAirSpace = minAirSpace;
        this.maxAirSpace = maxAirSpace;
        this.maxNumOfChests = maxNumOfChests;
        this.chestResourcelocation = chestIdentifier;
        this.nbtResourcelocationsAndWeights = nbtIdentifiersAndWeights;
        this.rsSpawnerResourcelocation = rsSpawnerIdentifier;
        this.processor = processor;
        this.postProcessor = postProcessor;
        this.airRequirementIsNowWater = airRequirementIsNowWater;
        this.structureYOffset = structureYOffset;
        this.lootBlock = lootBlock;
    }

    public NbtDungeonConfig(String dungeonType, ResourceLocation postProcessor) {
        this(dungeonType, dungeonType, postProcessor);
    }

    public NbtDungeonConfig(String dungeonType, String spawnerType, ResourceLocation postProcessor) {
        this(dungeonType, spawnerType, postProcessor, 13, false, 0);
    }

    public NbtDungeonConfig(ResourceLocation cfID, String dungeonType, String spawnerType, ResourceLocation processor, ResourceLocation postProcessor) {
        this(cfID, dungeonType, spawnerType, processor, postProcessor, 13, false, 0);
    }

    public NbtDungeonConfig(String dungeonType, String spawnerType, ResourceLocation postProcessor, int maxAirSpace, boolean airRequirementIsNowWater, int structureYOffset) {
        this(dungeonType, spawnerType, new ResourceLocation("repurposed_structures", "dungeons/" + dungeonType), postProcessor, maxAirSpace, airRequirementIsNowWater, structureYOffset);
    }

    public NbtDungeonConfig(String dungeonType, String spawnerType, ResourceLocation processor, ResourceLocation postProcessor, int maxAirSpace, boolean airRequirementIsNowWater, int structureYOffset) {
        this(new ResourceLocation("repurposed_structures", "dungeon_" + dungeonType), false, 1, maxAirSpace, 2, airRequirementIsNowWater, structureYOffset, Blocks.f_50087_.m_49966_(), new ResourceLocation("repurposed_structures", "chests/dungeons/" + dungeonType), new ResourceLocation("repurposed_structures", "dungeons/" + spawnerType), processor, postProcessor, (List<Pair<ResourceLocation, Integer>>)ImmutableList.of((Object)Pair.of((Object)new ResourceLocation("repurposed_structures", "dungeons/" + dungeonType + "_1"), (Object)1), (Object)Pair.of((Object)new ResourceLocation("repurposed_structures", "dungeons/" + dungeonType + "_2"), (Object)1), (Object)Pair.of((Object)new ResourceLocation("repurposed_structures", "dungeons/" + dungeonType + "_3"), (Object)1)));
    }

    public NbtDungeonConfig(ResourceLocation cfID, String dungeonType, String spawnerType, ResourceLocation processor, ResourceLocation postProcessor, int maxAirSpace, boolean airRequirementIsNowWater, int structureYOffset) {
        this(cfID, false, 1, maxAirSpace, 2, airRequirementIsNowWater, structureYOffset, Blocks.f_50087_.m_49966_(), new ResourceLocation("repurposed_structures", "chests/dungeons/" + dungeonType), new ResourceLocation("repurposed_structures", "dungeons/" + spawnerType), processor, postProcessor, (List<Pair<ResourceLocation, Integer>>)ImmutableList.of((Object)Pair.of((Object)new ResourceLocation("repurposed_structures", "dungeons/" + dungeonType + "_1"), (Object)1), (Object)Pair.of((Object)new ResourceLocation("repurposed_structures", "dungeons/" + dungeonType + "_2"), (Object)1), (Object)Pair.of((Object)new ResourceLocation("repurposed_structures", "dungeons/" + dungeonType + "_3"), (Object)1)));
    }

    public NbtDungeonConfig(String dungeonType, String loottablePlace, ResourceLocation postProcessor, int maxAirSpace, BlockState lootBlock) {
        this(new ResourceLocation("repurposed_structures", dungeonType), false, 1, maxAirSpace, 2, false, 0, lootBlock, new ResourceLocation("repurposed_structures", loottablePlace + "/dungeons/" + dungeonType), new ResourceLocation("repurposed_structures", "dungeons/" + dungeonType), new ResourceLocation("repurposed_structures", "dungeons/" + dungeonType), postProcessor, (List<Pair<ResourceLocation, Integer>>)ImmutableList.of((Object)Pair.of((Object)new ResourceLocation("repurposed_structures", "dungeons/" + dungeonType + "_1"), (Object)1), (Object)Pair.of((Object)new ResourceLocation("repurposed_structures", "dungeons/" + dungeonType + "_2"), (Object)1), (Object)Pair.of((Object)new ResourceLocation("repurposed_structures", "dungeons/" + dungeonType + "_3"), (Object)1)));
    }
}

