/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.world.structures;

import com.mojang.serialization.Codec;
import com.telepathicgrunt.repurposedstructures.configs.RSMiscConfig;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.StructureFeatureManager;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.FeatureAccess;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.StructureFeatureConfiguration;
import net.minecraft.world.level.levelgen.structure.PostPlacementProcessor;
import net.minecraft.world.level.levelgen.structure.StructureCheckResult;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGenerator;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGeneratorSupplier;

public abstract class AbstractBaseStructure<C extends FeatureConfiguration>
extends StructureFeature<C> {
    public AbstractBaseStructure(Codec<C> codec, Predicate<PieceGeneratorSupplier.Context<C>> locationCheckPredicate, Function<PieceGeneratorSupplier.Context<C>, Optional<PieceGenerator<C>>> pieceCreationPredicate) {
        this(codec, locationCheckPredicate, pieceCreationPredicate, PostPlacementProcessor.f_192427_);
    }

    public AbstractBaseStructure(Codec<C> codec, Predicate<PieceGeneratorSupplier.Context<C>> locationCheckPredicate, Function<PieceGeneratorSupplier.Context<C>, Optional<PieceGenerator<C>>> pieceCreationPredicate, PostPlacementProcessor postPlacementProcessor) {
        super(codec, context -> {
            if (!locationCheckPredicate.test(context)) {
                return Optional.empty();
            }
            return (Optional)pieceCreationPredicate.apply(context);
        }, postPlacementProcessor);
    }

    public BlockPos m_67046_(LevelReader worldView, StructureFeatureManager structureManager, BlockPos blockPos, int radius, boolean skipExistingChunks, long seed, StructureFeatureConfiguration structureConfig) {
        return this.getNearestGeneratedFeatureExpandedAndTimed(worldView, structureManager, blockPos, radius, skipExistingChunks, seed, structureConfig);
    }

    protected BlockPos getNearestGeneratedFeatureExpandedAndTimed(LevelReader worldView, StructureFeatureManager structureManager, BlockPos blockPos, int radius, boolean skipExistingChunks, long seed, StructureFeatureConfiguration structureConfig) {
        int spacing = structureConfig.m_68171_();
        int chunkX = SectionPos.m_123171_((int)blockPos.m_123341_());
        int chunkZ = SectionPos.m_123171_((int)blockPos.m_123343_());
        int maxRadius = radius < 100 ? radius : 50000 / structureConfig.m_68171_();
        long startTime = System.currentTimeMillis();
        long abortTime = (long)((Double)RSMiscConfig.locateMaxTime.get() * 1000.0);
        for (int currentRadius = 0; currentRadius <= maxRadius; ++currentRadius) {
            for (int xRadius = -currentRadius; xRadius <= currentRadius; ++xRadius) {
                boolean xEdge = xRadius == -currentRadius || xRadius == currentRadius;
                for (int zRadius = -currentRadius; zRadius <= currentRadius; ++zRadius) {
                    boolean zEdge;
                    boolean bl = zEdge = zRadius == -currentRadius || zRadius == currentRadius;
                    if (xEdge || zEdge) {
                        int trueChunkX = chunkX + spacing * xRadius;
                        int trueChunkZ = chunkZ + spacing * zRadius;
                        ChunkPos chunkpos = this.m_191122_(structureConfig, seed, trueChunkX, trueChunkZ);
                        StructureCheckResult structurecheckresult = structureManager.m_196670_(chunkpos, (StructureFeature)this, skipExistingChunks);
                        if (structurecheckresult == StructureCheckResult.START_NOT_PRESENT) continue;
                        if (!skipExistingChunks && structurecheckresult == StructureCheckResult.START_PRESENT) {
                            return this.m_183220_(chunkpos);
                        }
                        ChunkAccess chunkaccess = worldView.m_46819_(chunkpos.f_45578_, chunkpos.f_45579_, ChunkStatus.f_62315_);
                        StructureStart structurestart = structureManager.m_47297_(SectionPos.m_175562_((ChunkAccess)chunkaccess), (StructureFeature)this, (FeatureAccess)chunkaccess);
                        if (structurestart == null || !structurestart.m_73603_()) continue;
                        if (skipExistingChunks && structurestart.m_73606_()) {
                            structureManager.m_196674_(structurestart);
                            return this.m_183220_(structurestart.m_163625_());
                        }
                        if (skipExistingChunks) continue;
                        return this.m_183220_(structurestart.m_163625_());
                    }
                    zRadius = currentRadius - 1;
                }
            }
            if (currentRadius % 3 != 0 || System.currentTimeMillis() - startTime <= abortTime) continue;
            return null;
        }
        return null;
    }
}

