/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.world.structures;

import com.telepathicgrunt.repurposedstructures.RepurposedStructures;
import com.telepathicgrunt.repurposedstructures.utils.GeneralUtils;
import com.telepathicgrunt.repurposedstructures.utils.Mutable;
import com.telepathicgrunt.repurposedstructures.world.structures.AdvancedJigsawStructure;
import com.telepathicgrunt.repurposedstructures.world.structures.codeconfigs.AdvancedJigsawStructureCodeConfig;
import com.telepathicgrunt.repurposedstructures.world.structures.codeconfigs.MineshaftCodeConfig;
import com.telepathicgrunt.repurposedstructures.world.structures.pieces.PieceLimitedJigsawManager;
import java.util.Comparator;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.RandomSource;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.feature.configurations.JigsawConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.StructureFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.structures.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.PoolElementStructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGenerator;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGeneratorSupplier;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class MineshaftStructure
extends AdvancedJigsawStructure {
    public MineshaftStructure(Predicate<PieceGeneratorSupplier.Context<NoneFeatureConfiguration>> locationCheckPredicate, Function<PieceGeneratorSupplier.Context<NoneFeatureConfiguration>, Optional<PieceGenerator<NoneFeatureConfiguration>>> pieceCreationPredicate) {
        super(locationCheckPredicate, pieceCreationPredicate);
    }

    public static MineshaftStructure create(MineshaftCodeConfig mineshaftCodeConfig) {
        Mutable<MineshaftStructure> box = new Mutable<MineshaftStructure>();
        MineshaftStructure finalInstance = new MineshaftStructure(context -> ((MineshaftStructure)((Object)((Object)box.getValue()))).isFeatureChunk((PieceGeneratorSupplier.Context<NoneFeatureConfiguration>)context, mineshaftCodeConfig), context -> ((MineshaftStructure)((Object)((Object)box.getValue()))).generatePieces((PieceGeneratorSupplier.Context<NoneFeatureConfiguration>)context, mineshaftCodeConfig));
        box.setValue(finalInstance);
        return finalInstance;
    }

    protected boolean isFeatureChunk(PieceGeneratorSupplier.Context<NoneFeatureConfiguration> context, MineshaftCodeConfig config) {
        StructureFeatureConfiguration structureConfig = context.f_197352_().m_62205_().m_64593_((StructureFeature)this);
        if (structureConfig != null) {
            WorldgenRandom random = new WorldgenRandom((RandomSource)new LegacyRandomSource(0L));
            random.m_190068_(context.f_197354_() + (long)structureConfig.m_68179_(), context.f_197355_().f_45578_, context.f_197355_().f_45579_);
            double d = (Double)config.probability.get() / 10000.0;
            return random.nextDouble() < d;
        }
        return false;
    }

    @Override
    public Optional<PieceGenerator<NoneFeatureConfiguration>> generatePieces(PieceGeneratorSupplier.Context<NoneFeatureConfiguration> context, AdvancedJigsawStructureCodeConfig config) {
        int bottomClipOff;
        int topClipOff;
        BlockPos.MutableBlockPos blockpos = new BlockPos.MutableBlockPos(context.f_197355_().m_45604_(), 0, context.f_197355_().m_45605_());
        if ((Integer)config.maxY.get() - (Integer)config.minY.get() <= 0) {
            RepurposedStructures.LOGGER.error("MinY should always be less than MaxY or else a crash will occur or no pieces will spawn. Problematic structure is:" + Registry.f_122841_.m_7981_((Object)this));
        }
        WorldgenRandom random = new WorldgenRandom((RandomSource)new LegacyRandomSource(0L));
        random.m_190068_(context.f_197354_(), context.f_197355_().f_45578_, context.f_197355_().f_45579_);
        int structureStartHeight = random.nextInt((Integer)config.maxY.get() - (Integer)config.minY.get()) + (Integer)config.minY.get();
        blockpos.m_122175_(Direction.UP, structureStartHeight);
        if (config.verticalRange == null) {
            topClipOff = config.clipOutOfBoundsPieces ? (Integer)config.maxY.get() + 5 : Integer.MAX_VALUE;
            bottomClipOff = config.clipOutOfBoundsPieces ? (Integer)config.minY.get() - 5 : Integer.MIN_VALUE;
        } else {
            topClipOff = structureStartHeight + (Integer)config.verticalRange.get();
            bottomClipOff = structureStartHeight - (Integer)config.verticalRange.get();
        }
        ResourceLocation structureID = ForgeRegistries.STRUCTURE_FEATURES.getKey((IForgeRegistryEntry)this);
        return PieceLimitedJigsawManager.assembleJigsawStructure(context, new JigsawConfiguration(() -> (StructureTemplatePool)context.f_197360_().m_175515_(Registry.f_122884_).m_7745_(config.startPool), ((Integer)config.structureSize.get()).intValue()), structureID, (BlockPos)blockpos, false, false, topClipOff, bottomClipOff, (structurePiecesBuilder, pieces) -> {
            int justBelowTerrain = MineshaftStructure.getTerrainHeight(context.f_197355_().m_151394_(0), context.f_197352_(), context.f_197357_()) - 15;
            int finalJustBelowTerrain = Math.max(justBelowTerrain, bottomClipOff);
            Optional<PoolElementStructurePiece> topPiece = pieces.stream().max(Comparator.comparingInt(piece -> piece.m_73547_().m_162400_()));
            if (topPiece.isPresent() && finalJustBelowTerrain < topClipOff && finalJustBelowTerrain < topPiece.get().m_73547_().m_162400_()) {
                int topPieceMaxY = topPiece.get().m_73547_().m_162400_();
                pieces.forEach(piece -> piece.m_6324_(0, finalJustBelowTerrain - topPieceMaxY, 0));
            }
        });
    }

    private static int getTerrainHeight(BlockPos centerPos, ChunkGenerator chunkGenerator, LevelHeightAccessor heightLimitView) {
        int height = chunkGenerator.m_156179_(centerPos.m_123341_(), centerPos.m_123343_(), Heightmap.Types.OCEAN_FLOOR_WG, heightLimitView);
        BlockPos pos = new BlockPos(centerPos.m_123341_(), GeneralUtils.getMaxTerrainLimit(chunkGenerator), centerPos.m_123343_());
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            mutable.m_122190_((Vec3i)pos).m_122175_(direction, 16);
            height = Math.min(height, chunkGenerator.m_156179_(mutable.m_123341_(), mutable.m_123343_(), Heightmap.Types.OCEAN_FLOOR_WG, heightLimitView));
        }
        return height;
    }
}

