/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.world.structures;

import com.mojang.math.Vector3f;
import com.telepathicgrunt.repurposedstructures.utils.GeneralUtils;
import com.telepathicgrunt.repurposedstructures.utils.Mutable;
import com.telepathicgrunt.repurposedstructures.world.structures.AdvancedDistanceJigsawStructure;
import com.telepathicgrunt.repurposedstructures.world.structures.codeconfigs.AdvancedDistanceJigsawStructureCodeConfig;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.core.Direction;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGenerator;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGeneratorSupplier;

public class StrongholdEndStructure
extends AdvancedDistanceJigsawStructure {
    public StrongholdEndStructure(Predicate<PieceGeneratorSupplier.Context<NoneFeatureConfiguration>> locationCheckPredicate, Function<PieceGeneratorSupplier.Context<NoneFeatureConfiguration>, Optional<PieceGenerator<NoneFeatureConfiguration>>> pieceCreationPredicate) {
        super(locationCheckPredicate, pieceCreationPredicate);
    }

    public static StrongholdEndStructure create(AdvancedDistanceJigsawStructureCodeConfig advancedDistanceJigsawStructureCodeConfig) {
        Mutable<StrongholdEndStructure> box = new Mutable<StrongholdEndStructure>();
        StrongholdEndStructure finalInstance = new StrongholdEndStructure(context -> ((StrongholdEndStructure)((Object)((Object)box.getValue()))).isFeatureChunk((PieceGeneratorSupplier.Context<NoneFeatureConfiguration>)context, advancedDistanceJigsawStructureCodeConfig), context -> ((StrongholdEndStructure)((Object)((Object)box.getValue()))).generatePieces((PieceGeneratorSupplier.Context<NoneFeatureConfiguration>)context, advancedDistanceJigsawStructureCodeConfig));
        box.setValue(finalInstance);
        return finalInstance;
    }

    @Override
    protected boolean isFeatureChunk(PieceGeneratorSupplier.Context<NoneFeatureConfiguration> context, AdvancedDistanceJigsawStructureCodeConfig config) {
        boolean superCheck = super.isFeatureChunk(context, config);
        if (!superCheck) {
            return false;
        }
        ChunkPos chunkPos = context.f_197355_();
        int minLandHeight = Math.min(GeneralUtils.getMaxTerrainLimit(context.f_197352_()), context.f_197352_().m_142062_() + 45);
        int xPos = chunkPos.m_45604_();
        int zPos = chunkPos.m_45605_();
        int landHeight = Integer.MAX_VALUE;
        for (int i = 2; i >= 1; --i) {
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                Vector3f offsetPos = direction.m_122432_();
                offsetPos.m_122261_(35.0f * (float)i);
                landHeight = this.getHeightAt(context.f_197352_(), context.f_197357_(), xPos + (int)offsetPos.m_122239_(), zPos + (int)offsetPos.m_122269_(), landHeight);
                if (landHeight >= minLandHeight) continue;
                return false;
            }
        }
        landHeight = this.getHeightAt(context.f_197352_(), context.f_197357_(), xPos, zPos, landHeight);
        return landHeight >= minLandHeight;
    }

    private int getHeightAt(ChunkGenerator chunkGenerator, LevelHeightAccessor heightLimitView, int xPos, int zPos, int landHeight) {
        landHeight = Math.min(landHeight, chunkGenerator.m_156179_(xPos, zPos, Heightmap.Types.WORLD_SURFACE_WG, heightLimitView));
        return landHeight;
    }
}

