/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.world.structures.pieces;

import com.google.common.collect.Queues;
import com.mojang.datafixers.util.Pair;
import com.telepathicgrunt.repurposedstructures.RepurposedStructures;
import com.telepathicgrunt.repurposedstructures.misc.StructurePieceCountsManager;
import com.telepathicgrunt.repurposedstructures.mixin.structures.SinglePoolElementAccessor;
import com.telepathicgrunt.repurposedstructures.mixin.structures.StructurePoolAccessor;
import com.telepathicgrunt.repurposedstructures.utils.BoxOctree;
import com.telepathicgrunt.repurposedstructures.utils.GeneralUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.QuartPos;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.core.WritableRegistry;
import net.minecraft.data.worldgen.Pools;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.block.JigsawBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.RandomSource;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.feature.configurations.JigsawConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.structures.EmptyPoolElement;
import net.minecraft.world.level.levelgen.feature.structures.JigsawJunction;
import net.minecraft.world.level.levelgen.feature.structures.SinglePoolElement;
import net.minecraft.world.level.levelgen.feature.structures.StructurePoolElement;
import net.minecraft.world.level.levelgen.feature.structures.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.PoolElementStructurePiece;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGenerator;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGeneratorSupplier;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureManager;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.phys.AABB;
import org.apache.commons.lang3.mutable.MutableObject;

public class PieceLimitedJigsawManager {
    public static Optional<PieceGenerator<NoneFeatureConfiguration>> assembleJigsawStructure(PieceGeneratorSupplier.Context<NoneFeatureConfiguration> context, JigsawConfiguration jigsawConfig, ResourceLocation structureID, BlockPos startPos, boolean doBoundaryAdjustments, boolean useHeightmap, int maxY, int minY, BiConsumer<StructurePiecesBuilder, List<PoolElementStructurePiece>> structureBoundsAdjuster) {
        return PieceLimitedJigsawManager.assembleJigsawStructure(context, jigsawConfig, structureID, startPos, doBoundaryAdjustments, useHeightmap, maxY, minY, new HashSet<ResourceLocation>(), structureBoundsAdjuster);
    }

    public static Optional<PieceGenerator<NoneFeatureConfiguration>> assembleJigsawStructure(PieceGeneratorSupplier.Context<NoneFeatureConfiguration> context, JigsawConfiguration jigsawConfig, ResourceLocation structureID, BlockPos startPos, boolean doBoundaryAdjustments, boolean useHeightmap, int maxY, int minY, Set<ResourceLocation> poolsThatIgnoreBounds, BiConsumer<StructurePiecesBuilder, List<PoolElementStructurePiece>> structureBoundsAdjuster) {
        StructurePoolElement startPieceBlueprint;
        WritableRegistry jigsawPoolRegistry = context.f_197360_().m_175512_(Registry.f_122884_);
        WorldgenRandom random = new WorldgenRandom((RandomSource)new LegacyRandomSource(0L));
        random.m_190068_(context.f_197354_(), context.f_197355_().f_45578_, context.f_197355_().f_45579_);
        Rotation rotation = Rotation.m_55956_((Random)random);
        StructureTemplatePool startPool = (StructureTemplatePool)jigsawConfig.m_67766_().get();
        if (startPool == null || startPool.m_69278_() == 0) {
            RepurposedStructures.LOGGER.warn("Repurposed Structures: Empty or nonexistent start pool in structure: {}  Crash is imminent", (Object)structureID);
        }
        if ((startPieceBlueprint = startPool.m_69273_((Random)random)) == EmptyPoolElement.f_68856_) {
            return Optional.empty();
        }
        PoolElementStructurePiece startPiece = new PoolElementStructurePiece(context.f_197359_(), startPieceBlueprint, startPos, startPieceBlueprint.m_69231_(), rotation, startPieceBlueprint.m_6867_(context.f_197359_(), startPos, rotation));
        BoundingBox pieceBoundingBox = startPiece.m_73547_();
        int pieceCenterX = (pieceBoundingBox.m_162399_() + pieceBoundingBox.m_162395_()) / 2;
        int pieceCenterZ = (pieceBoundingBox.m_162401_() + pieceBoundingBox.m_162398_()) / 2;
        int pieceCenterY = useHeightmap ? startPos.m_123342_() + context.f_197352_().m_156174_(pieceCenterX, pieceCenterZ, Heightmap.Types.WORLD_SURFACE_WG, context.f_197357_()) : startPos.m_123342_();
        int yAdjustment = pieceBoundingBox.m_162396_() + startPiece.m_72647_();
        startPiece.m_6324_(0, pieceCenterY - yAdjustment, 0);
        if (!context.f_197358_().test(context.f_197352_().m_7158_(QuartPos.m_175400_((int)pieceCenterX), QuartPos.m_175400_((int)pieceCenterY), QuartPos.m_175400_((int)pieceCenterZ)))) {
            return Optional.empty();
        }
        return Optional.of((structurePiecesBuilder, contextx) -> {
            ArrayList<PoolElementStructurePiece> components = new ArrayList<PoolElementStructurePiece>();
            components.add(startPiece);
            Map<ResourceLocation, StructurePieceCountsManager.RequiredPieceNeeds> requiredPieces = RepurposedStructures.structurePieceCountsManager.getRequirePieces(structureID);
            boolean runOnce = requiredPieces == null || requiredPieces.isEmpty();
            HashMap<ResourceLocation, Integer> currentPieceCounter = new HashMap<ResourceLocation, Integer>();
            int attempts = 0;
            while (runOnce || PieceLimitedJigsawManager.doesNotHaveAllRequiredPieces(components, requiredPieces, currentPieceCounter)) {
                if (attempts == 100) {
                    RepurposedStructures.LOGGER.error("\n-------------------------------------------------------------------\nRepurposed Structures: Failed to create valid structure with all required pieces starting from this pool file: {}. Required pieces failed to generate the required amount are: {}\n  Make sure this structure's size in the config (if it has one) is not set too low.\n  Also make sure the max height and min height for this structure in the config (if it has one) is not too close together.\n  If min and max height is super close together, the structure's pieces may not be able to fit in the narrow range and spawn.\n  Otherwise, if the min and max height ranges aren't close, and structure size isn't super small like 1 or 2, and this message still appears,\n  please report the issue to Repurposed Structures's dev with latest.log file!\n\n", (Object)startPool.m_69275_(), (Object)Arrays.toString(currentPieceCounter.entrySet().stream().filter(entry -> (Integer)entry.getValue() > 0).toArray()));
                    break;
                }
                components.clear();
                components.add(startPiece);
                if (jigsawConfig.m_67765_() > 0) {
                    AABB axisAlignedBB = new AABB((double)(pieceCenterX - 80), (double)(pieceCenterY - 120), (double)(pieceCenterZ - 80), (double)(pieceCenterX + 80 + 1), (double)(pieceCenterY + 180 + 1), (double)(pieceCenterZ + 80 + 1));
                    BoxOctree boxOctree = new BoxOctree(axisAlignedBB);
                    boxOctree.addBox(AABB.m_82321_((BoundingBox)pieceBoundingBox));
                    Entry startPieceEntry = new Entry(startPiece, (MutableObject<BoxOctree>)new MutableObject((Object)boxOctree), pieceCenterY + 80, 0);
                    Assembler assembler = new Assembler(structureID, (Registry<StructureTemplatePool>)jigsawPoolRegistry, jigsawConfig.m_67765_(), context, components, (Random)random, requiredPieces, maxY, minY, poolsThatIgnoreBounds);
                    assembler.availablePieces.addLast(startPieceEntry);
                    while (!assembler.availablePieces.isEmpty()) {
                        Entry entry2 = assembler.availablePieces.removeFirst();
                        assembler.generatePiece(entry2.piece, entry2.boxOctreeMutableObject, entry2.topYLimit, entry2.depth, doBoundaryAdjustments, context.f_197357_());
                    }
                }
                if (runOnce) break;
                ++attempts;
            }
            components.forEach(arg_0 -> ((StructurePiecesBuilder)structurePiecesBuilder).m_142679_(arg_0));
            structureBoundsAdjuster.accept(structurePiecesBuilder, components);
            if (structurePiecesBuilder.m_192798_().m_162400_() > context.f_197357_().m_151558_()) {
                structurePiecesBuilder.m_192796_();
            }
        });
    }

    private static boolean doesNotHaveAllRequiredPieces(List<? extends StructurePiece> components, Map<ResourceLocation, StructurePieceCountsManager.RequiredPieceNeeds> requiredPieces, Map<ResourceLocation, Integer> counter) {
        counter.clear();
        requiredPieces.forEach((key, value) -> counter.put((ResourceLocation)key, value.getRequiredAmount()));
        for (StructurePiece structurePiece : components) {
            ResourceLocation pieceID;
            StructurePoolElement poolElement;
            if (!(structurePiece instanceof PoolElementStructurePiece) || !((poolElement = ((PoolElementStructurePiece)structurePiece).m_72645_()) instanceof SinglePoolElement) || !counter.containsKey(pieceID = (ResourceLocation)((SinglePoolElementAccessor)poolElement).repurposedstructures_getTemplate().left().orElse(null))) continue;
            counter.put(pieceID, counter.get(pieceID) - 1);
        }
        return counter.values().stream().anyMatch(count -> count > 0);
    }

    public record Entry(PoolElementStructurePiece piece, MutableObject<BoxOctree> boxOctreeMutableObject, int topYLimit, int depth) {
    }

    public static final class Assembler {
        private final ResourceLocation structureID;
        private final Registry<StructureTemplatePool> poolRegistry;
        private final int maxDepth;
        private final ChunkGenerator chunkGenerator;
        private final StructureManager structureManager;
        private final List<? super PoolElementStructurePiece> structurePieces;
        private final Random rand;
        public final Deque<Entry> availablePieces = Queues.newArrayDeque();
        private final Map<ResourceLocation, Integer> currentPieceCounts;
        private final Map<ResourceLocation, Integer> maximumPieceCounts;
        private final Map<ResourceLocation, StructurePieceCountsManager.RequiredPieceNeeds> requiredPieces;
        private final int maxY;
        private final int minY;
        private final Set<ResourceLocation> poolsThatIgnoreBounds;

        public Assembler(ResourceLocation structureID, Registry<StructureTemplatePool> poolRegistry, int maxDepth, PieceGeneratorSupplier.Context<NoneFeatureConfiguration> context, List<? super PoolElementStructurePiece> structurePieces, Random rand, Map<ResourceLocation, StructurePieceCountsManager.RequiredPieceNeeds> requiredPieces, int maxY, int minY, Set<ResourceLocation> poolsThatIgnoreBounds) {
            this.structureID = structureID;
            this.poolRegistry = poolRegistry;
            this.maxDepth = maxDepth;
            this.chunkGenerator = context.f_197352_();
            this.structureManager = context.f_197359_();
            this.structurePieces = structurePieces;
            this.rand = rand;
            this.maxY = maxY;
            this.minY = minY;
            this.requiredPieces = requiredPieces == null ? new HashMap<ResourceLocation, StructurePieceCountsManager.RequiredPieceNeeds>() : new HashMap<ResourceLocation, StructurePieceCountsManager.RequiredPieceNeeds>(requiredPieces);
            this.maximumPieceCounts = new HashMap<ResourceLocation, Integer>(RepurposedStructures.structurePieceCountsManager.getMaximumCountForPieces(structureID));
            this.poolsThatIgnoreBounds = poolsThatIgnoreBounds;
            this.currentPieceCounts = new HashMap<ResourceLocation, Integer>();
            this.requiredPieces.forEach((key, value) -> this.currentPieceCounts.putIfAbsent((ResourceLocation)key, 0));
            this.maximumPieceCounts.forEach((key, value) -> this.currentPieceCounts.putIfAbsent((ResourceLocation)key, 0));
        }

        public void generatePiece(PoolElementStructurePiece piece, MutableObject<BoxOctree> boxOctree, int minY, int depth, boolean doBoundaryAdjustments, LevelHeightAccessor heightLimitView) {
            StructurePoolElement pieceBlueprint = piece.m_72645_();
            BlockPos piecePos = piece.m_72646_();
            Rotation pieceRotation = piece.m_6830_();
            BoundingBox pieceBoundingBox = piece.m_73547_();
            int pieceMinY = pieceBoundingBox.m_162396_();
            MutableObject<BoxOctree> parentOctree = new MutableObject<BoxOctree>();
            List pieceJigsawBlocks = pieceBlueprint.m_6439_(this.structureManager, piecePos, pieceRotation, this.rand);
            for (StructureTemplate.StructureBlockInfo jigsawBlock : pieceJigsawBlocks) {
                StructurePoolElement generatedPiece;
                int targetPieceBoundsTop;
                MutableObject<BoxOctree> octreeToUse;
                Direction direction = JigsawBlock.m_54250_((BlockState)jigsawBlock.f_74676_);
                BlockPos jigsawBlockPos = jigsawBlock.f_74675_;
                BlockPos jigsawBlockTargetPos = jigsawBlockPos.m_142300_(direction);
                ResourceLocation jigsawBlockPool = new ResourceLocation(jigsawBlock.f_74677_.m_128461_("pool"));
                Optional poolOptional = this.poolRegistry.m_6612_(jigsawBlockPool);
                if (!poolOptional.isPresent() || ((StructureTemplatePool)poolOptional.get()).m_69278_() == 0 && !Objects.equals(jigsawBlockPool, Pools.f_127186_.m_135782_())) {
                    RepurposedStructures.LOGGER.warn("Repurposed Structures: Empty or nonexistent pool: {} which is being called from {}", (Object)jigsawBlockPool, pieceBlueprint instanceof SinglePoolElement ? ((SinglePoolElementAccessor)pieceBlueprint).repurposedstructures_getTemplate().left().get() : "not a SinglePoolElement class");
                    continue;
                }
                ResourceLocation jigsawBlockFallback = ((StructureTemplatePool)poolOptional.get()).m_69263_();
                Optional fallbackOptional = this.poolRegistry.m_6612_(jigsawBlockFallback);
                if (!fallbackOptional.isPresent() || ((StructureTemplatePool)fallbackOptional.get()).m_69278_() == 0 && !Objects.equals(jigsawBlockFallback, Pools.f_127186_.m_135782_())) {
                    RepurposedStructures.LOGGER.warn("Repurposed Structures: Empty or nonexistent pool: {} which is being called from {}", (Object)jigsawBlockFallback, pieceBlueprint instanceof SinglePoolElement ? ((SinglePoolElementAccessor)pieceBlueprint).repurposedstructures_getTemplate().left().get() : "not a SinglePoolElement class");
                    continue;
                }
                boolean isTargetInsideCurrentPiece = pieceBoundingBox.m_71051_((Vec3i)jigsawBlockTargetPos);
                if (isTargetInsideCurrentPiece) {
                    octreeToUse = parentOctree;
                    targetPieceBoundsTop = pieceMinY;
                    if (parentOctree.getValue() == null) {
                        parentOctree.setValue((Object)new BoxOctree(AABB.m_82321_((BoundingBox)pieceBoundingBox)));
                    }
                } else {
                    octreeToUse = boxOctree;
                    targetPieceBoundsTop = minY;
                }
                if (depth != this.maxDepth && (generatedPiece = this.processList(new ArrayList<Pair<StructurePoolElement, Integer>>(((StructurePoolAccessor)poolOptional.get()).repurposedstructures_getRawTemplates()), doBoundaryAdjustments, jigsawBlock, jigsawBlockTargetPos, pieceMinY, jigsawBlockPos, octreeToUse, piece, depth, targetPieceBoundsTop, heightLimitView, false)) != null) continue;
                boolean ignoreBounds = false;
                if (this.poolsThatIgnoreBounds != null) {
                    ignoreBounds = this.poolsThatIgnoreBounds.contains(jigsawBlockFallback);
                }
                this.processList(new ArrayList<Pair<StructurePoolElement, Integer>>(((StructurePoolAccessor)fallbackOptional.get()).repurposedstructures_getRawTemplates()), doBoundaryAdjustments, jigsawBlock, jigsawBlockTargetPos, pieceMinY, jigsawBlockPos, octreeToUse, piece, depth, targetPieceBoundsTop, heightLimitView, ignoreBounds);
            }
        }

        private StructurePoolElement processList(List<Pair<StructurePoolElement, Integer>> candidatePieces, boolean doBoundaryAdjustments, StructureTemplate.StructureBlockInfo jigsawBlock, BlockPos jigsawBlockTargetPos, int pieceMinY, BlockPos jigsawBlockPos, MutableObject<BoxOctree> boxOctreeMutableObject, PoolElementStructurePiece piece, int depth, int targetPieceBoundsTop, LevelHeightAccessor heightLimitView, boolean ignoreBounds) {
            StructureTemplatePool.Projection piecePlacementBehavior = piece.m_72645_().m_69230_();
            boolean isPieceRigid = piecePlacementBehavior == StructureTemplatePool.Projection.RIGID;
            int jigsawBlockRelativeY = jigsawBlockPos.m_123342_() - pieceMinY;
            int surfaceHeight = -1;
            int totalCount = candidatePieces.stream().mapToInt(Pair::getSecond).reduce(0, Integer::sum);
            while (candidatePieces.size() > 0) {
                StructurePoolElement candidatePiece;
                Object chosenPiecePair = null;
                Optional<ResourceLocation> pieceNeededToSpawn = this.requiredPieces.keySet().stream().filter(key -> {
                    int currentCount = this.currentPieceCounts.get(key);
                    StructurePieceCountsManager.RequiredPieceNeeds requiredPieceNeeds = this.requiredPieces.get(key);
                    int requireCount = requiredPieceNeeds == null ? 0 : requiredPieceNeeds.getRequiredAmount();
                    return currentCount < requireCount;
                }).findFirst();
                if (pieceNeededToSpawn.isPresent()) {
                    for (int i = 0; i < candidatePieces.size(); ++i) {
                        Pair<StructurePoolElement, Integer> candidatePiecePair = candidatePieces.get(i);
                        StructurePoolElement structurePoolElement = (StructurePoolElement)candidatePiecePair.getFirst();
                        if (!(structurePoolElement instanceof SinglePoolElement) || !((ResourceLocation)((SinglePoolElementAccessor)structurePoolElement).repurposedstructures_getTemplate().left().get()).equals((Object)pieceNeededToSpawn.get())) continue;
                        if (depth >= Math.min(this.maxDepth - 1, this.requiredPieces.get(pieceNeededToSpawn.get()).getMinDistanceFromCenter())) {
                            chosenPiecePair = candidatePiecePair;
                            break;
                        }
                        totalCount -= ((Integer)candidatePiecePair.getSecond()).intValue();
                        candidatePieces.remove(candidatePiecePair);
                        break;
                    }
                }
                if (chosenPiecePair == null) {
                    int chosenWeight = this.rand.nextInt(totalCount) + 1;
                    for (Pair pair : candidatePieces) {
                        if ((chosenWeight -= ((Integer)pair.getSecond()).intValue()) > 0) continue;
                        chosenPiecePair = pair;
                        break;
                    }
                }
                if ((candidatePiece = (StructurePoolElement)chosenPiecePair.getFirst()) == EmptyPoolElement.f_68856_) {
                    return null;
                }
                ResourceLocation pieceName = null;
                if (candidatePiece instanceof SinglePoolElement && this.currentPieceCounts.containsKey(pieceName = (ResourceLocation)((SinglePoolElementAccessor)candidatePiece).repurposedstructures_getTemplate().left().get()) && this.maximumPieceCounts.containsKey(pieceName) && this.currentPieceCounts.get(pieceName) >= this.maximumPieceCounts.get(pieceName)) {
                    totalCount -= ((Integer)chosenPiecePair.getSecond()).intValue();
                    candidatePieces.remove(chosenPiecePair);
                    continue;
                }
                for (Rotation rotation : Rotation.m_55958_((Random)this.rand)) {
                    List candidateJigsawBlocks = candidatePiece.m_6439_(this.structureManager, BlockPos.f_121853_, rotation, this.rand);
                    BoundingBox tempCandidateBoundingBox = candidatePiece.m_6867_(this.structureManager, BlockPos.f_121853_, rotation);
                    int candidateHeightAdjustments = doBoundaryAdjustments && tempCandidateBoundingBox.m_71057_() <= 16 ? candidateJigsawBlocks.stream().mapToInt(pieceCandidateJigsawBlock -> {
                        if (!tempCandidateBoundingBox.m_71051_((Vec3i)pieceCandidateJigsawBlock.f_74675_.m_142300_(JigsawBlock.m_54250_((BlockState)pieceCandidateJigsawBlock.f_74676_)))) {
                            return 0;
                        }
                        ResourceLocation candidateTargetPool = new ResourceLocation(pieceCandidateJigsawBlock.f_74677_.m_128461_("pool"));
                        Optional candidateTargetPoolOptional = this.poolRegistry.m_6612_(candidateTargetPool);
                        Optional<Integer> candidateTargetFallbackOptional = candidateTargetPoolOptional.flatMap(p_242843_1_ -> this.poolRegistry.m_6612_(p_242843_1_.m_69263_()));
                        int tallestCandidateTargetPoolPieceHeight = candidateTargetPoolOptional.map(p_242842_1_ -> p_242842_1_.m_69268_(this.structureManager)).orElse(0);
                        int tallestCandidateTargetFallbackPieceHeight = candidateTargetFallbackOptional.map(p_242840_1_ -> p_242840_1_.m_69268_(this.structureManager)).orElse(0);
                        return Math.max(tallestCandidateTargetPoolPieceHeight, tallestCandidateTargetFallbackPieceHeight);
                    }).max().orElse(0) : 0;
                    for (StructureTemplate.StructureBlockInfo candidateJigsawBlock : candidateJigsawBlocks) {
                        int candidateJigsawBlockY;
                        int adjustedCandidatePieceMinY;
                        if (!GeneralUtils.canJigsawsAttach(jigsawBlock, candidateJigsawBlock)) continue;
                        BlockPos candidateJigsawBlockPos = candidateJigsawBlock.f_74675_;
                        BlockPos candidateJigsawBlockRelativePos = new BlockPos(jigsawBlockTargetPos.m_123341_() - candidateJigsawBlockPos.m_123341_(), jigsawBlockTargetPos.m_123342_() - candidateJigsawBlockPos.m_123342_(), jigsawBlockTargetPos.m_123343_() - candidateJigsawBlockPos.m_123343_());
                        BoundingBox candidateBoundingBox = candidatePiece.m_6867_(this.structureManager, candidateJigsawBlockRelativePos, rotation);
                        StructureTemplatePool.Projection candidatePlacementBehavior = candidatePiece.m_69230_();
                        boolean isCandidateRigid = candidatePlacementBehavior == StructureTemplatePool.Projection.RIGID;
                        int candidateJigsawBlockRelativeY = candidateJigsawBlockPos.m_123342_();
                        int candidateJigsawYOffsetNeeded = jigsawBlockRelativeY - candidateJigsawBlockRelativeY + JigsawBlock.m_54250_((BlockState)jigsawBlock.f_74676_).m_122430_();
                        if (isPieceRigid && isCandidateRigid) {
                            adjustedCandidatePieceMinY = pieceMinY + candidateJigsawYOffsetNeeded;
                        } else {
                            if (surfaceHeight == -1) {
                                surfaceHeight = this.chunkGenerator.m_156174_(jigsawBlockPos.m_123341_(), jigsawBlockPos.m_123343_(), Heightmap.Types.WORLD_SURFACE_WG, heightLimitView);
                            }
                            adjustedCandidatePieceMinY = surfaceHeight - candidateJigsawBlockRelativeY;
                        }
                        int candidatePieceYOffsetNeeded = adjustedCandidatePieceMinY - candidateBoundingBox.m_162396_();
                        BoundingBox adjustedCandidateBoundingBox = candidateBoundingBox.m_71045_(0, candidatePieceYOffsetNeeded, 0);
                        BlockPos adjustedCandidateJigsawBlockRelativePos = candidateJigsawBlockRelativePos.m_142082_(0, candidatePieceYOffsetNeeded, 0);
                        if (candidateHeightAdjustments > 0) {
                            int k2 = Math.max(candidateHeightAdjustments + 1, adjustedCandidateBoundingBox.m_162400_() - adjustedCandidateBoundingBox.m_162396_());
                            adjustedCandidateBoundingBox.m_162371_(new BlockPos(adjustedCandidateBoundingBox.m_162395_(), adjustedCandidateBoundingBox.m_162396_() + k2, adjustedCandidateBoundingBox.m_162398_()));
                        }
                        if (adjustedCandidateBoundingBox.m_162400_() > this.maxY || adjustedCandidateBoundingBox.m_162396_() < this.minY) continue;
                        AABB axisAlignedBB = AABB.m_82321_((BoundingBox)adjustedCandidateBoundingBox);
                        AABB axisAlignedBBDeflated = axisAlignedBB.m_82406_(0.25);
                        boolean validBounds = false;
                        if (ignoreBounds || ((BoxOctree)boxOctreeMutableObject.getValue()).boundaryContains(axisAlignedBBDeflated) && !((BoxOctree)boxOctreeMutableObject.getValue()).intersectsAnyBox(axisAlignedBBDeflated)) {
                            ((BoxOctree)boxOctreeMutableObject.getValue()).addBox(axisAlignedBB);
                            validBounds = true;
                        }
                        if (!validBounds) continue;
                        int newPieceGroundLevelDelta = piece.m_72647_();
                        int groundLevelDelta = isCandidateRigid ? newPieceGroundLevelDelta - candidateJigsawYOffsetNeeded : candidatePiece.m_69231_();
                        PoolElementStructurePiece newPiece = new PoolElementStructurePiece(this.structureManager, candidatePiece, adjustedCandidateJigsawBlockRelativePos, groundLevelDelta, rotation, adjustedCandidateBoundingBox);
                        if (isPieceRigid) {
                            candidateJigsawBlockY = pieceMinY + jigsawBlockRelativeY;
                        } else if (isCandidateRigid) {
                            candidateJigsawBlockY = adjustedCandidatePieceMinY + candidateJigsawBlockRelativeY;
                        } else {
                            if (surfaceHeight == -1) {
                                surfaceHeight = this.chunkGenerator.m_156174_(jigsawBlockPos.m_123341_(), jigsawBlockPos.m_123343_(), Heightmap.Types.WORLD_SURFACE_WG, heightLimitView);
                            }
                            candidateJigsawBlockY = surfaceHeight + candidateJigsawYOffsetNeeded / 2;
                        }
                        piece.m_72635_(new JigsawJunction(jigsawBlockTargetPos.m_123341_(), candidateJigsawBlockY - jigsawBlockRelativeY + newPieceGroundLevelDelta, jigsawBlockTargetPos.m_123343_(), candidateJigsawYOffsetNeeded, candidatePlacementBehavior));
                        newPiece.m_72635_(new JigsawJunction(jigsawBlockPos.m_123341_(), candidateJigsawBlockY - candidateJigsawBlockRelativeY + groundLevelDelta, jigsawBlockPos.m_123343_(), -candidateJigsawYOffsetNeeded, piecePlacementBehavior));
                        this.structurePieces.add((PoolElementStructurePiece)newPiece);
                        if (depth + 1 <= this.maxDepth) {
                            this.availablePieces.addLast(new Entry(newPiece, boxOctreeMutableObject, targetPieceBoundsTop, depth + 1));
                        }
                        if (pieceName != null && this.currentPieceCounts.containsKey(pieceName)) {
                            this.currentPieceCounts.put(pieceName, this.currentPieceCounts.get(pieceName) + 1);
                        }
                        return candidatePiece;
                    }
                }
                totalCount -= ((Integer)chosenPiecePair.getSecond()).intValue();
                candidatePieces.remove(chosenPiecePair);
            }
            return null;
        }
    }
}

