/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.api.container;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.api.container.IContainerDataListener;
import mcjty.lib.api.container.IGenericContainer;
import mcjty.lib.container.ContainerFactory;
import mcjty.lib.container.GenericContainer;
import mcjty.lib.tileentity.GenericEnergyStorage;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.varia.Sync;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraftforge.items.IItemHandler;
import org.apache.commons.lang3.reflect.FieldUtils;

public class DefaultContainerProvider<C extends IGenericContainer>
implements MenuProvider {
    private final String name;
    private BiFunction<Integer, Player, C> containerSupplier;
    private Supplier<? extends IItemHandler> itemHandler = () -> null;
    private Supplier<? extends GenericEnergyStorage> energyHandler = () -> null;
    private final List<DataSlot> integerListeners = new ArrayList<DataSlot>();
    private final List<DataSlot> shortListeners = new ArrayList<DataSlot>();
    private final List<IContainerDataListener> containerDataListeners = new ArrayList<IContainerDataListener>();

    public static BiFunction<Integer, Player, GenericContainer> empty(@Nonnull Supplier<MenuType<GenericContainer>> type, GenericTileEntity te) {
        return (windowId, player) -> new GenericContainer(type, (int)windowId, (Supplier<ContainerFactory>)ContainerFactory.EMPTY, te, (Player)player);
    }

    public static BiFunction<Integer, Player, GenericContainer> container(@Nonnull Supplier<MenuType<GenericContainer>> type, @Nonnull Supplier<ContainerFactory> factory, GenericTileEntity te) {
        return (windowId, player) -> new GenericContainer(type, (int)windowId, factory, te, (Player)player);
    }

    public DefaultContainerProvider(String name) {
        this.name = name;
    }

    @Nonnull
    public Component m_5446_() {
        return new TextComponent(this.name);
    }

    public DefaultContainerProvider<C> containerSupplier(BiFunction<Integer, Player, C> containerSupplier) {
        this.containerSupplier = containerSupplier;
        return this;
    }

    public DefaultContainerProvider<C> itemHandler(Supplier<? extends IItemHandler> itemHandler) {
        this.itemHandler = itemHandler;
        return this;
    }

    public DefaultContainerProvider<C> energyHandler(Supplier<? extends GenericEnergyStorage> energyHandler) {
        this.energyHandler = energyHandler;
        return this;
    }

    public DefaultContainerProvider<C> dataListener(IContainerDataListener dataListener) {
        this.containerDataListeners.add(dataListener);
        return this;
    }

    public DefaultContainerProvider<C> integerListener(DataSlot holder) {
        this.integerListeners.add(holder);
        return this;
    }

    public DefaultContainerProvider<C> shortListener(DataSlot holder) {
        this.shortListeners.add(holder);
        return this;
    }

    public DefaultContainerProvider<C> setupSync(GenericTileEntity te) {
        this.dataListener(Sync.values(new ResourceLocation("mcjtylib", "data"), te));
        return this;
    }

    private void addSyncStringListener(GenericTileEntity te, AtomicInteger idx, Field field) {
        this.dataListener(Sync.string(new ResourceLocation("mcjtylib", "s" + idx.getAndIncrement()), () -> {
            try {
                return (String)FieldUtils.readField((Field)field, (Object)((Object)te), (boolean)true);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Error accessing field", e);
            }
        }, s -> {
            try {
                FieldUtils.writeField((Field)field, (Object)((Object)te), (Object)s, (boolean)true);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Error accessing field", e);
            }
        }));
    }

    private Enum[] getEnumConstants(Class clazz) {
        List<Enum> fields = Arrays.stream(clazz.getEnumConstants()).map(o -> (Enum)o).collect(Collectors.toList());
        return fields.toArray(new Enum[0]);
    }

    private void addSyncBoolListener(GenericTileEntity te, Field field) {
        this.shortListener(Sync.bool(() -> {
            try {
                return (boolean)((Boolean)FieldUtils.readField((Field)field, (Object)((Object)te), (boolean)true));
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Error accessing field", e);
            }
        }, b -> {
            try {
                FieldUtils.writeField((Field)field, (Object)((Object)te), (Object)b, (boolean)true);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Error accessing field", e);
            }
        }));
    }

    private void addSyncIntegerListener(GenericTileEntity te, Field field) {
        this.integerListener(Sync.integer(() -> {
            try {
                return (int)((Integer)FieldUtils.readField((Field)field, (Object)((Object)te), (boolean)true));
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Error accessing field", e);
            }
        }, integer -> {
            try {
                FieldUtils.writeField((Field)field, (Object)((Object)te), (Object)integer, (boolean)true);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Error accessing field", e);
            }
        }));
    }

    private void addSyncShortListener(GenericTileEntity te, Field field) {
        this.shortListener(Sync.shortint(() -> {
            try {
                return (short)((Short)FieldUtils.readField((Field)field, (Object)((Object)te), (boolean)true));
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Error accessing field", e);
            }
        }, integer -> {
            try {
                FieldUtils.writeField((Field)field, (Object)((Object)te), (Object)integer, (boolean)true);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Error accessing field", e);
            }
        }));
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int windowId, @Nonnull Inventory playerInventory, @Nonnull Player playerEntity) {
        IGenericContainer container = (IGenericContainer)this.containerSupplier.apply(windowId, playerEntity);
        IItemHandler itemHandler = this.itemHandler.get();
        container.setupInventories(itemHandler, playerInventory);
        GenericEnergyStorage energyHandler = this.energyHandler.get();
        if (energyHandler != null) {
            energyHandler.addIntegerListeners(container);
        }
        for (DataSlot listener : this.integerListeners) {
            container.addIntegerListener(listener);
        }
        for (DataSlot listener : this.shortListeners) {
            container.addShortListener(listener);
        }
        for (IContainerDataListener dataListener : this.containerDataListeners) {
            container.addContainerDataListener(dataListener);
        }
        if (container instanceof GenericContainer) {
            ((GenericContainer)container).forceBroadcast();
        }
        return container.getAsContainer();
    }
}

