/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.tuple.Pair;

public class DelayedRenderer {
    private static final Map<RenderType, List<Pair<BlockPos, BiConsumer<PoseStack, VertexConsumer>>>> renders = new HashMap<RenderType, List<Pair<BlockPos, BiConsumer<PoseStack, VertexConsumer>>>>();
    private static final Map<BlockPos, BiConsumer<PoseStack, Vec3>> delayedRenders = new HashMap<BlockPos, BiConsumer<PoseStack, Vec3>>();
    private static final Map<BlockPos, BiFunction<Level, BlockPos, Boolean>> renderValidations = new HashMap<BlockPos, BiFunction<Level, BlockPos, Boolean>>();

    public static void render(PoseStack matrixStack) {
        MultiBufferSource.BufferSource buffer = Minecraft.m_91087_().m_91269_().m_110104_();
        Vec3 projectedView = Minecraft.m_91087_().f_91063_.m_109153_().m_90583_();
        HashSet todelete = new HashSet();
        delayedRenders.entrySet().forEach(entry -> {
            BlockPos pos = (BlockPos)entry.getKey();
            BiConsumer consumer = (BiConsumer)entry.getValue();
            if (renderValidations.getOrDefault(pos, (level, blockPos) -> false).apply((Level)Minecraft.m_91087_().f_91073_, pos).booleanValue()) {
                consumer.accept(matrixStack, projectedView);
            } else {
                todelete.add(pos);
            }
        });
        renders.forEach((type, renderlist) -> {
            VertexConsumer consumer = buffer.m_6299_(type);
            renderlist.forEach(r -> {
                RenderSystem.m_69482_();
                BlockPos pos = (BlockPos)r.getKey();
                matrixStack.m_85836_();
                matrixStack.m_85837_((double)pos.m_123341_() - projectedView.f_82479_, (double)pos.m_123342_() - projectedView.f_82480_, (double)pos.m_123343_() - projectedView.f_82481_);
                ((BiConsumer)r.getValue()).accept(matrixStack, consumer);
                matrixStack.m_85849_();
            });
            RenderSystem.m_69482_();
            buffer.m_109912_(type);
        });
        renders.clear();
        buffer.m_109911_();
    }

    public static void addRender(BlockPos pos, BiConsumer<PoseStack, Vec3> renderer, BiFunction<Level, BlockPos, Boolean> validator) {
        delayedRenders.put(pos, renderer);
        renderValidations.put(pos, validator);
    }

    public static void removeRender(BlockPos pos) {
        delayedRenders.remove(pos);
        renderValidations.remove(pos);
    }

    public static void addRender(RenderType type, BlockPos pos, BiConsumer<PoseStack, VertexConsumer> renderer) {
        renders.computeIfAbsent(type, renderType -> new ArrayList()).add(Pair.of((Object)pos, renderer));
    }
}

