/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.container;

import java.util.Iterator;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import mcjty.lib.container.ContainerFactory;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.varia.ItemStackList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;

public class GenericItemHandler
implements IItemHandlerModifiable,
INBTSerializable<ListTag> {
    private final GenericTileEntity tileEntity;
    private final ContainerFactory containerFactory;
    private final ItemStackList stacks;

    public static BiPredicate<Integer, ItemStack> slot(int s) {
        return (slot, stack) -> slot == s;
    }

    public static BiPredicate<Integer, ItemStack> notslot(int s) {
        return (slot, stack) -> slot != s;
    }

    public static BiPredicate<Integer, ItemStack> match(Supplier<? extends Item> itemSupplier) {
        Item item = itemSupplier.get();
        return (slot, stack) -> stack.m_41720_() == item;
    }

    public static BiPredicate<Integer, ItemStack> match(Item item) {
        return (slot, stack) -> stack.m_41720_() == item;
    }

    public static BiPredicate<Integer, ItemStack> no() {
        return (slot, stack) -> false;
    }

    public static BiPredicate<Integer, ItemStack> yes() {
        return (slot, stack) -> true;
    }

    public static Builder create(GenericTileEntity te, Supplier<ContainerFactory> factorySupplier) {
        return new Builder(te, factorySupplier);
    }

    public static GenericItemHandler basic(GenericTileEntity te, Supplier<ContainerFactory> factorySupplier) {
        return new GenericItemHandler(te, factorySupplier.get());
    }

    protected void onUpdate(int index, ItemStack stack) {
        this.tileEntity.markDirtyQuick();
    }

    public GenericItemHandler(GenericTileEntity te, ContainerFactory factory) {
        this.tileEntity = te;
        this.containerFactory = factory;
        this.stacks = ItemStackList.create(this.containerFactory.getContainerSlots());
    }

    public int getSlots() {
        return this.stacks.size();
    }

    @Nonnull
    public ItemStack getStackInSlot(int slot) {
        if (slot >= this.stacks.size()) {
            return ItemStack.f_41583_;
        }
        return (ItemStack)this.stacks.get(slot);
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        if (stack.m_41619_()) {
            return ItemStack.f_41583_;
        }
        if (!this.isItemInsertable(slot, stack)) {
            return stack;
        }
        ItemStack stackInSlot = this.getStackInSlot(slot);
        if (!stackInSlot.m_41619_()) {
            if (stackInSlot.m_41613_() >= Math.min(stackInSlot.m_41741_(), this.getSlotLimit(slot))) {
                return stack;
            }
            if (!ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)stackInSlot)) {
                return stack;
            }
            if (!this.isItemValid(slot, stack)) {
                return stack;
            }
            int m = Math.min(stack.m_41741_(), this.getSlotLimit(slot)) - stackInSlot.m_41613_();
            if (stack.m_41613_() <= m) {
                if (!simulate) {
                    ItemStack copy = stack.m_41777_();
                    copy.m_41769_(stackInSlot.m_41613_());
                    this.setInventorySlotContents(copy.m_41741_(), slot, copy);
                    this.onUpdate(slot, copy);
                }
                return ItemStack.f_41583_;
            }
            stack = stack.m_41777_();
            if (!simulate) {
                ItemStack copy = stack.m_41620_(m);
                copy.m_41769_(stackInSlot.m_41613_());
                this.setInventorySlotContents(copy.m_41741_(), slot, copy);
                this.onUpdate(slot, copy);
                return stack;
            }
            stack.m_41774_(m);
            return stack;
        }
        if (!this.isItemValid(slot, stack)) {
            return stack;
        }
        int m = Math.min(stack.m_41741_(), this.getSlotLimit(slot));
        if (m < stack.m_41613_()) {
            stack = stack.m_41777_();
            if (!simulate) {
                ItemStack split = stack.m_41620_(m);
                this.setInventorySlotContents(stack.m_41741_(), slot, split);
                this.onUpdate(slot, split);
                return stack;
            }
            stack.m_41774_(m);
            return stack;
        }
        if (!simulate) {
            this.setInventorySlotContents(stack.m_41741_(), slot, stack);
            this.onUpdate(slot, stack);
        }
        return ItemStack.f_41583_;
    }

    public void setInventorySlotContents(int stackLimit, int index, ItemStack stack) {
        if (index >= this.stacks.size()) {
            return;
        }
        if (this.containerFactory.isGhostSlot(index)) {
            if (!stack.m_41619_()) {
                ItemStack stack1 = stack.m_41777_();
                if (index < 9) {
                    stack1.m_41764_(1);
                }
                this.stacks.set(index, stack1);
            } else {
                this.stacks.set(index, ItemStack.f_41583_);
            }
        } else if (this.containerFactory.isGhostOutputSlot(index)) {
            if (!stack.m_41619_()) {
                this.stacks.set(index, stack.m_41777_());
            } else {
                this.stacks.set(index, ItemStack.f_41583_);
            }
        } else {
            this.stacks.set(index, stack);
            if (!stack.m_41619_() && stack.m_41613_() > stackLimit) {
                stack.m_41764_(Math.max(stackLimit, 0));
            }
            this.tileEntity.m_6596_();
        }
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (amount == 0) {
            return ItemStack.f_41583_;
        }
        ItemStack stackInSlot = this.getStackInSlot(slot);
        if (stackInSlot.m_41619_()) {
            return ItemStack.f_41583_;
        }
        if (!this.isItemExtractable(slot, stackInSlot)) {
            return ItemStack.f_41583_;
        }
        if (simulate) {
            if (stackInSlot.m_41613_() < amount) {
                return stackInSlot.m_41777_();
            }
            ItemStack copy = stackInSlot.m_41777_();
            copy.m_41764_(amount);
            return copy;
        }
        int m = Math.min(stackInSlot.m_41613_(), amount);
        ItemStack decrStackSize = this.decrStackSize(slot, m);
        this.onUpdate(slot, decrStackSize);
        return decrStackSize;
    }

    public ItemStack decrStackSize(int index, int amount) {
        if (index >= this.stacks.size()) {
            return ItemStack.f_41583_;
        }
        if (this.containerFactory.isGhostSlot(index) || this.containerFactory.isGhostOutputSlot(index)) {
            ItemStack old = (ItemStack)this.stacks.get(index);
            this.stacks.set(index, ItemStack.f_41583_);
            if (old.m_41619_()) {
                return ItemStack.f_41583_;
            }
            old.m_41764_(0);
            return old;
        }
        if (!((ItemStack)this.stacks.get(index)).m_41619_()) {
            if (((ItemStack)this.stacks.get(index)).m_41613_() <= amount) {
                ItemStack old = (ItemStack)this.stacks.get(index);
                this.stacks.set(index, ItemStack.f_41583_);
                this.tileEntity.m_6596_();
                return old;
            }
            ItemStack its = ((ItemStack)this.stacks.get(index)).m_41620_(amount);
            if (((ItemStack)this.stacks.get(index)).m_41619_()) {
                this.stacks.set(index, ItemStack.f_41583_);
            }
            this.tileEntity.m_6596_();
            return its;
        }
        return ItemStack.f_41583_;
    }

    public void setStackInSlot(int slot, @Nonnull ItemStack stack) {
        this.stacks.set(slot, stack);
        this.onUpdate(slot, stack);
    }

    public int getSlotLimit(int slot) {
        return 64;
    }

    public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
        return true;
    }

    public boolean isItemInsertable(int slot, @Nonnull ItemStack stack) {
        return this.isItemValid(slot, stack);
    }

    public boolean isItemExtractable(int slot, @Nonnull ItemStack stack) {
        return true;
    }

    public ContainerFactory getContainerFactory() {
        return this.containerFactory;
    }

    public ListTag serializeNBT() {
        ListTag bufferTagList = new ListTag();
        Iterator iterator = this.stacks.iterator();
        while (iterator.hasNext()) {
            ItemStack stack = (ItemStack)iterator.next();
            CompoundTag compoundNBT = new CompoundTag();
            if (!stack.m_41619_()) {
                stack.m_41739_(compoundNBT);
            }
            bufferTagList.add((Object)compoundNBT);
        }
        return bufferTagList;
    }

    public void deserializeNBT(ListTag nbt) {
        for (int i = 0; i < nbt.size(); ++i) {
            CompoundTag compoundNBT = nbt.m_128728_(i);
            if (i >= this.stacks.size()) continue;
            this.stacks.set(i, ItemStack.m_41712_((CompoundTag)compoundNBT));
        }
    }

    public static class Builder {
        private final GenericTileEntity te;
        private final Supplier<ContainerFactory> factorySupplier;
        private BiPredicate<Integer, ItemStack> itemValid = (slot, stack) -> true;
        private BiPredicate<Integer, ItemStack> insertable = null;
        private BiPredicate<Integer, ItemStack> extractable = (slot, stack) -> true;
        private BiConsumer<Integer, ItemStack> onUpdate = (slot, stack) -> {};
        private int slotLimit = 64;

        public Builder(GenericTileEntity te, Supplier<ContainerFactory> factorySupplier) {
            this.te = te;
            this.factorySupplier = factorySupplier;
        }

        public Builder slotLimit(int slotLimit) {
            this.slotLimit = slotLimit;
            return this;
        }

        public Builder itemValid(BiPredicate<Integer, ItemStack> itemValid) {
            this.itemValid = itemValid;
            return this;
        }

        public Builder insertable(BiPredicate<Integer, ItemStack> insertable) {
            this.insertable = insertable;
            return this;
        }

        public Builder extractable(BiPredicate<Integer, ItemStack> extractable) {
            this.extractable = extractable;
            return this;
        }

        public Builder onUpdate(BiConsumer<Integer, ItemStack> onUpdate) {
            this.onUpdate = onUpdate;
            return this;
        }

        public GenericItemHandler build() {
            return new GenericItemHandler(this.te, this.factorySupplier.get()){

                @Override
                public int getSlotLimit(int slot) {
                    return slotLimit;
                }

                @Override
                public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                    return itemValid.test(slot, stack);
                }

                @Override
                public boolean isItemInsertable(int slot, @Nonnull ItemStack stack) {
                    if (insertable == null) {
                        return this.isItemValid(slot, stack);
                    }
                    return insertable.test(slot, stack);
                }

                @Override
                public boolean isItemExtractable(int slot, @Nonnull ItemStack stack) {
                    return extractable.test(slot, stack);
                }

                @Override
                protected void onUpdate(int index, ItemStack stack) {
                    super.onUpdate(index, stack);
                    onUpdate.accept(index, stack);
                }
            };
        }
    }
}

