/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.debugtools;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.network.PacketDumpItemInfo;
import mcjty.lib.varia.Logging;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.simple.SimpleChannel;
import org.apache.logging.log4j.Level;

public class DumpItemNBT {
    public static String dumpItemNBT(@Nonnull ItemStack item, boolean verbose) {
        if (item.m_41619_()) {
            return "<null>";
        }
        JsonObject jsonObject = new JsonObject();
        jsonObject.add("item", (JsonElement)new JsonPrimitive(item.m_41720_().getRegistryName().toString()));
        if (item.m_41782_()) {
            CompoundTag tag = item.m_41783_();
            if (verbose) {
                String nbtJson = tag.toString();
                JsonParser parser = new JsonParser();
                JsonElement element = parser.parse(nbtJson);
                jsonObject.add("nbt", element);
            } else {
                JsonArray array = new JsonArray();
                for (String key : tag.m_128431_()) {
                    array.add((JsonElement)new JsonPrimitive(key));
                }
                jsonObject.add("nbt", (JsonElement)array);
            }
        }
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        return gson.toJson((JsonElement)jsonObject);
    }

    public static void dumpHeldItem(@Nullable SimpleChannel network, @Nonnull Player player, boolean verbose) {
        ItemStack item = player.m_21205_();
        if (item.m_41619_()) {
            return;
        }
        String output = DumpItemNBT.dumpItemNBT(item, verbose);
        Logging.getLogger().log(Level.INFO, "### Client side ###");
        Logging.getLogger().log(Level.INFO, output);
        if (network != null) {
            network.sendToServer((Object)new PacketDumpItemInfo(verbose));
        }
    }
}

