/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.gui;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.stream.Collectors;
import mcjty.lib.client.GuiTools;
import mcjty.lib.gui.GuiSideWindow;
import mcjty.lib.gui.ManualEntry;
import mcjty.lib.gui.Window;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraftforge.network.simple.SimpleChannel;

public class GuiItemScreen
extends Screen {
    protected SimpleChannel network;
    protected Window window;
    protected int xSize;
    protected int ySize;
    protected int guiLeft;
    protected int guiTop;
    private GuiSideWindow sideWindow;

    public GuiItemScreen(SimpleChannel network, int xSize, int ySize, ManualEntry manualEntry) {
        super((Component)new TextComponent("todo"));
        this.network = network;
        this.xSize = xSize;
        this.ySize = ySize;
        this.sideWindow = new GuiSideWindow(manualEntry.manual(), manualEntry.entry(), manualEntry.page());
    }

    public boolean m_7043_() {
        return false;
    }

    public void m_7856_() {
        super.m_7856_();
        this.guiLeft = (this.f_96543_ - this.xSize) / 2;
        this.guiTop = (this.f_96544_ - this.ySize) / 2;
        this.sideWindow.initGui(this.getMinecraft(), this, this.guiLeft, this.guiTop, this.xSize, this.ySize);
    }

    public boolean m_6375_(double x, double y, int button) {
        boolean rc = super.m_6375_(x, y, button);
        this.window.mouseClicked(x, y, button);
        this.sideWindow.getWindow().mouseClicked(x, y, button);
        return rc;
    }

    public boolean m_7979_(double x, double y, int button, double scaledX, double scaledY) {
        boolean rc = super.m_7979_(x, y, button, scaledX, scaledY);
        this.window.mouseDragged(x, y, button);
        this.sideWindow.getWindow().mouseDragged(x, y, button);
        return rc;
    }

    public boolean m_6050_(double x, double y, double amount) {
        boolean rc = super.m_6050_(x, y, amount);
        this.window.mouseScrolled(x, y, amount);
        this.sideWindow.getWindow().mouseScrolled(x, y, amount);
        return rc;
    }

    public boolean m_6348_(double x, double y, int state) {
        boolean rc = super.m_6348_(x, y, state);
        this.window.mouseReleased(x, y, state);
        this.sideWindow.getWindow().mouseReleased(x, y, state);
        return rc;
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        boolean rc = super.m_7933_(keyCode, scanCode, modifiers);
        this.window.keyTyped(keyCode, scanCode);
        return rc;
    }

    public void drawWindow(PoseStack matrixStack) {
        List processors;
        List properties;
        int y;
        int x;
        this.m_7333_(matrixStack);
        this.window.draw(matrixStack);
        this.sideWindow.getWindow().draw(matrixStack);
        List<String> tooltips = this.window.getTooltips();
        if (tooltips != null) {
            x = GuiTools.getRelativeX(this);
            y = GuiTools.getRelativeY(this);
            properties = tooltips.stream().map(TextComponent::new).collect(Collectors.toList());
            processors = Language.m_128107_().m_128112_(properties);
            this.m_96617_(matrixStack, processors, x - this.guiLeft, y - this.guiTop);
        }
        if ((tooltips = this.sideWindow.getWindow().getTooltips()) != null) {
            x = GuiTools.getRelativeX(this);
            y = GuiTools.getRelativeY(this);
            properties = tooltips.stream().map(TextComponent::new).collect(Collectors.toList());
            processors = Language.m_128107_().m_128112_(properties);
            this.m_96617_(matrixStack, processors, x - this.guiLeft, y - this.guiTop);
        }
    }
}

