/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.network;

import java.util.function.Supplier;
import mcjty.lib.debugtools.DumpBlockNBT;
import mcjty.lib.varia.LevelTools;
import mcjty.lib.varia.Logging;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.ServerOpList;
import net.minecraft.server.players.ServerOpListEntry;
import net.minecraftforge.network.NetworkEvent;
import org.apache.logging.log4j.Level;

public class PacketDumpBlockInfo {
    private final ResourceKey<net.minecraft.world.level.Level> dimid;
    private final BlockPos pos;
    private final boolean verbose;

    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130085_(this.dimid.m_135782_());
        buf.m_130064_(this.pos);
        buf.writeBoolean(this.verbose);
    }

    public PacketDumpBlockInfo(FriendlyByteBuf buf) {
        this.dimid = LevelTools.getId(buf.m_130281_());
        this.pos = buf.m_130135_();
        this.verbose = buf.readBoolean();
    }

    public PacketDumpBlockInfo(net.minecraft.world.level.Level world, BlockPos pos, boolean verbose) {
        this.dimid = world.m_46472_();
        this.pos = pos;
        this.verbose = verbose;
    }

    public void handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context ctx = supplier.get();
        ctx.enqueueWork(() -> {
            int perm;
            ServerPlayer player = ctx.getSender();
            MinecraftServer server = player.m_20193_().m_142572_();
            ServerOpList oppedPlayers = server.m_6846_().m_11307_();
            ServerOpListEntry entry = (ServerOpListEntry)oppedPlayers.m_11388_((Object)player.m_36316_());
            int n = perm = entry == null ? server.m_7022_() : entry.m_11363_();
            if (perm >= 1) {
                ServerLevel world = LevelTools.getLevel(player.f_19853_, this.dimid);
                String output = DumpBlockNBT.dumpBlockNBT((net.minecraft.world.level.Level)world, this.pos, this.verbose);
                Logging.getLogger().log(Level.INFO, "### Server side ###");
                Logging.getLogger().log(Level.INFO, output);
            }
        });
        ctx.setPacketHandled(true);
    }
}

