/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.varia;

import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nullable;
import mcjty.lib.McJtyLib;
import mcjty.lib.api.power.IBigPower;
import mcjty.lib.compat.TeslaCompatibility;
import mcjty.lib.tileentity.GenericEnergyStorage;
import mcjty.lib.varia.IEnergyItem;
import mcjty.lib.varia.OrientationTools;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.energy.CapabilityEnergy;

public class EnergyTools {
    public static boolean isEnergyTE(BlockEntity te, @Nullable Direction side) {
        if (te == null) {
            return false;
        }
        if (McJtyLib.tesla && TeslaCompatibility.isEnergyHandler(te, side)) {
            return true;
        }
        return te.getCapability(CapabilityEnergy.ENERGY, side).isPresent();
    }

    public static boolean isEnergyItem(ItemStack stack) {
        Item item = stack.m_41720_();
        if (item instanceof IEnergyItem) {
            return true;
        }
        if (McJtyLib.tesla && TeslaCompatibility.isEnergyItem(stack)) {
            return true;
        }
        return stack.getCapability(CapabilityEnergy.ENERGY).isPresent();
    }

    public static EnergyLevel getEnergyLevelMulti(BlockEntity tileEntity, @Nullable Direction side) {
        long energyStored;
        long maxEnergyStored;
        if (tileEntity instanceof IBigPower) {
            maxEnergyStored = ((IBigPower)tileEntity).getCapacity();
            energyStored = ((IBigPower)tileEntity).getStoredPower();
        } else if (McJtyLib.tesla && TeslaCompatibility.isEnergyHandler(tileEntity, side)) {
            maxEnergyStored = TeslaCompatibility.getMaxEnergy(tileEntity, side);
            energyStored = TeslaCompatibility.getEnergy(tileEntity, side);
        } else {
            if (tileEntity != null) {
                return tileEntity.getCapability(CapabilityEnergy.ENERGY, side).map(h -> new EnergyLevel(h.getEnergyStored(), h.getMaxEnergyStored())).orElse(new EnergyLevel(0L, 0L));
            }
            maxEnergyStored = 0L;
            energyStored = 0L;
        }
        return new EnergyLevel(energyStored, maxEnergyStored);
    }

    public static EnergyLevel getEnergyLevel(BlockEntity tileEntity, @Nullable Direction side) {
        AtomicLong maxEnergyStored = new AtomicLong();
        AtomicLong energyStored = new AtomicLong();
        if (McJtyLib.tesla && TeslaCompatibility.isEnergyHandler(tileEntity, side)) {
            maxEnergyStored.set(TeslaCompatibility.getMaxEnergy(tileEntity, side));
            energyStored.set(TeslaCompatibility.getEnergy(tileEntity, side));
        } else if (tileEntity != null) {
            tileEntity.getCapability(CapabilityEnergy.ENERGY, side).ifPresent(handler -> {
                maxEnergyStored.set(handler.getMaxEnergyStored());
                energyStored.set(handler.getEnergyStored());
            });
        } else {
            maxEnergyStored.set(0L);
            energyStored.set(0L);
        }
        return new EnergyLevel(energyStored.get(), maxEnergyStored.get());
    }

    public static long receiveEnergy(BlockEntity tileEntity, Direction from, long maxReceive) {
        if (McJtyLib.tesla && TeslaCompatibility.isEnergyReceiver(tileEntity, from)) {
            return TeslaCompatibility.receiveEnergy(tileEntity, from, maxReceive);
        }
        if (tileEntity != null) {
            return tileEntity.getCapability(CapabilityEnergy.ENERGY, from).map(handler -> handler.receiveEnergy(EnergyTools.unsignedClampToInt(maxReceive), false)).orElse(0).intValue();
        }
        return 0L;
    }

    public static long receiveEnergy(ItemStack stack, long maxReceive) {
        Item item = stack.m_41720_();
        if (item instanceof IEnergyItem) {
            return ((IEnergyItem)item).receiveEnergyL(stack, maxReceive, false);
        }
        if (McJtyLib.tesla && TeslaCompatibility.isEnergyItem(stack)) {
            return TeslaCompatibility.receiveEnergy(stack, maxReceive, false);
        }
        return stack.getCapability(CapabilityEnergy.ENERGY).map(handler -> handler.receiveEnergy(EnergyTools.unsignedClampToInt(maxReceive), false)).orElse(0).intValue();
    }

    public static int unsignedClampToInt(long l) {
        return l > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)l;
    }

    public static int getIntEnergyStored(long energyStored, long maxEnergyStored) {
        return EnergyTools.unsignedClampToInt(energyStored);
    }

    public static void handleSendingEnergy(Level world, BlockPos pos, long storedPower, long sendPerTick, GenericEnergyStorage storage) {
        for (Direction facing : OrientationTools.DIRECTION_VALUES) {
            Direction opposite;
            BlockPos p = pos.m_142300_(facing);
            BlockEntity te = world.m_7702_(p);
            if (!EnergyTools.isEnergyTE(te, opposite = facing.m_122424_())) continue;
            long rfToGive = Math.min(sendPerTick, storedPower);
            long received = EnergyTools.receiveEnergy(te, opposite, rfToGive);
            storage.consumeEnergy(received);
            if ((storedPower -= received) <= 0L) break;
        }
    }

    public record EnergyLevel(long energy, long maxEnergy) {
    }
}

