/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.varia;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.gui.GuiParser;
import mcjty.lib.varia.Logging;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.Tags;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.registries.ForgeRegistries;

public class ItemStackTools {
    private static Set<ResourceLocation> commonTags = null;

    @Nonnull
    public static ItemStack extractItem(@Nullable BlockEntity tileEntity, int slot, int amount) {
        if (tileEntity == null) {
            return ItemStack.f_41583_;
        }
        return tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).map(handler -> handler.extractItem(slot, amount, false)).orElse(ItemStack.f_41583_);
    }

    @Nonnull
    public static ItemStack getStack(@Nullable BlockEntity tileEntity, int slot) {
        if (tileEntity == null) {
            return ItemStack.f_41583_;
        }
        return tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).map(handler -> handler.getStackInSlot(slot)).orElse(ItemStack.f_41583_);
    }

    public static GuiParser.GuiCommand itemStackToGuiCommand(String name, ItemStack item) {
        GuiParser.GuiCommand object = new GuiParser.GuiCommand(name);
        object.parameter(item.m_41720_().getRegistryName().toString());
        object.parameter(item.m_41613_());
        if (item.m_41782_()) {
            String string = item.m_41783_().toString();
            object.command(new GuiParser.GuiCommand("tag").parameter(string));
        }
        return object;
    }

    public static ItemStack guiCommandToItemStack(GuiParser.GuiCommand obj) {
        String itemName = obj.getOptionalPar(0, "minecraft:stick");
        Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(itemName));
        int amount = obj.getOptionalPar(1, 1);
        ItemStack stack = new ItemStack((ItemLike)item, amount);
        obj.findCommand("tag").ifPresent(cmd -> {
            try {
                CompoundTag nbt = TagParser.m_129359_((String)cmd.getOptionalPar(0, ""));
                stack.m_41751_(nbt);
            }
            catch (CommandSyntaxException e) {
                Logging.logError("Error", e);
            }
        });
        return stack;
    }

    public static void addCommonTags(Collection<ResourceLocation> fromItem, Set<ResourceLocation> tags) {
        ItemStackTools.findCommonTags();
        for (ResourceLocation id : fromItem) {
            if (!commonTags.contains(id)) continue;
            tags.add(id);
        }
    }

    public static boolean hasCommonTag(Collection<ResourceLocation> fromItem) {
        ItemStackTools.findCommonTags();
        for (ResourceLocation id : fromItem) {
            if (!commonTags.contains(id)) continue;
            return true;
        }
        return false;
    }

    private static void findCommonTags() {
        if (commonTags == null) {
            commonTags = new HashSet<ResourceLocation>();
            commonTags.add(BlockTags.f_13029_.m_6979_());
            commonTags.add(BlockTags.f_13039_.m_6979_());
            commonTags.add(BlockTags.f_13104_.m_6979_());
            commonTags.add(BlockTags.f_13035_.m_6979_());
            commonTags.add(BlockTags.f_13106_.m_6979_());
            commonTags.add(BlockTags.f_13034_.m_6979_());
            commonTags.add(BlockTags.f_13031_.m_6979_());
            commonTags.add(BlockTags.f_13089_.m_6979_());
            commonTags.add(BlockTags.f_13094_.m_6979_());
            commonTags.add(BlockTags.f_13073_.m_6979_());
            commonTags.add(BlockTags.f_13090_.m_6979_());
            commonTags.add(BlockTags.f_13030_.m_6979_());
            commonTags.add(BlockTags.f_144274_.m_6979_());
            commonTags.add(Tags.Blocks.GLASS.m_6979_());
            commonTags.add(Tags.Blocks.GLASS_PANES.m_6979_());
            commonTags.add(Tags.Blocks.CHESTS.m_6979_());
            commonTags.add(Tags.Blocks.COBBLESTONE.m_6979_());
            commonTags.add(Tags.Blocks.NETHERRACK.m_6979_());
            commonTags.add(Tags.Blocks.OBSIDIAN.m_6979_());
            commonTags.add(Tags.Blocks.GRAVEL.m_6979_());
            commonTags.add(Tags.Blocks.SANDSTONE.m_6979_());
            commonTags.add(Tags.Blocks.END_STONES.m_6979_());
            commonTags.add(Tags.Blocks.STONE.m_6979_());
            commonTags.add(Tags.Blocks.ORES_COAL.m_6979_());
            commonTags.add(Tags.Blocks.ORES_DIAMOND.m_6979_());
            commonTags.add(Tags.Blocks.ORES_EMERALD.m_6979_());
            commonTags.add(Tags.Blocks.ORES_GOLD.m_6979_());
            commonTags.add(Tags.Blocks.ORES_REDSTONE.m_6979_());
            commonTags.add(Tags.Blocks.ORES_QUARTZ.m_6979_());
            commonTags.add(Tags.Blocks.ORES_IRON.m_6979_());
            commonTags.add(Tags.Blocks.ORES_LAPIS.m_6979_());
            commonTags.add(new ResourceLocation("forge", "ores/copper"));
            commonTags.add(new ResourceLocation("forge", "ores/tin"));
            commonTags.add(new ResourceLocation("forge", "ores/silver"));
            commonTags.add(new ResourceLocation("forge", "ores/manganese"));
            commonTags.add(new ResourceLocation("forge", "ores/platinum"));
            commonTags.add(Tags.Blocks.STORAGE_BLOCKS_COAL.m_6979_());
            commonTags.add(Tags.Blocks.STORAGE_BLOCKS_DIAMOND.m_6979_());
            commonTags.add(Tags.Blocks.STORAGE_BLOCKS_EMERALD.m_6979_());
            commonTags.add(Tags.Blocks.STORAGE_BLOCKS_GOLD.m_6979_());
            commonTags.add(Tags.Blocks.STORAGE_BLOCKS_REDSTONE.m_6979_());
            commonTags.add(Tags.Blocks.STORAGE_BLOCKS_QUARTZ.m_6979_());
            commonTags.add(Tags.Blocks.STORAGE_BLOCKS_IRON.m_6979_());
            commonTags.add(Tags.Blocks.STORAGE_BLOCKS_LAPIS.m_6979_());
            commonTags.add(new ResourceLocation("forge", "storage_blocks/copper"));
            commonTags.add(new ResourceLocation("forge", "storage_blocks/tin"));
            commonTags.add(new ResourceLocation("forge", "storage_blocks/silver"));
            commonTags.add(new ResourceLocation("forge", "storage_blocks/manganese"));
            commonTags.add(new ResourceLocation("forge", "storage_blocks/platinum"));
        }
    }
}

