/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.pipez.blocks;

import de.maxhenkel.pipez.ModItemGroups;
import de.maxhenkel.pipez.blocks.tileentity.PipeTileEntity;
import de.maxhenkel.pipez.blocks.tileentity.UpgradeTileEntity;
import de.maxhenkel.pipez.corelib.block.IItemBlock;
import de.maxhenkel.pipez.corelib.block.VoxelUtils;
import de.maxhenkel.pipez.corelib.blockentity.SimpleBlockEntityTicker;
import de.maxhenkel.pipez.corelib.helpers.Pair;
import de.maxhenkel.pipez.corelib.helpers.Triple;
import de.maxhenkel.pipez.items.UpgradeItem;
import de.maxhenkel.pipez.items.WrenchItem;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.Tag;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.ForgeMod;

public abstract class PipeBlock
extends Block
implements IItemBlock,
SimpleWaterloggedBlock,
EntityBlock {
    public static final BooleanProperty DOWN = BooleanProperty.m_61465_((String)"down");
    public static final BooleanProperty UP = BooleanProperty.m_61465_((String)"up");
    public static final BooleanProperty NORTH = BooleanProperty.m_61465_((String)"north");
    public static final BooleanProperty SOUTH = BooleanProperty.m_61465_((String)"south");
    public static final BooleanProperty WEST = BooleanProperty.m_61465_((String)"west");
    public static final BooleanProperty EAST = BooleanProperty.m_61465_((String)"east");
    public static final BooleanProperty HAS_DATA = BooleanProperty.m_61465_((String)"has_data");
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final VoxelShape SHAPE_NORTH = Block.m_49796_((double)5.0, (double)5.0, (double)0.0, (double)11.0, (double)11.0, (double)5.0);
    public static final VoxelShape SHAPE_SOUTH = Block.m_49796_((double)5.0, (double)5.0, (double)11.0, (double)11.0, (double)11.0, (double)16.0);
    public static final VoxelShape SHAPE_EAST = Block.m_49796_((double)11.0, (double)5.0, (double)5.0, (double)16.0, (double)11.0, (double)11.0);
    public static final VoxelShape SHAPE_WEST = Block.m_49796_((double)0.0, (double)5.0, (double)5.0, (double)5.0, (double)11.0, (double)11.0);
    public static final VoxelShape SHAPE_UP = Block.m_49796_((double)5.0, (double)11.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0);
    public static final VoxelShape SHAPE_DOWN = Block.m_49796_((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)5.0, (double)11.0);
    public static final VoxelShape SHAPE_CORE = Block.m_49796_((double)5.0, (double)5.0, (double)5.0, (double)11.0, (double)11.0, (double)11.0);
    public static final VoxelShape SHAPE_EXTRACT_NORTH = VoxelUtils.combine(SHAPE_NORTH, Block.m_49796_((double)4.0, (double)4.0, (double)0.0, (double)12.0, (double)12.0, (double)1.0));
    public static final VoxelShape SHAPE_EXTRACT_SOUTH = VoxelUtils.combine(SHAPE_SOUTH, Block.m_49796_((double)4.0, (double)4.0, (double)15.0, (double)12.0, (double)12.0, (double)16.0));
    public static final VoxelShape SHAPE_EXTRACT_EAST = VoxelUtils.combine(SHAPE_EAST, Block.m_49796_((double)15.0, (double)4.0, (double)4.0, (double)16.0, (double)12.0, (double)12.0));
    public static final VoxelShape SHAPE_EXTRACT_WEST = VoxelUtils.combine(SHAPE_WEST, Block.m_49796_((double)0.0, (double)4.0, (double)4.0, (double)1.0, (double)12.0, (double)12.0));
    public static final VoxelShape SHAPE_EXTRACT_UP = VoxelUtils.combine(SHAPE_UP, Block.m_49796_((double)4.0, (double)15.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0));
    public static final VoxelShape SHAPE_EXTRACT_DOWN = VoxelUtils.combine(SHAPE_DOWN, Block.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)1.0, (double)12.0));
    private static final List<Triple<VoxelShape, BooleanProperty, Direction>> SHAPES = Arrays.asList(new Triple<VoxelShape, BooleanProperty, Direction>(SHAPE_NORTH, NORTH, Direction.NORTH), new Triple<VoxelShape, BooleanProperty, Direction>(SHAPE_SOUTH, SOUTH, Direction.SOUTH), new Triple<VoxelShape, BooleanProperty, Direction>(SHAPE_WEST, WEST, Direction.WEST), new Triple<VoxelShape, BooleanProperty, Direction>(SHAPE_EAST, EAST, Direction.EAST), new Triple<VoxelShape, BooleanProperty, Direction>(SHAPE_UP, UP, Direction.UP), new Triple<VoxelShape, BooleanProperty, Direction>(SHAPE_DOWN, DOWN, Direction.DOWN));
    private static final List<Pair<VoxelShape, Direction>> EXTRACT_SHAPES = Arrays.asList(new Pair<VoxelShape, Direction>(SHAPE_EXTRACT_NORTH, Direction.NORTH), new Pair<VoxelShape, Direction>(SHAPE_EXTRACT_SOUTH, Direction.SOUTH), new Pair<VoxelShape, Direction>(SHAPE_EXTRACT_WEST, Direction.WEST), new Pair<VoxelShape, Direction>(SHAPE_EXTRACT_EAST, Direction.EAST), new Pair<VoxelShape, Direction>(SHAPE_EXTRACT_UP, Direction.UP), new Pair<VoxelShape, Direction>(SHAPE_EXTRACT_DOWN, Direction.DOWN));

    protected PipeBlock() {
        super(BlockBehaviour.Properties.m_60944_((Material)Material.f_76279_, (MaterialColor)MaterialColor.f_76419_).m_60978_(0.5f).m_60918_(SoundType.f_56743_));
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)UP, (Comparable)Boolean.valueOf(false))).m_61124_((Property)DOWN, (Comparable)Boolean.valueOf(false))).m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)SOUTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)EAST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WEST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)HAS_DATA, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public Item toItem() {
        return (Item)new BlockItem((Block)this, new Item.Properties().m_41491_(ModItemGroups.TAB_PIPEZ)).setRegistryName(this.getRegistryName());
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return new SimpleBlockEntityTicker();
    }

    public PushReaction m_5537_(BlockState state) {
        return PushReaction.BLOCK;
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        Direction side = this.getSelection(state, (BlockGetter)worldIn, pos, player).getKey();
        if (side != null) {
            return this.onPipeSideActivated(state, worldIn, pos, player, handIn, hit, side);
        }
        return super.m_6227_(state, worldIn, pos, player, handIn, hit);
    }

    public InteractionResult onWrenchClicked(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit, Direction side) {
        if (!player.m_6144_()) {
            return InteractionResult.PASS;
        }
        if (side != null) {
            if (worldIn.m_8055_(pos.m_142300_(side)).m_60734_() != this) {
                boolean extracting = this.isExtracting((LevelAccessor)worldIn, pos, side);
                if (extracting) {
                    this.setExtracting(worldIn, pos, side, false);
                    this.setDisconnected(worldIn, pos, side, true);
                } else {
                    this.setExtracting(worldIn, pos, side, true);
                    this.setDisconnected(worldIn, pos, side, false);
                }
            } else {
                this.setDisconnected(worldIn, pos, side, true);
            }
        } else {
            side = hit.m_82434_();
            if (worldIn.m_8055_(pos.m_142300_(side)).m_60734_() != this) {
                this.setExtracting(worldIn, pos, side, false);
                if (this.isAbleToConnect((LevelAccessor)worldIn, pos, side)) {
                    this.setDisconnected(worldIn, pos, side, false);
                }
            } else {
                this.setDisconnected(worldIn, pos, side, false);
                this.setDisconnected(worldIn, pos.m_142300_(side), side.m_122424_(), false);
            }
        }
        PipeTileEntity.markPipesDirty(worldIn, pos);
        return InteractionResult.SUCCESS;
    }

    public InteractionResult onPipeSideActivated(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit, Direction direction) {
        return super.m_6227_(state, worldIn, pos, player, handIn, hit);
    }

    public InteractionResult onPipeSideForceActivated(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit, @Nullable Direction side) {
        ItemStack heldItem = player.m_21120_(hand);
        if (WrenchItem.isWrench(heldItem)) {
            return this.onWrenchClicked(state, world, pos, player, hand, hit, side);
        }
        if (heldItem.m_41720_() instanceof UpgradeItem && player.m_6144_() && side != null) {
            BlockEntity te = world.m_7702_(pos);
            if (!(te instanceof UpgradeTileEntity)) {
                return InteractionResult.PASS;
            }
            UpgradeTileEntity upgradeTe = (UpgradeTileEntity)te;
            ItemStack oldUpgrade = player.m_150110_().f_35937_ ? upgradeTe.setUpgradeItem(side, heldItem.m_41777_().m_41620_(1)) : upgradeTe.setUpgradeItem(side, heldItem.m_41620_(1));
            if (heldItem.m_41619_()) {
                player.m_21008_(hand, oldUpgrade);
            } else if (!player.m_150109_().m_36054_(oldUpgrade)) {
                player.m_36176_(oldUpgrade, true);
            }
            return InteractionResult.m_19078_((boolean)world.f_46443_);
        }
        return InteractionResult.PASS;
    }

    public BooleanProperty getProperty(Direction side) {
        switch (side) {
            case NORTH: {
                return NORTH;
            }
            case SOUTH: {
                return SOUTH;
            }
            case EAST: {
                return EAST;
            }
            case WEST: {
                return WEST;
            }
            case UP: {
                return UP;
            }
        }
        return DOWN;
    }

    public boolean isExtracting(LevelAccessor world, BlockPos pos, Direction side) {
        PipeTileEntity pipe = this.getTileEntity(world, pos);
        if (pipe == null) {
            return false;
        }
        return pipe.isExtracting(side);
    }

    public boolean isDisconnected(LevelAccessor world, BlockPos pos, Direction side) {
        PipeTileEntity pipe = this.getTileEntity(world, pos);
        if (pipe == null) {
            return false;
        }
        return pipe.isDisconnected(side);
    }

    public void setHasData(Level world, BlockPos pos, boolean hasData) {
        BlockState blockState = world.m_8055_(pos);
        world.m_46597_(pos, (BlockState)blockState.m_61124_((Property)HAS_DATA, (Comparable)Boolean.valueOf(hasData)));
        if (!hasData) {
            // empty if block
        }
    }

    public void setExtracting(Level world, BlockPos pos, Direction side, boolean extracting) {
        boolean connected;
        BooleanProperty sideProperty;
        BlockState blockState;
        PipeTileEntity pipe = this.getTileEntity((LevelAccessor)world, pos);
        if (pipe == null) {
            if (extracting) {
                this.setHasData(world, pos, true);
                pipe = this.getTileEntity((LevelAccessor)world, pos);
                if (pipe != null) {
                    pipe.setExtracting(side, extracting);
                }
            }
        } else {
            pipe.setExtracting(side, extracting);
            if (!pipe.hasReasonToStay()) {
                this.setHasData(world, pos, false);
            }
        }
        world.m_46597_(pos, (BlockState)blockState.m_61124_((Property)sideProperty, (Comparable)Boolean.valueOf(!(connected = ((Boolean)(blockState = world.m_8055_(pos)).m_61143_((Property)(sideProperty = this.getProperty(side)))).booleanValue()))));
        world.m_46597_(pos, (BlockState)blockState.m_61124_((Property)sideProperty, (Comparable)Boolean.valueOf(connected)));
    }

    public void setDisconnected(Level world, BlockPos pos, Direction side, boolean disconnected) {
        PipeTileEntity pipe = this.getTileEntity((LevelAccessor)world, pos);
        if (pipe == null) {
            if (disconnected) {
                this.setHasData(world, pos, true);
                pipe = this.getTileEntity((LevelAccessor)world, pos);
                if (pipe != null) {
                    pipe.setDisconnected(side, disconnected);
                    world.m_46597_(pos, (BlockState)world.m_8055_(pos).m_61124_((Property)this.getProperty(side), (Comparable)Boolean.valueOf(false)));
                }
            }
        } else {
            pipe.setDisconnected(side, disconnected);
            if (!pipe.hasReasonToStay()) {
                this.setHasData(world, pos, false);
            }
            world.m_46597_(pos, (BlockState)world.m_8055_(pos).m_61124_((Property)this.getProperty(side), (Comparable)Boolean.valueOf(!disconnected)));
        }
    }

    @Nullable
    public PipeTileEntity getTileEntity(LevelAccessor world, BlockPos pos) {
        BlockEntity te = world.m_7702_(pos);
        if (te instanceof PipeTileEntity) {
            return (PipeTileEntity)te;
        }
        return null;
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return this.getState(context.m_43725_(), context.m_8083_(), null);
    }

    private BlockState getState(Level world, BlockPos pos, @Nullable BlockState oldState) {
        FluidState fluidState = world.m_6425_(pos);
        boolean hasData = false;
        if (oldState != null && oldState.m_60734_() == this) {
            hasData = (Boolean)oldState.m_61143_((Property)HAS_DATA);
        }
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)UP, (Comparable)Boolean.valueOf(this.isConnected((LevelAccessor)world, pos, Direction.UP)))).m_61124_((Property)DOWN, (Comparable)Boolean.valueOf(this.isConnected((LevelAccessor)world, pos, Direction.DOWN)))).m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(this.isConnected((LevelAccessor)world, pos, Direction.NORTH)))).m_61124_((Property)SOUTH, (Comparable)Boolean.valueOf(this.isConnected((LevelAccessor)world, pos, Direction.SOUTH)))).m_61124_((Property)EAST, (Comparable)Boolean.valueOf(this.isConnected((LevelAccessor)world, pos, Direction.EAST)))).m_61124_((Property)WEST, (Comparable)Boolean.valueOf(this.isConnected((LevelAccessor)world, pos, Direction.WEST)))).m_61124_((Property)HAS_DATA, (Comparable)Boolean.valueOf(hasData))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.m_76153_((Tag)FluidTags.f_13131_) && fluidState.m_76186_() == 8));
    }

    public boolean isConnected(LevelAccessor world, BlockPos pos, Direction facing) {
        boolean canSelfConnect;
        PipeTileEntity pipe = this.getTileEntity(world, pos);
        PipeTileEntity other = this.getTileEntity(world, pos.m_142300_(facing));
        if (!this.isAbleToConnect(world, pos, facing)) {
            return false;
        }
        boolean bl = canSelfConnect = pipe == null || !pipe.isDisconnected(facing);
        if (!canSelfConnect) {
            return false;
        }
        boolean canSideConnect = other == null || !other.isDisconnected(facing.m_122424_());
        return canSideConnect;
    }

    public boolean isAbleToConnect(LevelAccessor world, BlockPos pos, Direction facing) {
        return this.isPipe(world, pos, facing) || this.canConnectTo(world, pos, facing);
    }

    public abstract boolean canConnectTo(LevelAccessor var1, BlockPos var2, Direction var3);

    public abstract boolean isPipe(LevelAccessor var1, BlockPos var2, Direction var3);

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            worldIn.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)worldIn));
        }
        return super.m_7417_(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public void m_6861_(BlockState state, Level world, BlockPos pos, Block block, BlockPos pos1, boolean b) {
        super.m_6861_(state, world, pos, block, pos1, b);
        BlockState newState = this.getState(world, pos, state);
        if (!state.m_61147_().stream().allMatch(property -> state.m_61143_(property).equals(newState.m_61143_(property)))) {
            world.m_46597_(pos, newState);
            PipeTileEntity.markPipesDirty(world, pos);
        }
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{UP, DOWN, NORTH, SOUTH, EAST, WEST, HAS_DATA, WATERLOGGED});
    }

    public VoxelShape getShape(BlockGetter blockReader, BlockPos pos, BlockState state, boolean advanced) {
        PipeTileEntity pipe = null;
        if (advanced && blockReader instanceof LevelAccessor) {
            pipe = this.getTileEntity((LevelAccessor)blockReader, pos);
        }
        VoxelShape shape = SHAPE_CORE;
        if (((Boolean)state.m_61143_((Property)UP)).booleanValue()) {
            shape = pipe != null && pipe.isExtracting(Direction.UP) ? VoxelUtils.combine(shape, SHAPE_EXTRACT_UP) : VoxelUtils.combine(shape, SHAPE_UP);
        }
        if (((Boolean)state.m_61143_((Property)DOWN)).booleanValue()) {
            shape = pipe != null && pipe.isExtracting(Direction.DOWN) ? VoxelUtils.combine(shape, SHAPE_EXTRACT_DOWN) : VoxelUtils.combine(shape, SHAPE_DOWN);
        }
        if (((Boolean)state.m_61143_((Property)SOUTH)).booleanValue()) {
            shape = pipe != null && pipe.isExtracting(Direction.SOUTH) ? VoxelUtils.combine(shape, SHAPE_EXTRACT_SOUTH) : VoxelUtils.combine(shape, SHAPE_SOUTH);
        }
        if (((Boolean)state.m_61143_((Property)NORTH)).booleanValue()) {
            shape = pipe != null && pipe.isExtracting(Direction.NORTH) ? VoxelUtils.combine(shape, SHAPE_EXTRACT_NORTH) : VoxelUtils.combine(shape, SHAPE_NORTH);
        }
        if (((Boolean)state.m_61143_((Property)EAST)).booleanValue()) {
            shape = pipe != null && pipe.isExtracting(Direction.EAST) ? VoxelUtils.combine(shape, SHAPE_EXTRACT_EAST) : VoxelUtils.combine(shape, SHAPE_EAST);
        }
        if (((Boolean)state.m_61143_((Property)WEST)).booleanValue()) {
            shape = pipe != null && pipe.isExtracting(Direction.WEST) ? VoxelUtils.combine(shape, SHAPE_EXTRACT_WEST) : VoxelUtils.combine(shape, SHAPE_WEST);
        }
        return shape;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        EntityCollisionContext ctx;
        Entity entity;
        if (context instanceof EntityCollisionContext && (entity = (ctx = (EntityCollisionContext)context).m_193113_()) instanceof Player) {
            Player player = (Player)entity;
            if (player.f_19853_.f_46443_) {
                return this.getSelectionShape(state, worldIn, pos, player);
            }
        }
        return this.getShape(worldIn, pos, state, true);
    }

    public VoxelShape getSelectionShape(BlockState state, BlockGetter world, BlockPos pos, Player player) {
        Pair<Direction, VoxelShape> selection = this.getSelection(state, world, pos, player);
        if (selection.getKey() == null) {
            return this.getShape(world, pos, state, true);
        }
        if (world.m_8055_(pos.m_142300_(selection.getKey())).m_60734_() == this && !WrenchItem.isHoldingWrench(player)) {
            return this.getShape(world, pos, state, true);
        }
        return selection.getValue();
    }

    public Pair<Direction, VoxelShape> getSelection(BlockState state, BlockGetter blockReader, BlockPos pos, Player player) {
        Vec3 start = player.m_20299_(1.0f);
        Vec3 end = start.m_82549_(player.m_20154_().m_82541_().m_82490_((double)this.getBlockReachDistance(player)));
        Direction direction = null;
        VoxelShape selection = null;
        double shortest = Double.MAX_VALUE;
        double d = this.checkShape(state, blockReader, pos, start, end, SHAPE_CORE, null);
        if (d < shortest) {
            shortest = d;
        }
        if (!(blockReader instanceof LevelAccessor)) {
            return new Pair<Object, Object>(direction, selection);
        }
        PipeTileEntity pipe = this.getTileEntity((LevelAccessor)blockReader, pos);
        for (int i = 0; i < Direction.values().length; ++i) {
            Pair<VoxelShape, Direction> extract = EXTRACT_SHAPES.get(i);
            Triple<VoxelShape, BooleanProperty, Direction> shape = SHAPES.get(i);
            if (pipe != null && pipe.isExtracting(extract.getValue())) {
                d = this.checkShape(state, blockReader, pos, start, end, extract.getKey(), pipe, extract.getValue());
                if (!(d < shortest)) continue;
                shortest = d;
                direction = extract.getValue();
                selection = extract.getKey();
                continue;
            }
            d = this.checkShape(state, blockReader, pos, start, end, shape.getValue1(), shape.getValue2());
            if (!(d < shortest)) continue;
            shortest = d;
            direction = shape.getValue3();
            selection = shape.getValue1();
        }
        return new Pair<Object, Object>(direction, selection);
    }

    public float getBlockReachDistance(Player player) {
        float distance = (float)player.m_21051_((Attribute)ForgeMod.REACH_DISTANCE.get()).m_22135_();
        return player.m_7500_() ? distance : distance - 0.5f;
    }

    private double checkShape(BlockState state, BlockGetter world, BlockPos pos, Vec3 start, Vec3 end, VoxelShape shape, BooleanProperty direction) {
        if (direction != null && !((Boolean)state.m_61143_((Property)direction)).booleanValue()) {
            return Double.MAX_VALUE;
        }
        BlockHitResult blockRayTraceResult = world.m_45558_(start, end, pos, shape, state);
        if (blockRayTraceResult == null) {
            return Double.MAX_VALUE;
        }
        return blockRayTraceResult.m_82450_().m_82554_(start);
    }

    private double checkShape(BlockState state, BlockGetter world, BlockPos pos, Vec3 start, Vec3 end, VoxelShape shape, @Nullable PipeTileEntity pipe, Direction side) {
        if (pipe != null && !pipe.isExtracting(side)) {
            return Double.MAX_VALUE;
        }
        BlockHitResult blockRayTraceResult = world.m_45558_(start, end, pos, shape, state);
        if (blockRayTraceResult == null) {
            return Double.MAX_VALUE;
        }
        return blockRayTraceResult.m_82450_().m_82554_(start);
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.m_60713_(newState.m_60734_())) {
            if (!((Boolean)newState.m_61143_((Property)HAS_DATA)).booleanValue()) {
                level.m_46747_(pos);
            }
        } else {
            BlockEntity blockentity = level.m_7702_(pos);
            if (blockentity instanceof UpgradeTileEntity) {
                UpgradeTileEntity upgrade = (UpgradeTileEntity)blockentity;
                Containers.m_19002_((Level)level, (BlockPos)pos, (Container)upgrade.getUpgradeInventory());
            }
            super.m_6810_(state, level, pos, newState, isMoving);
        }
    }

    public VoxelShape m_7952_(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return this.getShape(worldIn, pos, state, false);
    }

    public VoxelShape m_5909_(BlockState state, BlockGetter reader, BlockPos pos, CollisionContext context) {
        return this.getShape(reader, pos, state, false);
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return this.getShape(worldIn, pos, state, false);
    }

    public VoxelShape m_7947_(BlockState state, BlockGetter reader, BlockPos pos) {
        return this.getShape(reader, pos, state, false);
    }

    public VoxelShape m_6079_(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return this.getShape(worldIn, pos, state, false);
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        if (((Boolean)state.m_61143_((Property)HAS_DATA)).booleanValue()) {
            return this.createTileEntity(pos, state);
        }
        return null;
    }

    abstract BlockEntity createTileEntity(BlockPos var1, BlockState var2);
}

