/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.pipez.recipes;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import de.maxhenkel.pipez.corelib.helpers.Pair;
import de.maxhenkel.pipez.recipes.ModRecipes;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class CopyNbtRecipe
extends CustomRecipe {
    private Ingredient ingredient;

    public CopyNbtRecipe(ResourceLocation recipeID, Ingredient ingredient) {
        super(recipeID);
        this.ingredient = ingredient;
    }

    public Pair<ItemStack, List<ItemStack>> getResult(CraftingContainer inv) {
        ItemStack source = null;
        ArrayList<ItemStack> toCopy = new ArrayList<ItemStack>();
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack stack = inv.m_8020_(i);
            if (stack.m_41619_()) continue;
            if (this.ingredient.test(stack)) {
                if (source == null && stack.m_41782_()) {
                    source = stack;
                    continue;
                }
                toCopy.add(stack);
                continue;
            }
            return new Pair(null, new ArrayList());
        }
        return new Pair(source, toCopy);
    }

    public boolean matches(CraftingContainer inv, Level worldIn) {
        Pair<ItemStack, List<ItemStack>> result = this.getResult(inv);
        if (result.getKey() == null) {
            return false;
        }
        if (result.getValue().stream().allMatch(stack -> stack.m_41720_().equals(((ItemStack)result.getKey()).m_41720_()))) {
            return result.getKey() != null && result.getValue().size() > 0;
        }
        return result.getValue().size() == 1;
    }

    public ItemStack assemble(CraftingContainer inv) {
        Pair<ItemStack, List<ItemStack>> result = this.getResult(inv);
        if (result.getKey() == null) {
            return ItemStack.f_41583_;
        }
        if (result.getValue().stream().allMatch(stack -> stack.m_41720_().equals(((ItemStack)result.getKey()).m_41720_()))) {
            ItemStack res = result.getKey().m_41777_();
            res.m_41764_(1 + result.getValue().size());
            return res;
        }
        if (result.getValue().size() == 1) {
            ItemStack stack2 = result.getValue().get(0).m_41777_();
            stack2.m_41764_(1);
            stack2.m_41751_(result.getKey().m_41783_().m_6426_());
            return stack2;
        }
        return ItemStack.f_41583_;
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingContainer inv) {
        Pair<ItemStack, List<ItemStack>> result = this.getResult(inv);
        if (result.getKey() == null) {
            return super.m_7457_((Container)inv);
        }
        if (result.getValue().stream().allMatch(stack -> stack.m_41720_().equals(((ItemStack)result.getKey()).m_41720_()))) {
            return super.m_7457_((Container)inv);
        }
        if (result.getValue().size() == 1) {
            NonNullList res = super.m_7457_((Container)inv);
            for (int i = 0; i < inv.m_6643_(); ++i) {
                if (!inv.m_8020_(i).equals(result.getKey())) continue;
                ItemStack r = result.getKey().m_41777_();
                r.m_41764_(1);
                res.set(i, (Object)r);
                break;
            }
            return res;
        }
        return super.m_7457_((Container)inv);
    }

    public RecipeSerializer<?> m_7707_() {
        return ModRecipes.COPY_NBT;
    }

    public boolean m_8004_(int width, int height) {
        return width >= 2 && height >= 2;
    }

    public ItemStack m_8043_() {
        return ItemStack.f_41583_;
    }

    public static class Serializer
    extends ForgeRegistryEntry<RecipeSerializer<?>>
    implements RecipeSerializer<CopyNbtRecipe> {
        public static final ResourceLocation NAME = new ResourceLocation("pipez", "copy_nbt");

        public CopyNbtRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            return new CopyNbtRecipe(recipeId, Ingredient.m_43917_((JsonElement)json.get("item")));
        }

        public CopyNbtRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            return new CopyNbtRecipe(recipeId, Ingredient.m_43940_((FriendlyByteBuf)buffer));
        }

        public void toNetwork(FriendlyByteBuf buffer, CopyNbtRecipe recipe) {
            recipe.ingredient.m_43923_(buffer);
        }
    }
}

