/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.woodcutter.command;

import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackRepository;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.SerializationTags;
import net.minecraft.tags.Tag;
import net.minecraft.util.Mth;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraftforge.common.Tags;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistryEntry;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.jline.utils.Levenshtein;
import ovh.corail.woodcutter.command.WoodcuttingJsonRecipe;
import ovh.corail.woodcutter.compatibility.SupportMods;
import ovh.corail.woodcutter.helper.LangKey;

@Mod.EventBusSubscriber(modid="corail_woodcutter", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class CommandWoodcutter {
    private final Set<Item> logs = new HashSet<Item>();
    private final Map<Item, WoodCompo> plankToLog = new HashMap<Item, WoodCompo>();
    private static final String MODID_PARAM = "modid";
    private static final int PACK_FORMAT = 8;
    private static final Predicate<ItemStack> VANILLA_ITEM = stack -> Optional.ofNullable(stack.m_41720_().getRegistryName()).map(ResourceLocation::m_135827_).map("minecraft"::equals).orElse(false);
    private static final Predicate<ItemStack> VALID_RESULT = result -> !result.m_41619_() && !VANILLA_ITEM.test((ItemStack)result);
    private static final Predicate<ItemStack> NON_VANILLA_PLANKS = stack -> VALID_RESULT.test((ItemStack)stack) && (stack.m_150922_((Tag)ItemTags.f_13168_) || Optional.ofNullable(stack.m_41720_().getRegistryName()).map(ResourceLocation::m_135815_).map(e -> e.endsWith("_planks")).orElse(false) != false);
    private static final Predicate<String> INVALID_MODID = modid -> modid == null || "minecraft".equals(modid) || !ModList.get().isLoaded(modid) || SupportMods.hasSupport(modid);
    private static final BiPredicate<String, String> ALMOSTLY_SIMILAR_PATH = (s1, s2) -> Levenshtein.distance((CharSequence)s1, (CharSequence)s2, (int)1, (int)0, (int)1, (int)10) <= 3;
    private static final BiFunction<MinecraftServer, String, File> DATAPACK_FOLDER = (server, folder) -> new File(server.m_129843_(LevelResource.f_78180_).toFile(), (String)folder);
    private static final Function<String, File> CONFIG_FOLDER = folder -> new File(FMLPaths.CONFIGDIR.get().toFile(), "corail_woodcutter" + File.separatorChar + folder);
    private static final SuggestionProvider<CommandSourceStack> SUGGESTION_MODID = (ctx, build) -> SharedSuggestionProvider.m_82981_(ModList.get().applyForEachModContainer(ModContainer::getModId).filter(SupportMods::noSupport).filter(modid -> !"minecraft".equals(modid)), (SuggestionsBuilder)build);
    private static final Gson GSON = new GsonBuilder().disableHtmlEscaping().setPrettyPrinting().create();

    private CommandWoodcutter() {
    }

    private int showUsage(CommandContext<CommandSourceStack> context) {
        ((CommandSourceStack)context.getSource()).m_81354_(LangKey.COMMAND_USAGE.getText(new Object[0]), false);
        return 1;
    }

    private int applyDataPack(CommandContext<CommandSourceStack> context) {
        String modid = StringArgumentType.getString(context, (String)MODID_PARAM);
        if (INVALID_MODID.test(modid)) {
            throw LangKey.INVALID_MODID.asCommandException(new Object[0]);
        }
        String zipName = this.getZipName(modid);
        File configDatapackZip = CONFIG_FOLDER.apply(zipName);
        if (!configDatapackZip.exists()) {
            throw LangKey.DATAPACK_NOT_GENERATED.asCommandException(modid);
        }
        File destination = DATAPACK_FOLDER.apply(((CommandSourceStack)context.getSource()).m_81377_(), zipName);
        if (destination.exists()) {
            this.disableDataPack((CommandSourceStack)context.getSource(), modid);
            if (!destination.delete()) {
                throw LangKey.DATAPACK_APPLY_FAIL.asCommandException(LangKey.FILE_DELETE_FAIL.getText(destination.getAbsolutePath()));
            }
        }
        try {
            FileUtils.copyFile((File)configDatapackZip, (File)destination);
            this.discoverNewDataPack(((CommandSourceStack)context.getSource()).m_81377_());
            ((CommandSourceStack)context.getSource()).m_81354_(LangKey.DATAPACK_APPLY_SUCCESS.getText(new Object[0]), false);
            return 1;
        }
        catch (IOException e) {
            e.printStackTrace();
            throw LangKey.DATAPACK_APPLY_FAIL.asCommandException(LangKey.FILE_COPY_FAIL.getText(destination.getAbsolutePath()));
        }
    }

    private int removeDataPack(CommandContext<CommandSourceStack> context) {
        String modid = StringArgumentType.getString(context, (String)MODID_PARAM);
        if (INVALID_MODID.test(modid)) {
            throw LangKey.INVALID_MODID.asCommandException(new Object[0]);
        }
        File destination = DATAPACK_FOLDER.apply(((CommandSourceStack)context.getSource()).m_81377_(), this.getZipName(modid));
        if (!destination.exists()) {
            throw LangKey.DATAPACK_REMOVE_ABSENT.asCommandException(new Object[0]);
        }
        this.disableDataPack((CommandSourceStack)context.getSource(), modid);
        if (!destination.delete()) {
            throw LangKey.DATAPACK_REMOVE_FAIL.asCommandException(LangKey.FILE_DELETE_FAIL.getText(destination.getAbsolutePath()));
        }
        ((CommandSourceStack)context.getSource()).m_81354_(LangKey.DATAPACK_REMOVE_SUCCESS.getText(new Object[0]), false);
        return 1;
    }

    private int generateDataPack(CommandContext<CommandSourceStack> context) {
        String modid = StringArgumentType.getString(context, (String)MODID_PARAM);
        if (INVALID_MODID.test(modid)) {
            throw LangKey.INVALID_MODID.asCommandException(new Object[0]);
        }
        HashMap<String, WoodcuttingJsonRecipe> recipes = new HashMap<String, WoodcuttingJsonRecipe>();
        this.initPlanksToLogs(((CommandSourceStack)context.getSource()).m_81377_());
        Map entries = ((CommandSourceStack)context.getSource()).m_81377_().m_129894_().m_44054_(RecipeType.f_44107_).entrySet().stream().filter(entry -> modid.equals(((ResourceLocation)entry.getKey()).m_135827_())).map(Map.Entry::getValue).filter(r -> VALID_RESULT.test(r.m_8043_())).collect(Collectors.toMap(Function.identity(), this::getWeight));
        for (Map.Entry entry2 : entries.entrySet()) {
            int count;
            WoodCompo compo;
            ItemStack stack;
            double weight = entry2.getValue();
            if (weight == 0.0) continue;
            ItemStack result = ((Recipe)entry2.getKey()).m_8043_();
            NonNullList ingredients = ((Recipe)entry2.getKey()).m_7527_();
            ResourceLocation outputName = result.m_41720_().getRegistryName();
            assert (outputName != null);
            if (ingredients.size() == 1 && this.logs.contains((stack = ((Ingredient)ingredients.get(0)).m_43908_()[0]).m_41720_()) && (compo = this.plankToLog.get(result.m_41720_())) != null) {
                this.addLogRecipe(recipes, compo, outputName, result.m_41613_() / stack.m_41613_());
                continue;
            }
            WoodCompo compo2 = this.getWoodCompo((NonNullList<Ingredient>)ingredients);
            if (compo2 == null) continue;
            int n = count = weight < 1.0 ? Mth.m_14107_((double)(1.0 / weight)) : 1;
            if (weight < 3.1) {
                this.addPlankRecipe(recipes, compo2, outputName, count);
                this.addLogRecipe(recipes, compo2, outputName, count * 4);
                continue;
            }
            this.addLogRecipe(recipes, compo2, outputName, count);
        }
        if (recipes.isEmpty()) {
            throw LangKey.NO_VALID_RECIPE_FOR_MODID.asCommandException(modid);
        }
        File datapackFolder = CONFIG_FOLDER.apply("corail_woodcutter_" + modid);
        File dataFolder = new File(datapackFolder, "data");
        File recipeFolder = new File(dataFolder, "corail_woodcutter_" + modid + File.separatorChar + "recipes");
        if (recipeFolder.exists()) {
            try {
                FileUtils.cleanDirectory((File)recipeFolder);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (!recipeFolder.exists() && !recipeFolder.mkdirs()) {
            throw LangKey.DATAPACK_GENERATE_FAIL.asCommandException(LangKey.FOLDER_CREATE_FAIL.getText(recipeFolder.getAbsolutePath()));
        }
        for (Map.Entry entry3 : recipes.entrySet()) {
            File file = new File(recipeFolder, (String)entry3.getKey() + ".json");
            if (file.exists() && !file.delete()) {
                throw LangKey.DATAPACK_GENERATE_FAIL.asCommandException(LangKey.FILE_DELETE_FAIL.getText(file.getAbsolutePath()));
            }
            if (this.toFile(file, ((WoodcuttingJsonRecipe)entry3.getValue()).withConditions(new WoodcuttingJsonRecipe.ConditionMod(modid), new WoodcuttingJsonRecipe.ConditionMod("corail_woodcutter"), new WoodcuttingJsonRecipe.ConditionItem(((WoodcuttingJsonRecipe)entry3.getValue()).result)))) continue;
            throw LangKey.DATAPACK_GENERATE_FAIL.asCommandException(LangKey.FILE_WRITE_FAIL.getText(file.getAbsolutePath()));
        }
        if (!this.addMcMeta(datapackFolder, modid)) {
            throw LangKey.MCMETA_CREATE_FAIL.asCommandException(new Object[0]);
        }
        try {
            this.toZip(datapackFolder.toPath(), modid);
            ((CommandSourceStack)context.getSource()).m_81354_(LangKey.DATAPACK_GENERATE_SUCCESS.getText(recipes.size()), false);
            return 1;
        }
        catch (IOException e) {
            e.printStackTrace();
            throw LangKey.ZIP_CREATE_FAIL.asCommandException(new Object[0]);
        }
    }

    @Nullable
    private WoodCompo getWoodCompo(NonNullList<Ingredient> ingredients) {
        HashSet<Item> planks = new HashSet<Item>();
        int vanillaPlanks = 0;
        for (Ingredient ingredient : ingredients) {
            if (ingredient.m_43947_()) continue;
            for (ItemStack stack : ingredient.m_43908_()) {
                if (!this.plankToLog.containsKey(stack.m_41720_()) || !planks.add(stack.m_41720_()) || !VANILLA_ITEM.test(stack) || ++vanillaPlanks <= 1) continue;
                return WoodCompo.ANY_WOOD;
            }
        }
        return planks.size() == 0 ? WoodCompo.ANY_WOOD : (planks.size() == 1 ? this.plankToLog.get(planks.iterator().next()) : ingredients.stream().filter(ing -> !ing.m_43947_()).filter(ing -> this.plankToLog.containsKey(ing.m_43908_()[0].m_41720_())).findFirst().map(this::getTagForIngredient).filter(Optional::isPresent).map(tag -> new WoodCompo((ResourceLocation)tag.get(), true, null, false)).orElse(this.plankToLog.get(planks.iterator().next())));
    }

    private void initPlanksToLogs(MinecraftServer server) {
        if (!this.plankToLog.isEmpty()) {
            return;
        }
        ForgeRegistries.ITEMS.getEntries().stream().filter(entry -> ItemTags.f_13182_.m_8110_((Object)((Item)entry.getValue())) || ((ResourceKey)entry.getKey()).getRegistryName().m_135815_().endsWith("_log") || ((ResourceKey)entry.getKey()).getRegistryName().m_135815_().endsWith("_stem")).map(Map.Entry::getValue).forEach(this.logs::add);
        server.m_129894_().m_44054_(RecipeType.f_44107_).entrySet().stream().filter(entry -> !"minecraft".equals(((ResourceLocation)entry.getKey()).m_135827_())).map(Map.Entry::getValue).filter(r -> r.m_7527_().size() == 1).filter(ShapelessRecipe.class::isInstance).filter(r -> NON_VANILLA_PLANKS.test(r.m_8043_())).filter(r -> this.isNonVanillaLogIngredient((Ingredient)r.m_7527_().get(0))).forEach(logRecipe -> this.plankToLog.computeIfAbsent(logRecipe.m_8043_().m_41720_(), plank -> {
            ResourceLocation plankName = plank.getRegistryName();
            assert (plankName != null);
            Ingredient ingredient = (Ingredient)logRecipe.m_7527_().get(0);
            Optional<ResourceLocation> tagName = this.getTagForIngredient(ingredient);
            if (tagName.isPresent()) {
                return new WoodCompo(plankName, false, tagName.get(), true);
            }
            ItemStack[] stacks = ingredient.m_43908_();
            Set<ResourceLocation> commonTags = this.getCommonTags(stacks, plankName.m_135827_());
            if (stacks.length == 1) {
                ResourceLocation logName2 = stacks[0].m_41720_().getRegistryName();
                assert (logName2 != null);
                String logPath = logName2.m_135815_().replace("stripped_", "");
                return commonTags.stream().filter(rl -> ALMOSTLY_SIMILAR_PATH.test(logPath, rl.m_135815_())).findFirst().map(rl -> new WoodCompo(plankName, false, (ResourceLocation)rl, true)).orElse(new WoodCompo(plankName, false, logName2, false));
            }
            Set logNames = Arrays.stream(stacks).map(ItemStack::m_41720_).map(ForgeRegistryEntry::getRegistryName).collect(Collectors.toSet());
            for (ResourceLocation tagRL : commonTags) {
                if (!logNames.stream().anyMatch(logName -> ALMOSTLY_SIMILAR_PATH.test(logName.m_135815_().replace("stripped_", ""), tagRL.m_135815_()))) continue;
                return new WoodCompo(plankName, false, tagRL, true);
            }
            return new WoodCompo(plankName, false, logNames.stream().min(Comparator.comparingInt(rl -> Levenshtein.distance((CharSequence)rl.m_135815_(), (CharSequence)plankName.m_135815_()))).orElse(null), false);
        }));
        this.plankToLog.put(Items.f_42795_, new WoodCompo(Objects.requireNonNull(Items.f_42795_.getRegistryName()), false, ItemTags.f_13186_.m_6979_(), true));
        this.plankToLog.put(Items.f_42753_, new WoodCompo(Objects.requireNonNull(Items.f_42753_.getRegistryName()), false, ItemTags.f_13185_.m_6979_(), true));
        this.plankToLog.put(Items.f_42796_, new WoodCompo(Objects.requireNonNull(Items.f_42796_.getRegistryName()), false, ItemTags.f_13183_.m_6979_(), true));
        this.plankToLog.put(Items.f_42794_, new WoodCompo(Objects.requireNonNull(Items.f_42794_.getRegistryName()), false, ItemTags.f_13187_.m_6979_(), true));
        this.plankToLog.put(Items.f_42647_, new WoodCompo(Objects.requireNonNull(Items.f_42647_.getRegistryName()), false, ItemTags.f_13184_.m_6979_(), true));
        this.plankToLog.put(Items.f_42700_, new WoodCompo(Objects.requireNonNull(Items.f_42700_.getRegistryName()), false, ItemTags.f_13188_.m_6979_(), true));
        this.plankToLog.put(Items.f_42797_, new WoodCompo(Objects.requireNonNull(Items.f_42797_.getRegistryName()), false, ItemTags.f_13189_.m_6979_(), true));
        this.plankToLog.put(Items.f_42798_, new WoodCompo(Objects.requireNonNull(Items.f_42798_.getRegistryName()), false, ItemTags.f_13190_.m_6979_(), true));
        ItemTags.f_13168_.m_6497_().forEach(key -> this.plankToLog.computeIfAbsent((Item)key, item -> new WoodCompo(Objects.requireNonNull(item.getRegistryName()), false, null, false)));
    }

    private Set<ResourceLocation> getCommonTags(ItemStack[] stacks, String namespace) {
        if (stacks.length == 0) {
            return Collections.emptySet();
        }
        HashSet<ResourceLocation> commonTags = new HashSet<ResourceLocation>(stacks[0].m_41720_().getTags());
        commonTags.removeIf(rl -> !namespace.equals(rl.m_135827_()));
        if (stacks.length > 1) {
            IntStream.range(1, stacks.length).forEach(i -> commonTags.retainAll(stacks[i].m_41720_().getTags()));
        }
        return commonTags;
    }

    private Optional<ResourceLocation> getTagForIngredient(Ingredient ingredient) {
        return Arrays.stream(ingredient.f_43902_).filter(v -> v instanceof Ingredient.TagValue).findFirst().map(tagValue -> ((Ingredient.TagValue)tagValue).f_43959_).map(tag -> SerializationTags.m_13199_().m_144452_(Registry.f_122904_).m_7473_(tag));
    }

    private boolean isNonVanillaLogIngredient(Ingredient ingredient) {
        return !ingredient.m_43947_() && VALID_RESULT.test(ingredient.m_43908_()[0]) && this.logs.contains(ingredient.m_43908_()[0].m_41720_()) && Arrays.stream(ingredient.m_43908_()).noneMatch(VANILLA_ITEM);
    }

    private String getZipName(String modid) {
        return "corail_woodcutter_" + modid + ".zip";
    }

    private void toZip(Path source, String modid) throws IOException {
        try (final ZipOutputStream outputStream = new ZipOutputStream(new BufferedOutputStream(Files.newOutputStream(CONFIG_FOLDER.apply(this.getZipName(modid)).toPath(), new OpenOption[0])));){
            Files.walkFileTree(source, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFileFailed(Path file, IOException exc) {
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFile(Path visitedPath, BasicFileAttributes attributes) {
                    if (!visitedPath.toFile().isDirectory()) {
                        String stringPath = visitedPath.toString();
                        ZipEntry zipentry = new ZipEntry(stringPath.endsWith("pack.mcmeta") ? "pack.mcmeta" : stringPath.substring(stringPath.indexOf("data")).replace('\\', '/'));
                        try {
                            outputStream.putNextEntry(zipentry);
                            com.google.common.io.Files.asByteSource((File)visitedPath.toFile()).copyTo((OutputStream)outputStream);
                            outputStream.closeEntry();
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
    }

    private void disableDataPack(CommandSourceStack source, String modid) {
        PackRepository packs = source.m_81377_().m_129891_();
        Pack pack = packs.m_10507_("file/" + this.getZipName(modid));
        if (pack != null && packs.m_10524_().contains(pack)) {
            ArrayList selectedPacks = Lists.newArrayList((Iterable)packs.m_10524_());
            selectedPacks.remove(pack);
            source.m_81377_().m_129861_(selectedPacks.stream().map(Pack::m_10446_).toList());
        }
    }

    private void discoverNewDataPack(MinecraftServer server) {
        PackRepository packs = server.m_129891_();
        ArrayList selectedPackIds = Lists.newArrayList((Iterable)packs.m_10523_());
        packs.m_10506_();
        List disabledPackIds = server.m_129910_().m_7513_().m_45855_();
        for (String packId : packs.m_10514_()) {
            if (disabledPackIds.contains(packId) || selectedPackIds.contains(packId)) continue;
            selectedPackIds.add(packId);
        }
        server.m_129861_((Collection)selectedPackIds);
    }

    private <T> boolean toFile(File file, T object) {
        boolean bl;
        FileWriter fw = new FileWriter(file, StandardCharsets.UTF_8);
        try {
            fw.write(GSON.toJson(object));
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                try {
                    fw.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                e.printStackTrace();
                return false;
            }
        }
        fw.close();
        return bl;
    }

    private boolean addMcMeta(File datapackFolder, String modid) {
        File file = new File(datapackFolder, "pack.mcmeta");
        if (file.exists()) {
            return true;
        }
        JsonObject json = new JsonObject();
        JsonObject pack = new JsonObject();
        json.add("pack", (JsonElement)pack);
        pack.addProperty("description", "Corail Woodcutter " + StringUtils.capitalize((String)modid) + " Resources");
        pack.addProperty("pack_format", (Number)8);
        return this.toFile(file, json);
    }

    private void addRecipe(Map<String, WoodcuttingJsonRecipe> recipes, ResourceLocation input, ResourceLocation output, int count, boolean isTag) {
        recipes.put(output.m_135815_() + "_from_" + input.m_135815_(), new WoodcuttingJsonRecipe(input.toString(), output.toString(), count, isTag));
    }

    private void addPlankRecipe(Map<String, WoodcuttingJsonRecipe> recipes, WoodCompo compo, ResourceLocation output, int count) {
        this.addRecipe(recipes, compo.plankName(), output, count, compo.isPlankTag());
    }

    private void addLogRecipe(Map<String, WoodcuttingJsonRecipe> recipes, WoodCompo compo, ResourceLocation output, int count) {
        Optional.ofNullable(compo.logName()).ifPresent(logName -> this.addRecipe(recipes, (ResourceLocation)logName, output, count, compo.isLogTag()));
    }

    private double getWeight(Recipe<CraftingContainer> recipe) {
        NonNullList ingredients = recipe.m_7527_();
        double weight = 0.0;
        double maxWeight = 5.0 * (double)recipe.m_8043_().m_41613_();
        for (Ingredient ingredient : ingredients) {
            Predicate<Item> predicate;
            if (ingredient.m_43947_()) continue;
            ItemStack[] stacks = ingredient.m_43908_();
            ItemStack stack = stacks[0];
            if (this.logs.contains(stack.m_41720_())) {
                predicate = this.logs::contains;
                weight += 4.0 * (double)stack.m_41613_();
            } else if (this.plankToLog.containsKey(stack.m_41720_())) {
                predicate = this.plankToLog::containsKey;
                weight += 1.0 * (double)stack.m_41613_();
            } else if (stack.m_150922_((Tag)Tags.Items.RODS_WOODEN)) {
                predicate = arg_0 -> ((Tags.IOptionalNamedTag)Tags.Items.RODS_WOODEN).m_8110_(arg_0);
                weight += 0.5 * (double)stack.m_41613_();
            } else if (stack.m_150922_((Tag)ItemTags.f_13175_)) {
                predicate = arg_0 -> ((Tag.Named)ItemTags.f_13175_).m_8110_(arg_0);
                weight += 0.5 * (double)stack.m_41613_();
            } else {
                return 0.0;
            }
            if (!(weight > maxWeight) && !Arrays.stream(stacks).anyMatch(s -> !predicate.test(s.m_41720_()))) continue;
            return 0.0;
        }
        return weight / (double)recipe.m_8043_().m_41613_();
    }

    private void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        LiteralCommandNode command = dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"woodcutter").requires(this::hasPermission)).executes(this::showUsage)).then(BaseAction.INFO.literal().executes(this::showUsage))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)BaseAction.DATAPACK.literal().executes(this::showUsage)).then(((LiteralArgumentBuilder)DataPackAction.GENERATE.literal().executes(this::showUsage)).then(Commands.m_82129_((String)MODID_PARAM, (ArgumentType)StringArgumentType.word()).suggests(SUGGESTION_MODID).executes(this::generateDataPack)))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)DataPackAction.APPLY.literal().requires(this::isSinglePlayerOwner)).executes(this::showUsage)).then(Commands.m_82129_((String)MODID_PARAM, (ArgumentType)StringArgumentType.word()).suggests(SUGGESTION_MODID).executes(this::applyDataPack)))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)DataPackAction.REMOVE.literal().requires(this::isSinglePlayerOwner)).executes(this::showUsage)).then(Commands.m_82129_((String)MODID_PARAM, (ArgumentType)StringArgumentType.word()).suggests(SUGGESTION_MODID).executes(this::removeDataPack)))));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"cwc").requires(this::hasPermission)).redirect((CommandNode)command));
    }

    private boolean hasPermission(CommandSourceStack source) {
        return source.m_6761_(2) || this.isSinglePlayerOwner(source);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isSinglePlayerOwner(CommandSourceStack source) {
        if (source.m_81377_().m_6982_()) return false;
        if (!source.m_81377_().m_129792_()) return false;
        if (Optional.ofNullable(source.m_81373_()).filter(ServerPlayer.class::isInstance).map(ServerPlayer.class::cast).map(Player::m_36316_).map(profil -> source.m_81377_().m_7779_(profil)).orElse(false) == false) return false;
        return true;
    }

    @SubscribeEvent
    public static void onRegisterCommands(RegisterCommandsEvent event) {
        new CommandWoodcutter().register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    private record WoodCompo(ResourceLocation plankName, boolean isPlankTag, @Nullable ResourceLocation logName, boolean isLogTag) {
        private static final WoodCompo ANY_WOOD = new WoodCompo(ItemTags.f_13168_.m_6979_(), true, ItemTags.f_13182_.m_6979_(), true);
    }

    private static enum BaseAction implements IAction
    {
        INFO,
        DATAPACK;

        private final String name = this.name().toLowerCase(Locale.US);

        public String m_7912_() {
            return this.name;
        }
    }

    private static enum DataPackAction implements IAction
    {
        GENERATE,
        APPLY,
        REMOVE;

        private final String name = this.name().toLowerCase(Locale.US);

        public String m_7912_() {
            return this.name;
        }
    }

    private static interface IAction
    extends StringRepresentable {
        default public LiteralArgumentBuilder<CommandSourceStack> literal() {
            return Commands.m_82127_((String)this.m_7912_());
        }
    }
}

